/*
 *  SABOUT.C
 *
 *  This module contains functions associated with the about dialog box
 *  in SAMPLE.EXE.
 *
 *  Copyright (C) 1991 by Daytris.  All rights reserved.
 */

#include <windows.h>
#include "sampledb.h"
#include "sample.h"


/************************************************
 * Function Declarations
 ************************************************/

void AboutDlg( HWND hWnd);
BOOL FAR PASCAL AboutProc( HWND hDlg, unsigned iMessage, WORD wParam,
    LONG lParam);


/***************************************************************************
 * Function : AboutDlg
 *
 * Purpose  : This function drives the About dialog box.
 *
 * Returns  : n/a
 ***************************************************************************/
void AboutDlg( HWND hWnd)
    {
    short nStatus;
    FARPROC lpfnAboutProc;

    /* Create an instance and open the About dialog */
    lpfnAboutProc = MakeProcInstance( AboutProc, hInst);
    nStatus = DialogBox( hInst, "about", hWnd, lpfnAboutProc);
    FreeProcInstance( lpfnAboutProc);
    }


/***************************************************************************
 * Function : AboutProc
 *
 * Purpose  : This function is the window procedure for the About dialog.
 *
 * Returns  : TRUE  - message processed
 *            FALSE - message not processed
 ***************************************************************************/
BOOL FAR PASCAL AboutProc( HWND hDlg, unsigned iMessage, WORD wParam,
    LONG lParam)
    {
    switch( iMessage)
        {
        case WM_COMMAND:
            switch( wParam)
                {
                case IDOK:
                case IDCANCEL:
                    EndDialog( hDlg, TRUE);
                    break;
                }
            return TRUE;
        }

    return FALSE;
    }
