/*
 *  TEST.C
 *
 *  Important:
 *
 *  This test program will only provide an example of how the CDB API is
 *  used.  Nothing will be displayed as a result of executing this module.
 *
 *  This program will add 3 customer records to the TEST database.
 *  Associated with each customer is an address record or records.  Each
 *  customer added will have at least 1 address record as a member.  After
 *  these records are added and the set connections are made, the program
 *  will use variations of CDB calls to retrieve these records.
 *
 *  This program is intended to be executed with a source level debugger.
 *  After each CDB call, display the status value returned.  Also, in
 *  cases where a record is being retrieved, display a dump of the record
 *  contents.  This will help you understand what is accomplished with
 *  each function call.
 *
 *  We are currently working on a fully functional application that uses
 *  CDB to give to our users as an example.
 *
 *
 *  Copyright (C) 1991 by Daytris.  All rights reserved.
 */

#include <stdio.h>
#include <stdlib.h>
#include "dbmgr.h"
#include "test.h"

int main( int argc, char **argv);
void DbError( INT status, INT lineNbr);


struct customer customer[3] =
    {
    {1000L,"Daytris",0.00},
    {1001L,"CompuServe",0.00},
    {1002L,"Microsoft",0.00},
    };

struct address address[4] =
    {
    {"81 Bright Street, Suite 1E","Jersey City","NJ","07302","2012000018"},
    {"2000 Arlington Center Blvd","Columbus","OH","43228","6144598600"},
    {"12 North Fork Ave.","Redmond","WA","55555","5332341234"},
    {"13 North Fork Ave.","Redmond","WA","55555","5332341235"},
    };


int main( int argc, char *argv[])
    {
    INT status;
    long acctNbr = 1001L;
    struct currency_index currency;
    struct customer t_customer;
    struct address t_address;

    /* Open the database */
    if( status = DbOpen( ".\\", "test.dbd"))
        {
        printf( "Error (%d) opening test.dbd\n", status);
        exit( 1);
        }

    /* Customer 1000 */
    if( status = DbRecordAdd( "customer", &customer[0]))
        DbError( status, __LINE__);
    if( status = DbRecordAdd( "address", &address[0]))
        DbError( status, __LINE__);
    if( status = DbSetAdd( "customer", "address"))
        DbError( status, __LINE__);

    /* Customer 1001 */
    if( status = DbRecordAdd( "customer", &customer[1]))
        DbError( status, __LINE__);
    if( status = DbRecordAdd( "address", &address[1]))
        DbError( status, __LINE__);
    if( status = DbSetAdd( "customer", "address"))
        DbError( status, __LINE__);

    /* Customer 1002 */
    if( status = DbRecordAdd( "customer", &customer[2]))
        DbError( status, __LINE__);
    if( status = DbRecordAdd( "address", &address[2]))
        DbError( status, __LINE__);
    if( status = DbSetAdd( "customer", "address"))
        DbError( status, __LINE__);
    if( status = DbRecordAdd( "address", &address[3]))
        DbError( status, __LINE__);
    if( status = DbSetAdd( "customer", "address"))
        DbError( status, __LINE__);

    /* Get the first customer by account number */
    if( status = DbRecordFindFirst( "customer", "acctNbr"))
        DbError( status, __LINE__);
    if( status = DbRecordGetCurrent( "customer", &t_customer))
        DbError( status, __LINE__);

    /* Save the currency */
    if( status = DbRecordGetCurrency( "customer", &currency))
        DbError( status, __LINE__);

    /* Get the last customer */
    if( status = DbRecordGetLast( "customer", "acctNbr", &t_customer))
        DbError( status, __LINE__);

    /* Get the addresses */
    if( status = DbSetFindFirst( "customer", "address"))
        DbError( status, __LINE__);
    if( status = DbSetGetFirst( "customer", "address", &t_address))
        DbError( status, __LINE__);
    if( status = DbSetGetNext( "customer", "address", &t_address))
        DbError( status, __LINE__);

    /* Restore the customer currency and retrieve the current customer */
    if( status = DbRecordUpdCurrency( "customer", &currency))
        DbError( status, __LINE__);
    if( status = DbRecordGetCurrent( "customer", &t_customer))
        DbError( status, __LINE__);

    /* Get customer 1001 */
    if( status = DbRecordGetByKey( "customer", "acctNbr", &t_customer, &acctNbr))
        DbError( status, __LINE__);

    /* Get address */
    if( status = DbRecordGetByKey( "address", "zip", &t_address, "55555"))
        DbError( status, __LINE__);

    /* Get the owner of the address */
    if( status = DbSetGetOwner( "customer", "address", &t_customer))
        DbError( status, __LINE__);

    if( status = DbFlush())
        DbError( status, __LINE__);
    if( status = DbClose())
        DbError( status, __LINE__);

    return status;
    }


void DbError( INT status, INT lineNbr)
    {
    printf( "File: %s, Line: %d, Database Error: %d\n", __FILE__, lineNbr,
        status);
    exit( status);
    }
