/*
 *  dbmgr.h
 *
 *  This file contains structures, macros and #defines for
 *  the database layout.
 *
 *  Copyright (C) 1989, 1990, 1991 by Daytris.  All rights reserved.
 */

typedef char            CHAR;
typedef unsigned char   UCHAR;
typedef short           INT;
typedef unsigned short  UINT;
typedef long            LONG;
typedef unsigned long   ULONG;

INT DbClose( void);
INT DbFlush( void);
INT DbOpen( CHAR *pDbDir, CHAR *pDbName);
INT DbRecordAdd( CHAR *pRecName, void *pData);
INT DbRecordDelete( CHAR *pRecName);
INT DbRecordFindByKey( CHAR *pRecName, CHAR *pFldName, void *pKey);
INT DbRecordFindFirst( CHAR *pRecName, CHAR *pFldName);
INT DbRecordFindLast( CHAR *pRecName, CHAR *pFldName);
INT DbRecordFindNext( CHAR *pRecName, CHAR *pFldName);
INT DbRecordFindPrev( CHAR *pRecName, CHAR *pFldName);
INT DbRecordGetByKey( CHAR *pRecName, CHAR *pFldName, void *pTarget, void *pKey);
INT DbRecordGetCurrency( CHAR *pRecName, void *pTarget);
INT DbRecordGetCurrent( CHAR *pRecName, void *pTarget);
INT DbRecordGetFirst( CHAR *pRecName, CHAR *pFldName, void *pTarget);
INT DbRecordGetLast( CHAR *pRecName, CHAR *pFldName, void *pTarget);
INT DbRecordGetNext( CHAR *pRecName, CHAR *pFldName, void *pTarget);
INT DbRecordGetPrev( CHAR *pRecName, CHAR *pFldName, void *pTarget);
INT DbRecordUpdate( CHAR *pRecName, void *pData);
INT DbRecordUpdCurrency( CHAR *pRecName, void *pData);
INT DbSetAdd( CHAR *pOwnerName, CHAR *pMemberName);
INT DbSetDelete( CHAR *pOwnerName, CHAR *pMemberName);
INT DbSetFindFirst( CHAR *pOwnerName, CHAR *pMemberName);
INT DbSetFindLast( CHAR *pOwnerName, CHAR *pMemberName);
INT DbSetFindNext( CHAR *pOwnerName, CHAR *pMemberName);
INT DbSetFindPrev( CHAR *pOwnerName, CHAR *pMemberName);
INT DbSetGetFirst( CHAR *pOwnerName, CHAR *pMemberName, void *pTarget);
INT DbSetGetLast( CHAR *pOwnerName, CHAR *pMemberName, void *pTarget);
INT DbSetGetNext( CHAR *pOwnerName, CHAR *pMemberName, void *pTarget);
INT DbSetGetOwner( CHAR *pOwnerName, CHAR *pMemberName, void *pTarget);
INT DbSetGetPrev( CHAR *pOwnerName, CHAR *pMemberName, void *pTarget);

INT cdb( INT, ...);

#define NBRHANDLES      12      /* Maximum number of file handles       */
#define MAXKEY          8       /* Maximum # of keys per key record     */
#define KEYPAGESIZE     512     /* Key page buffer size                 */
#define NBRPAGES        16      /* Number of key page buffers           */
#define DATAPAGESIZE    2048    /* Data page buffer size                */
#define DATASLOTSIZE    1024    /* Data file slot buffer size           */

/* Testdrive version defines */
#define TESTDRIVE_MAX_RECORDS   50L

/* Field index structure defines */
#define KEY_FIELD       0x01
#define SET_KEY_FIELD   0x01

/* Handle index structure defines */
#define FILE_MODIFIED   0x01

/* Key file index structure defines */
#define PAGE_FULL       0x01

/* Page index structure defines */
#define PAGE_DIRTY      0x01

/* Error defines */
#define E_TESTDRIVE     -3
#define E_INVALIDCASE   -2
#define E_DOS           -1
#define E_NORECNAME     1
#define E_NOFLDNAME     2
#define E_INVALIDSET    3
#define E_NOTAKEY       4
#define E_NOTFOUND      5
#define E_NEXTGUESS     6
#define E_NOCURRENT     7
#define E_NONEXT        8
#define E_NOPREV        9
#define E_NOMEMBER      10
#define E_NOOWNER       11

/* DBC call defines */
#define D_OPEN                  0
#define D_CLOSE                 1
#define D_FLUSH                 2
#define D_GET_CURRENCY          3
#define D_UPDATE_CURRENCY       4
#define D_FIND_FIRST_RECORD     5
#define D_FIND_LAST_RECORD      6
#define D_FIND_NEXT_RECORD      7
#define D_FIND_PREV_RECORD      8
#define D_FIND_RECORD_BY_KEY    9
#define D_GET_FIRST_RECORD      10
#define D_GET_LAST_RECORD       11
#define D_GET_NEXT_RECORD       12
#define D_GET_PREV_RECORD       13
#define D_GET_RECORD_BY_KEY     14
#define D_GET_CURRENT_RECORD    15
#define D_ADD_RECORD            16
#define D_UPDATE_RECORD         17
#define D_DELETE_RECORD         18
#define D_FIND_FIRST_SET        19
#define D_FIND_LAST_SET         20
#define D_FIND_NEXT_SET         21
#define D_FIND_PREV_SET         22
#define D_GET_FIRST_SET         23
#define D_GET_LAST_SET          24
#define D_GET_NEXT_SET          25
#define D_GET_PREV_SET          26
#define D_GET_SET_OWNER         27
#define D_ADD_SET               28
#define D_DELETE_SET            29

#if 0
/* DataBase Macros */
#define DbOpen(a)                       cdb(D_OPEN, a)
#define DbClose()                       cdb(D_CLOSE)
#define DbFlush()                       cdb(D_FLUSH)
#define DbRecordGetCurrency(a,b)        cdb(D_GET_CURRENCY,a,b)
#define DbRecordUpdCurrency(a,b)        cdb(D_UPDATE_CURRENCY,a,b)
#define DbRecordFindFirst(a,b)          cdb(D_FIND_FIRST_RECORD,a,b)
#define DbRecordFindLast(a,b)           cdb(D_FIND_LAST_RECORD,a,b)
#define DbRecordFindNext(a,b)           cdb(D_FIND_NEXT_RECORD,a,b)
#define DbRecordFindPrev(a,b)           cdb(D_FIND_PREV_RECORD,a,b)
#define DbRecordFindByKey(a,b,c)        cdb(D_FIND_RECORD_BY_KEY,a,b,c)
#define DbRecordGetFirst(a,b,c)         cdb(D_GET_FIRST_RECORD,a,b,c)
#define DbRecordGetLast(a,b,c)          cdb(D_GET_LAST_RECORD,a,b,c)
#define DbRecordGetNext(a,b,c)          cdb(D_GET_NEXT_RECORD,a,b,c)
#define DbRecordGetPrev(a,b,c)          cdb(D_GET_PREV_RECORD,a,b,c)
#define DbRecordGetByKey(a,b,c,d)       cdb(D_GET_RECORD_BY_KEY,a,b,c,d)
#define DbRecordGetCurrent(a,b,c)       cdb(D_GET_CURRENT_RECORD,a,b,c)
#define DbRecordAdd(a,b)                cdb(D_ADD_RECORD,a,b)
#define DbRecordUpdate(a,b)             cdb(D_UPDATE_RECORD,a,b)
#define DbRecordDelete(a)               cdb(D_DELETE_RECORD,a)
#define DbSetFindFirst(a,b)             cdb(D_FIND_FIRST_SET,a,b)
#define DbSetFindLast(a,b)              cdb(D_FIND_LAST_SET,a,b)
#define DbSetFindNext(a,b)              cdb(D_FIND_NEXT_SET,a,b)
#define DbSetFindPrev(a,b)              cdb(D_FIND_PREV_SET,a,b)
#define DbSetGetFirst(a,b,c)            cdb(D_GET_FIRST_SET,a,b,c)
#define DbSetGetLast(a,b,c)             cdb(D_GET_LAST_SET,a,b,c)
#define DbSetGetNext(a,b,c)             cdb(D_GET_NEXT_SET,a,b,c)
#define DbSetGetPrev(a,b,c)             cdb(D_GET_PREV_SET,a,b,c)
#define DbSetGetOwner(a,b,c)            cdb(D_GET_SET_OWNER,a,b,c)
#define DbSetAdd(a,b)                   cdb(D_ADD_SET,a,b)
#define DbSetDelete(a,b)                cdb(D_DELETE_SET,a,b)
#endif


/* DataBase structures and unions */
union  type
    {
    CHAR                charval;
    INT                 intval;
    LONG                longval;
    float               floatval;
    double              doubleval;
    CHAR                *ptrval;
    UCHAR               ucharval;
    UINT                uintval;
    ULONG               ulongval;
    };

struct dbheader                         /* 128 bytes                    */
    {               
    CHAR                title[96];      /* DBD title                    */
    UINT                totrecs;        /* Total number of records      */
    UINT                totowns;        /* Total number of owners       */
    UINT                totmems;        /* Total number of members      */
    UINT                totflds;        /* Total number of fields       */
    CHAR                prefix[6];      /* File prefix description      */
    CHAR                filler[18];
    };

struct record_index                     /* 46 bytes                     */
    {
    UINT                firstown;       /* First owner                  */
    UINT                nbrowns;        /* Number of owners             */
    UINT                firstmem;       /* First member                 */
    UINT                nbrmems;        /* Number of members            */
    UINT                firstfld;       /* First field                  */
    UINT                nbrflds;        /* Number of fields             */
    UINT                reclen;         /* Record length                */
    CHAR                recname[32];    /* Record name                  */
    };

struct owner_index                      /* 4 bytes                      */
    {
    UINT                nextown;        /* Next owner                   */
    UINT                ownnum;         /* Owner record number          */
    };

struct member_index                     /* 8 bytes                      */
    {
    UINT                nextmem;        /* Next member                  */
    UINT                memnum;         /* Member record number         */
    UINT                memkeyfld;      /* Key field number for set     */
    UINT                memflags;       /* Bit 0 - key field present    */
    };

struct field_index                      /* 40 bytes                     */
    {
    UCHAR               fldtype;        /* Field type  Bit 0 - char     */
                                        /*             Bit 1 - int      */
                                        /*             Bit 2 - short    */
                                        /*             Bit 3 - long     */
                                        /*             Bit 4 - float    */
                                        /*             Bit 5 - double   */
                                        /*             Bit 7 - unsigned */
    UINT                fldlen;         /* Field length                 */
    UINT                flddim;         /* Field dimension              */
    CHAR                fldname[32];    /* Field name                   */
    UINT                fldkey;         /* Key number of data struct    */
    UCHAR               fldflags;       /* Bit 0 - key field            */
    };

/* Field casting defines */
#define FLDTYPE_CHAR            0x01
#define FLDTYPE_INT             0x02
#define FLDTYPE_SHORT           0x04
#define FLDTYPE_LONG            0x08
#define FLDTYPE_FLOAT           0x10
#define FLDTYPE_DOUBLE          0x20
#define FLDTYPE_UNSIGNED        0x80

struct  key_file_index                  /* 32 bytes                     */
    {
    CHAR        name[12];               /* Key file name                */
    UINT        nextavailpage;          /* Next available page          */
    UINT        firstdelpage;           /* First page in the delete     */
                                        /* chain.                       */
    UINT        pagenbr[MAXKEY];        /* Key 1st page index           */
    };

struct  key_page_index                  /* 10 bytes                     */
    {
    UINT        prevpage;               /* Previous page in sort tree   */
    UINT        nextpage;               /* Next page in sort tree       */
    UINT        slotsused;              /* Number of slots used on page */
    UINT        slotsize;               /* Size of key slot             */
    UINT        flags;                  /* Bit 0 - page is full         */
    };

struct  data_file_index                 /* 32 bytes                     */
    {
    CHAR        name[12];               /* Data file name               */
    ULONG       nextavailslot;          /* Next available slot          */
    ULONG       firstdelslot;           /* First slot in the delete     */
                                        /* chain.                       */
    UINT        slotsize;               /* Size of data slot            */
    CHAR        filler[10];
    };

struct  data_slot_index                 /* 6 bytes                      */
    {
    UINT        offsettodata;           /* Offset to actual data        */
    ULONG       nextdel;                /* DBA of next member in the    */
                                        /* delete chain.                */
    };

struct  ownptr_index                    /* 8 bytes                      */
    {
    ULONG       firstmem;               /* Dba of first member          */
    ULONG       lastmem;                /* Dba of last member           */
    };

struct  memptr_index                    /* 12 bytes                     */
    {
    ULONG       owndba;                 /* Dba of owner record          */
    ULONG       prevmem;                /* Dba of prev member in chain  */
    ULONG       nextmem;                /* Dba of next member in chain  */
    };

struct handle_index                     /* 4 bytes                      */
    {
    INT         handle;                 /* Handle number                */
    UINT        flags;                  /* Bit 0 - set if modified      */
    };

struct page_index                       /* 520 bytes                    */
    {
    UINT        recnbr;                 /* Record number                */
    UINT        fldnbr;                 /* Field number                 */
    UINT        diskpagenbr;            /* Page number                  */
    CHAR        buffer[KEYPAGESIZE];    /* Data buffer                  */
    UINT        flags;                  /* Bit 0 - set if page is dirty */
    };

struct currency_index                   /* 36 bytes                     */
    {
    struct 
        {
        UINT    page;
        UINT    slot;
        } keydba[MAXKEY];               /* Array of key dba's           */
    ULONG       datadba;                /* Data database address        */
    };
