/* callpgm.c */
 
#include <stdio.h>
#include "ccl.h"
 
#define  ESC  0x1b
#define  CR   0x0d
#define  LF   0x0a
#define  MASK 0xff
 
char far RxBuf[512];   /* !!! Note that RxBuf[] is defined as FAR !!! */
 
char *BaudRate[10] = {"300","600","1200","2400","4800","9600",
                      "19200","38400","57600","115200"};
 
main(argc,argv)
int argc;
char *argv[];
{char c;
 int i, k;
 int n, rc;
 int delta;
 int status;
 int Port;
 int BaudCode;
 /* get port & baud rate from command line */
 if(argc!=3)
       {printf("Usage: 'CALLPGM port baud' -- example 'CALLPGM 1 9600'\n");
        exit(1);
       }
 Port = atoi(argv[1]) - 1;
 if((Port<0) || (Port>3))
       {printf("Port must be 1 to 4\n");
        exit(1);
       }
 BaudCode = BaudMatch(argv[2]);
 if(BaudCode<0)
       {printf("Cannot recognize baud rate = %s\n",argv[2]);
        exit(1);
       }
 /* setup receive buffer */
 rc = SioRxBuf(Port,RxBuf,Size512);
 if(rc<0)
       {SioError(rc);
        exit(1);
       }
 /* set parms & reset (initialize) the port */
 SioParms(Port,NoParity,OneStopBit,WordLength8);
 MyStart(Port,BaudCode);
 /* display status */
 Status(Port);
 /* set DTR and RTS */
 SioDTR(Port,'S');
 SioRTS(Port,'S');
 
 
 /*!!! You may have to remove next 8 lines if using a null modem cable !!!*/
 /* wait for DSR */
 printf("Waiting for DSR/CTS.");
 while( !SioModem(Port,DSR|CTS) )
       {
        if(SioKeyPress()||SioBrkKey()) MyExit(Port,0,"Aborted by user");
        putchar('.');
        SioDelay(18);
       }
 putchar('\n');
 
 Status(Port);
 printf("Entering terminal loop\n");
 SioRxFlush(Port);
 /* enter terminal loop */
 while(1)
       {/* Control-BREAK ? */
        if(SioBrkKey()) MyExit(Port,0,"User pressed Ctrl-BREAK");
        /* was key pressed ? */
        if(SioKeyPress())
              {i = SioKeyRead();
               if((char)i==ESC) MyExit(Port,0,"User pressed ESC");
               rc = SioPutc(Port,i);
               if(rc<0) MyExit(Port,rc,"Exit-A");
              }
        /* break detected ? */
        rc = SioBrkSig(Port,'D');
        if(rc<0) MyExit(Port,rc,"Exit-B");
        if(rc) MyExit(Port,0,"BREAK detected");
        /* any incoming over serial port ? */
        i = SioGetc(Port,0);
        if(i<-1) MyExit(Port,i,"Exit-C");
        if(i>-1) SioCrtWrite(MASK & i);
        /* any change in modem status ? */
        delta = SioModem(Port,DeltaDCD|DeltaRI|DeltaDSR|DeltaCTS);
        if(delta<0) MyExit(Port,delta,"Exit-D");
        if(delta)
              {
               putchar('\n');
               status = SioModem(Port,DCD|RI|DSR|CTS);
               if(status<0) MyExit(Port,status,"Exit-E");
               if(delta&DeltaDCD)
                     {if(status&DCD) c='T';
                      else c='F';
                      printf("DCD=%c ",c);
                     }
               if(delta&DeltaRI)
                     {if(status&RI)  c='T';
                      else c='F';
                      printf("RI=%c ",c);
                     }
               if(delta&DeltaDSR)
                     {if(status&DSR) c='T';
                      else c='F';
                      printf("DSR=%c ",c);
                     }
               if(delta&DeltaCTS)
                     {if(status&CTS) c='T';
                      else c='F';
                      printf("CTS=%c",c);
                     }
               putchar('\n');
              }
       } /* end -- key pressed */
}
 
int MyExit(Port,code,msg)
int Port;
int code;
char *msg;
{int rc;
 if(code<0) SioError(code);
 /* Assert UART break & sign off */
 SioBrkSig(Port,'A');
 printf("TERMINATING: %s\n",msg);
 SioDelay(8);
 if( (rc = SioDone(Port)) < 0 ) SioError(rc);
 exit(0);
}
 
int MyStart(Port,BaudCode)
int Port;
int BaudCode;
{int i, rc;
 for(i=0;i<5;i++)
  {printf("Resetting COM%d at %s baud\n",Port+1,BaudRate[BaudCode]);
   if( (rc = SioReset(Port,BaudCode))==0) return;
   if(rc<0) MyExit(Port,rc,"Exit-F");
   SioDone(Port);
   if(rc&OverrunError) puts("Overrun Error");
   if(rc&ParityError)  puts("Parity Error");
   if(rc&FramingError) puts("Framing Error");
   if(rc&BreakDetect)  puts("Break Detect");
  }
 exit(1);
}
 
int BaudMatch(ptr)
char *ptr;
{int i;
 for(i=0;i<10;i++) if(strcmp(BaudRate[i],ptr)==0) return(i);
 return(-1);
}
 
int Status(Port)
int Port;
{char c;
 int modem;
 int line;
 if( (modem = SioModem(Port,0xff)) < 0 ) MyExit(Port,modem,"Exit-G");
 if( (line = SioLine(Port)) < 0 ) MyExit(Port,line,"Exit-H");
 printf("COM%d: line=%x modem=%4x ",1+Port, line, modem );
 if(SioDTR(Port,'R') ) c='T'; else c='F'; printf(" DTR=%c ",c);
 if(SioRTS(Port,'R') ) c='T'; else c='F'; printf("RTS=%c ",c);
 if(DCD&modem) c='T'; else c='F';
 printf("DCD=%c ",c);
 if(RI&modem) c='T'; else c='F';
 printf("RI=%c ",c);
 if(DSR&modem) c='T'; else c='F';
 printf("DSR=%c ",c);
 if(CTS&modem) c='T'; else c='F';
 printf("CTS=%c\n",c);
}