/**************************** TECMAR.H **********************************/
/*	Tecmar driver header file.  Contains driver specific macros and	*/
/*  structures.								*/
/************************************************************************/

#include <dos.h>		/* Outport etc.				*/

#define MAX_MODES 1		/* The maximum number of modes.		*/
#define TECMAR_SEGMENT 0xA000	/* Where the screen memory is.		*/

				/* A macro to calculate the current	*/
				/*  addres from (x,y) position info.	*/
				/* y is modified by the macro.		*/
#define CALC_ADDR( x, y)   { bank_para_index = (y) & 3;\
		      current_bank = bank_para[bank_para_index].bank;\
		      outportb( 0x39a, current_bank);\
		      current_mask = mask[ (x)&1];\
		      (y) &= 0xfffc;\
		      current_address = screen_buffer + ((x) >> 1) +\
		      			(bank_para[bank_para_index]).para +\
					((y) << 4) + ((y) << 6);\
		    }

		    		/* A macro to change the current address*/
				/*  by 1 in the x direction.		*/
#define X_INCREMENT_CALC() { current_mask = ~current_mask;\
			     if( current_mask == (char)0xf0) {\
		                  current_address++;}\
			   }

		    		/* A macro to change the current address*/
				/*  by 1 in the y direction.		*/
#define Y_INCREMENT_CALC() { bank_para_index = (++bank_para_index) & 3;\
		      outportb( 0x39a, bank_para[bank_para_index].bank);\
		      current_address += bank_para[bank_para_index].yinc;\
		      }

		    		/* A macro to change the current address*/
				/*  by -1 in the y direction.		*/
#define Y_DECREMENT_CALC() { bank_para_index = (--bank_para_index) & 3;\
		      outportb( 0x39a, bank_para[bank_para_index].bank);\
		      current_address += bank_para[bank_para_index].ydec;\
		      }

		      		/* A macro to put a pixel of colour 	*/
				/*  colour on the screen at the current	*/
				/*  address.				*/
#define POINT( colour)	{ *current_address = ((*current_address) &\
		      			 ~current_mask) |\
			  ( (colour) & current_mask);\
		        }

		      		/* A macro to xor a pixel of colour 	*/
				/*  colour on the screen at the current	*/
				/*  address.				*/
#define XOR_POINT( colour) { *current_address = ((*current_address) &\
		      			 ~current_mask) |\
			   (((*current_address) ^ (colour))& current_mask);\
		           }

		      		/* A macro to read a pixel from the    	*/
				/*  screen at the current address.	*/
#define RD_POINT()	( (current_mask == (char)0xf0) ? ((*current_address\
                           & current_mask) >> 4) : (*current_address\
			   & current_mask)\
		        )

/* Combinations of the address calculation macros with the draw pixel	*/
/*  macro using the current colour.					*/

#define DRAW_POINT( x, y)   { CALC_ADDR( (x), (y));\
			      POINT( current_colour);\
		            }

#define X_INCREMENT_POINT() { X_INCREMENT_CALC();\
			      POINT( current_colour);\
		            }

#define Y_INCREMENT_POINT() { Y_INCREMENT_CALC();\
			      POINT( current_colour);\
		            }

#define Y_DECREMENT_POINT() { Y_DECREMENT_CALC();\
			      POINT( current_colour);\
		            }


struct BANK_PARA {		/* Bank/paragraph description.		*/
	unsigned char bank;	/* In Bank.				*/
	unsigned int yinc;	/* Add this much to get offset from	*/
				/*  previous line.			*/
	unsigned int ydec;	/* Add this much to get offset from 	*/
				/*  next line.				*/
	unsigned int para;	/* Which half of the bank.		*/
	};

extern const struct BANK_PARA bank_para[4];	/* An array of 4 of them*/
					/* describes all bank/paragraph	*/
					/* combinations.		*/
extern const unsigned char mask[2];	/* Two pixels/byte to mask.	*/

extern unsigned char far * const screen_buffer;	/* Point to base of	*/
						/*  video memory.	*/
extern unsigned char far *current_address; /* Current offset into video.*/
extern int current_bank, 		/* Current bank and paragraph.	*/
	   bank_para_index;
extern char current_mask;		/* Current pixel address.	*/
