/**************************** NN9.H *************************************/
/*	Revolution 1024 x 8 driver header file.  Contains driver 	*/
/*  specific macros and structures.					*/
/************************************************************************/

#include <dos.h>		/* MK_FP etc.				*/

typedef unsigned char far * SCREEN_PTR;

typedef struct {
  unsigned char length;			/* # of color entries in palette*/
  unsigned char colora[256*3];		/* Up to 256 color entries	*/
  } NN9PALETTE;

#define MAX_MODES 	1		/* The maximum number of modes.	*/

#define NN9_SEGMENT	0xa000
#define NN9_PALETTE     0xC100
#define BANKS		16

#define BANK_SWITCH      (MK_FP(0xC040, 0))

#define BANK_SELECT()	{\
			unsigned char far *bankSwitch = \
				(unsigned char far *)BANK_SWITCH;\
			*bankSwitch = current_bank;\
			}

				/* A macro to calculate the current	*/
				/*  address from (x,y) position info.	*/
#define CALC_ADDR( x, y)   { current_bank = (y) / 64;\
			     current_address = screen_buffer + 1 +\
			                       ((unsigned)(x)) + \
			     		 ((unsigned)((y) & 63)) * 1024u;\
			     BANK_SELECT();\
			   }


		    		/* A macro to change the current address*/
				/*  by 1 in the x direction.		*/
#define X_INCREMENT_CALC() { current_address++; }

		    		/* A macro to change the current address*/
				/*  by 1 in the y direction.		*/
#define Y_INCREMENT_CALC() { old_address = current_address;\
			     current_address += 1024;\
			     if( FP_OFF( current_address) < \
			         FP_OFF( old_address))\
				{\
				current_bank++;\
				BANK_SELECT();\
				}\
			   }

		    		/* A macro to change the current address*/
				/*  by -1 in the y direction.		*/
#define Y_DECREMENT_CALC() { old_address = current_address;\
			     current_address -= 1024;\
			     if( FP_OFF( current_address) > \
			         FP_OFF( old_address))\
				{\
				current_bank--;\
				BANK_SELECT();\
				}\
			   }

		      		/* A macro to put a pixel of colour 	*/
				/*  colour on the screen at the current	*/
				/*  address.				*/
#define POINT( colour)	{ *current_address = colour;}

		      		/* A macro to xor a pixel of colour 	*/
				/*  colour on the screen at the current	*/
				/*  address.				*/
#define XOR_POINT( colour) { *current_address = (*current_address) ^\
		      			 colour; }

		      		/* A macro to read a pixel from the    	*/
				/*  screen at the current address.	*/
#define RD_POINT()	( (unsigned char)*current_address)

/* Combinations of the address calculation macros with the draw pixel	*/
/*  macro using the current colour.					*/

#define DRAW_POINT( x, y)   { CALC_ADDR( (x), (y));\
			      POINT( current_colour);\
		            }

#define X_INCREMENT_POINT() { X_INCREMENT_CALC();\
			      POINT( current_colour);\
		            }

#define Y_INCREMENT_POINT() { Y_INCREMENT_CALC();\
			      POINT( current_colour);\
		            }

#define Y_DECREMENT_POINT() { Y_DECREMENT_CALC();\
			      POINT( current_colour);\
		            }


extern SCREEN_PTR const screen_buffer;	/* Point to base of video 	*/
					/*  memory.			*/
extern SCREEN_PTR current_address,	/* Current offset into video.	*/
		  old_address;		/* For Incrementing calc's.	*/
extern unsigned char current_bank;	/* Current bank.		*/


