ideal			; Set up in ideal mode
model	tiny		; This is done in tiny model

;******************* dispatch_textstyle **********************************
;  Interfaces BGI driver code to the calling interface.  Save old DS and 
;     sets up a new one for the driver to use.  Restores the old DS and
;     does a far return on exit.  It passes and returns the parameters in
;     the conventional 'C' fashion.  This makes it much easier to write
;     the main driver in C and let the compiler optimize to its hearts 
;     content.
;
;		INPUT:	ah	-- Font path & direction.
;			al	-- Font number.
;			bx	-- Requested X character size.
;			cx	-- Requested Y character size.
;
;		OUTPUT:	bx	-- Actual X character size.
;			cx	-- Actual Y character size.
;
;	V 1.00 26/06/89  Robert Adsett.
;	V 1.01 15/06/90  Robert Adsett.  Eliminate DOSSEG ordering.
;
;  (C) Robert Adsett 1989,1990
;*************************************************************************

codeseg			; Start of the code segment

;*************************************************************************
;	Declare publics and externals.
;*************************************************************************

extrn	_textstyle	: near		;external function, does actual 
					;  work.
public	dispatch_textstyle		;make this routine public so it
					;  can be hooked.


proc dispatch_textstyle  near

	push	cx			;Requested y character size.
	push	bx			;Requested x character size.
	mov	bl,al			;save al for later.
	mov	al,ah			
	xor	ah,ah
	push	ax			;Font path & direction.
	mov	al,bl
	push	ax			;Font number.
	call	_textstyle		;call 'C' driver
	add	sp,8			;restore stack
	mov	bx,dx			;Actual x character size.
	mov	cx,ax			;Actual ycharacter size.
	ret				;return to caller

endp

ends
end

