ideal			; Set up in ideal mode
model	tiny		; This is done in tiny model

;******************* _dispatch_set_page **********************************
;  Interfaces BGI driver code to the calling interface.  Save old DS and 
;     sets up a new one for the driver to use.  Restores the old DS and
;     does a far return on exit.  It passes the page parameter in the
;     conventional 'C' fashion.  This makes it much easier to write the
;     main driver in C and let the compiler optimize to its hearts 
;     content.  The function is prfixed with an underscore so that the
;     main driver can place it into a structure using C in a transparent
;     fashion.
;
;		INPUT:	al	-- page to make active
;
;		OUTPUT:	none
;
;	V 1.00 25/06/89  Robert Adsett.
;	V 1.01 15/06/90  Robert Adsett.  Eliminate DOSSEG ordering.
;
;  (C) Robert Adsett 1989,1990
;*************************************************************************

codeseg			; Start of the code segment

;*************************************************************************
;	Declare publics and externals.
;*************************************************************************

extrn	_set_page	: near		;external function, does actual 
					;  work.
extrn	STACK_SEG	:word
extrn	STACK_PTR	:word
extrn	regbx		:word
extrn	regdx		:word
extrn	regsi		:word
extrn	regdi		:word
extrn   _stack_		:word

public	_dispatch_set_page		;make this routine public so it
					;  can be hooked.


proc _dispatch_set_page  far

	push	ds			;save old ds
	push	cs
	pop	ds			;new ds = cs

	mov	[regbx],bx
	mov	[regdx],dx
	mov	[regsi],si
	mov	[regdi],di

	mov	dx,ds

        mov	di,ss
        mov	si,sp
	mov	[STACK_SEG],di
	mov	[STACK_PTR],si

	mov	bx, offset DGROUP:_stack_

;	Set the program stack

	cli			;Borland does not do this
	
	mov	ss, dx
      				; Problem due to small RAM size.
	mov	sp, bx		; Stack goes here.

	sti

	mov	bx,[regbx]
	mov	dx,[regdx]
	mov	si,[regsi]
	mov	di,[regdi]
;;;;

	xor	ah,ah			;don't let garbage in ah interfere
	push	ax			;page
	call	_set_page		;call 'C' driver
	add	sp,2			;restore stack
;;;;
	mov	si,[STACK_SEG]
	mov	di,[STACK_PTR]

	cli
	mov	ss,si
	mov	sp,di
	sti

	pop	ds			;restore ds
	ret				;return to caller

endp

ends
end


