ideal			; Set up in ideal mode
model	tiny		; This is done in tiny model

;******************* dispatch_install ************************************
;  Interfaces BGI driver code to the calling interface.  Save old DS and 
;     sets up a new one for the driver to use.  Restores the old DS and
;     does a far return on exit.  It passes and returns the parameters in
;     the conventional 'C' fashion.  This makes it much easier to write
;     the main driver in C and let the compiler optimize to its hearts 
;     content.
;
;		INPUT:	al	-- Install mode.
;			cx	-- Mode number.
;
;		OUTPUT:	cx	-- Number of modes.
;			bx	-- Stat block /name address.
;			es	-- Data segment.
;
;	V 1.00 28/06/89  Robert Adsett.
;	V 1.01 15/06/90  Robert Adsett.  Eliminate DOSSEG ordering.
;
;  (C) Robert Adsett 1989,1990
;*************************************************************************

codeseg			; Start of the code segment

;*************************************************************************
;	Declare publics and externals.
;*************************************************************************

extrn	_install	: near		;external function, does actual 
					;  work.
public	dispatch_install		;make this routine public so it
					;  can be hooked.


proc dispatch_install  near

	xor	ah,ah
	push	ax			;Install mode.
	push	cx			;Mode number.
	call	_install		;call 'C' driver
	add	sp,4			;Clean up stack.
	mov	bx,ax			;Possible address to return.
	mov	cx,dx			;Possible number to return.
	push	cs
	pop	es			;Data segment.
	ret				;return to caller

endp

ends
end



