ideal			; Set up in ideal mode
model	tiny		; This is done in tiny model

;******************* dispatch_init ***************************************
;  Interfaces BGI driver code to the calling interface.  Save old DS and 
;     sets up a new one for the driver to use.  Restores the old DS and
;     does a far return on exit.  It passes and returns the parameters in
;     the conventional 'C' fashion.  This makes it much easier to write
;     the main driver in C and let the compiler optimize to its hearts 
;     content.
;
;		INPUT:	es	-- DIT segment.
;			bx	-- DIT offset.
;
;		OUTPUT:	none
;
;	V 1.00 28/06/89  Robert Adsett.
;	V 1.01 15/06/90  Robert Adsett.  Eliminate DOSSEG ordering.
;
;  (C) Robert Adsett 1989,1990
;*************************************************************************

codeseg			; Start of the code segment

;*************************************************************************
;	Declare publics and externals.
;*************************************************************************

extrn	_init		: near		;external function, does actual 
					;  work.
public	dispatch_init			;make this routine public so it
					;  can be hooked.


proc dispatch_init  near

	push	es			;segment
	push	bx			;offset
	call	_init			;call 'C' driver
	add	sp,4			;Clean up the stack
	ret				;return to caller

endp

ends
end



