ideal			; Set up in ideal mode
model	tiny		; This is done in tiny model

;******************* _dispatch_getpix ************************************
;  Interfaces BGI driver code to the calling interface.  Save old DS and 
;     sets up a new one for the driver to use.  Restores the old DS and
;     does a far return on exit.  It passes and returns the parameters in
;     the conventional 'C' fashion.  This makes it much easier to write
;     the main driver in C and let the compiler optimize to its hearts 
;     content.  The function is prefixed with an underscore so that the
;     main driver can place it into a structure using C in a transparent
;     fashion.
;
;		INPUT:	ax	-- X coordinate of the pixel.
;			bx	-- Y coordinate of the pixel.
;
;		OUTPUT:	dl	-- Colour of the pixel.  Returned in ax
;				     by '_getpix'.
;
;	V 1.00 25/06/89  Robert Adsett.
;	V 1.01 15/06/90  Robert Adsett.  Eliminate DOSSEG ordering.
;
;  (C) Robert Adsett 1989,1990
;*************************************************************************

codeseg			; Start of the code segment

;*************************************************************************
;	Declare publics and externals.
;*************************************************************************

extrn	_getpix		: near		;external function, does actual 
					;  work.
extrn	STACK_SEG	:word
extrn	STACK_PTR	:word
extrn	regbx		:word
extrn	regdx		:word
extrn	regsi		:word
extrn	regdi		:word
extrn   _stack_		:word

public	_dispatch_getpix		;make this routine public so it
					;  can be hooked.


proc _dispatch_getpix  far

	push	ds			;save old ds
	push	cs
	pop	ds			;new ds = cs

	mov	[regbx],bx
	mov	[regdx],dx
	mov	[regsi],si
	mov	[regdi],di

	mov	dx,ds

        mov	di,ss
        mov	si,sp
	mov	[STACK_SEG],di
	mov	[STACK_PTR],si

	mov	bx, offset DGROUP:_stack_

;	Set the program stack

	cli			;Borland does not do this
	
	mov	ss, dx
      				; Problem due to small RAM size.
	mov	sp, bx		; Stack goes here.

	sti

	mov	bx,[regbx]
	mov	dx,[regdx]
	mov	si,[regsi]
	mov	di,[regdi]
;;;;

	push	bx			;Y coordinate
	push	ax			;X coordinate
	call	_getpix			;call 'C' driver
	add	sp,4			;restore stack
;;;;
	mov	si,[STACK_SEG]
	mov	di,[STACK_PTR]

	cli
	mov	ss,si
	mov	sp,di
	sti

	pop	ds			;restore ds
	mov	dl,al			;move return value to appropriate
					; register
	ret				;return to caller

endp

ends
end



