ideal			; Set up in ideal mode
model	tiny		; This is done in tiny model

;******************* dispatch_floodfill **********************************
;  Interfaces BGI driver code to the calling interface.  Save old DS and 
;     sets up a new one for the driver to use.  Restores the old DS and
;     does a far return on exit.  It passes and returns the parameters in
;     the conventional 'C' fashion.  This makes it much easier to write
;     the main driver in C and let the compiler optimize to its hearts 
;     content.
;
;		INPUT:	ax	-- X seed coordinate
;			bx	-- Y seed coordinate
;			cl	-- Boundary colour
;
;		OUTPUT:	none
;
;	V 1.00 25/06/89  Robert Adsett.
;	V 1.01 15/06/90  Robert Adsett.  Eliminate DOSSEG ordering.
;
;  (C) Robert Adsett 1989,1990
;*************************************************************************

codeseg			; Start of the code segment

;*************************************************************************
;	Declare publics and externals.
;*************************************************************************

extrn	_floodfill	: near		;external function, does actual 
					;  work.
public	dispatch_floodfill		;make this routine public so it
					;  can be hooked.


proc dispatch_floodfill  near

	xor	ch,ch
	push	cx			;Boundary colour.
	push	bx			;Y
	push	ax			;x
	call	_floodfill		;call 'C' driver
	add	sp,6			;restore stack
	ret				;return to caller

endp

ends
end



