ideal			; Set up in ideal mode
model	tiny		; This is done in tiny model

;******************* dispatch_color_query ********************************
;  Interfaces BGI driver code to the calling interface.  Save old DS and 
;     sets up a new one for the driver to use.  Restores the old DS and
;     does a far return on exit.  It passes and returns the parameters in
;     the conventional 'C' fashion.  This makes it much easier to write
;     the main driver in C and let the compiler optimize to its hearts 
;     content.
;
;		INPUT:	al	-- Type of query.
;
;		OUTPUT:	depends on command
;			bx	-- colour table size or address.
;			cx	-- may contain maximum colour number.
;			es	-- data segment = cs.
;
;	V 1.00 25/06/89  Robert Adsett.
;	V 1.01 15/06/90  Robert Adsett.  Eliminate DOSSEG ordering.
;
;  (C) Robert Adsett 1989,1990
;*************************************************************************

codeseg			; Start of the code segment

;*************************************************************************
;	Declare publics and externals.
;*************************************************************************

extrn	_color_query	: near		;external function, does actual 
					;  work.
public	dispatch_color_query		;make this routine public so it
					;  can be hooked.


proc dispatch_color_query  near

	xor	ah,ah			;Don't let garbage in ah interfere.
	push	ax			;X coordinate
	call	_color_query		;call 'C' driver
	add	sp,2			;restore stack
	mov	bx,ax			;table size or address
	mov	cx,dx			;Max colour value
	push	cs
	pop	es			;data segment address
	ret				;return to caller

endp

ends
end

