/**************************** ATI.H *************************************/
/*	Data Translation DT2851 driver header file.  Contains driver	*/
/*  specific macros and structures.					*/
/************************************************************************/

#include <dos.h>		/* Outport etc.				*/

#define OFF	0		/* Switch settings.			*/
#define ON	1

#define FEEDBACK	0	/* Operating modes for the card.	*/
#define LOAD_LUT 	4
#define SLOW_SCAN	5
#define PORT_OUT        6
#define PORT_IN         7

#define INCSR1	(base)		/* Registers to control the board.	*/
#define INCSR2	(base+2)
#define OUTCSR	(base + 4)
#define CURSOR	(base + 6)
#define INDEX	(base + 8)
#define INPUT_LUT_VALUE		(base + 0xA)
#define OUTPUT_LUT_REDGRN_VALUE	(base + 0xC)
#define OUTPUT_LUT_BLUE_VALUE	(base + 0xE)

				/* Set bit on a specific port.		*/
#define SET_BIT( port, mask, state) \
			(outport( (port), ((inport((port)) & mask) \
			                      | ((state) ? ~mask : 0))))

				/* Control the display.			*/
#define DISPLAY( state)		  SET_BIT( OUTCSR, 0xff7f, (state))

				/* Sync generated externally?		*/
#define EXT_TIME( state)	  SET_BIT( OUTCSR, 0xffdf, (state))

				/* Turn on boards overwhite cursor?	*/
#define SET_CURSOR(state)         SET_BIT( OUTCSR1, 0xffbf,(state))

				/* Generate interrrupt when done 	*/
				/*   operation?				*/
#define INTERRUPT_ON_DONE( state) SET_BIT( INCSR1, 0xffbf, (state))

				/* Stop operation.			*/
#define ENSTOP( state)		  SET_BIT( INCSR1, 0xfff7, (state))

				/* Start operation.			*/
#define BUSY( state)		  SET_BIT( INCSR1, 0xff7f, (state))

				/* What input Look-Up Table is being 	*/
				/*   used?				*/
#define INPUT_LUT( index)	  outport( INCSR1, (inport( INCSR1) \
                                              & 0xfff8) | ((index)&0x7))

				/* What output Look-Up Table is being 	*/
				/*   used?				*/
#define OUTPUT_LUT( index)	  outport( OUTCSR, (inport( OUTCSR) \
                                              & 0xfff8) | ((index)&0x7))

				/* What entry is visible?		*/
#define LUT_ENTRY( index)	  (outport( INDEX, (index)))

				/* Set entry for input LUT.		*/
#define INPUT_LUT_ENTRY( index, value) ( LUT_ENTRY( (index)), \
					outport( INPUT_LUT_VALUE, (value)))

				/* Set entry for red output LUT.	*/
#define OUTPUT_LUT_RED_ENTRY( index, value) ( LUT_ENTRY( (index)), \
				  outport( OUTPUT_LUT_REDGRN_VALUE, \
				  (inport( OUTPUT_LUT_REDGRN_VALUE) \
				  & 0xff00) | (value)))

				/* Set entry for green output LUT.	*/
#define OUTPUT_LUT_GREEN_ENTRY( index, value) ( LUT_ENTRY( (index)), \
				  outport( OUTPUT_LUT_REDGRN_VALUE, \
				  (inport( OUTPUT_LUT_REDGRN_VALUE) \
				  & 0x00ff) | ((value) << 8)))

				/* Set entry for blue output LUT.	*/
#define OUTPUT_LUT_BLUE_ENTRY( index, value) ( LUT_ENTRY( (index)), \
			      outport( OUTPUT_LUT_BLUE_VALUE, (value)))

				/* Read entry for red output LUT.	*/
#define INPUT_LUT_RED_ENTRY( index) ( LUT_ENTRY( (index)), \
				  inport( OUTPUT_LUT_REDGRN_VALUE) \
				  & 0x00ff)

				/* Read entry for green output LUT.	*/
#define INPUT_LUT_GREEN_ENTRY( index) ( LUT_ENTRY( (index)), \
				  ((inport( OUTPUT_LUT_REDGRN_VALUE) \
				  & 0xff00) >> 8))

				/* Read entry for blue output LUT.	*/
#define INPUT_LUT_BLUE_ENTRY( index) ( LUT_ENTRY( (index)), \
			      inport( OUTPUT_LUT_BLUE_VALUE))

			      	/* Set the card's operating mode.	*/
#define MODE( value)	outport( INCSR2, \
			(inport( INCSR2) & 0xff8f) | ((value & 0x7) << 4))

				/* Set the page digitised input goes to.*/
#define INPUT_PAGE( page)	  SET_BIT( INCSR2, 0xff7f, (page))

				/* Write protect bits on the card.	*/
#define WRITE_PROTECT( value)	  outport( INCSR2, \
			     (inport( INCSR2) & 0xfff0) | (value & 0xf))

			     	/* Display this page.			*/
#define DISPLAY_PAGE( page)	  SET_BIT( OUTCSR, 0xffef, (page))

				/* Go! Go! Go!				*/
#define PERFORM_OPERATION()	  ENSTOP( ON)


extern int  base;			/* Base port for the card.	*/
extern unsigned char line_buffer[ 512];	/* Buffer in real mode memory.	*/
extern int  graphics_mode;		/* Flag special drawing mode.	*/
extern unsigned int current_row;	/* Row, column.			*/
extern unsigned int current_column;
extern unsigned long page_offset;	/* Basically drawing page.	*/


typedef struct {
  unsigned char length;			/* # of color entries in palette*/
  unsigned char colora[256*3];		/* Up to 256 color entries	*/
  } NN9PALETTE;

#define MAX_MODES 	1	/* The maximum number of modes.		*/
#define MAX_COLOURS 	256	/* The maximum number of colours.	*/

				/* Copy real memory row to the card.	*/
#define ROW_UPDATE()	{\
			copy_to_extended( 0xA00000L + 512L*current_row + \
					  page_offset, line_buffer, 256);\
			}

				/* Copy row from the card to real 	*/
				/*  memory.				*/
#define GET_ROW()	{\
			copy_from_extended( line_buffer, 0xA00000L + \
					    512L*current_row + page_offset,\
					    256);\
			}
				/* A macro to calculate the current	*/
				/*  address from (x,y) position info.	*/
#define CALC_ADDR( x, y)   {\
			   if( y != current_row)\
			       {\
			       if( graphics_mode)\
			           { ROW_UPDATE();}\
			       current_row = y;\
			       GET_ROW();\
			       }\
			   current_column = x;\
			   }


		    		/* A macro to change the current address*/
				/*  by 1 in the x direction.		*/
#define X_INCREMENT_CALC() { current_column++; }

		    		/* A macro to change the current address*/
				/*  by 1 in the y direction.		*/
#define Y_INCREMENT_CALC() { \
			   current_row++;\
			   GET_ROW();\
			   }

		    		/* A macro to change the current address*/
				/*  by -1 in the y direction.		*/
#define Y_DECREMENT_CALC() { \
			   current_row--;\
			   GET_ROW();\
			   }

		      		/* A macro to put a pixel of colour 	*/
				/*  colour on the screen at the current	*/
				/*  address.				*/
#define POINT( colour)	{ \
			line_buffer[current_column] = colour;\
			if( !graphics_mode)\
			    { ROW_UPDATE();}\
			}

		      		/* A macro to xor a pixel of colour 	*/
				/*  colour on the screen at the current	*/
				/*  address.				*/
#define XOR_POINT( colour) { \
			   line_buffer[current_column] ^= colour;\
			   if( !graphics_mode)\
			        { ROW_UPDATE();}\
			   }
		      		/* A macro to read a pixel from the    	*/
				/*  screen at the current address.	*/
#define RD_POINT()	( line_buffer[current_column])

/* Combinations of the address calculation macros with the draw pixel	*/
/*  macro using the current colour.					*/

#define DRAW_POINT( x, y)   { CALC_ADDR( (x), (y));\
			      POINT( current_colour);\
		            }

#define X_INCREMENT_POINT() { X_INCREMENT_CALC();\
			      POINT( current_colour);\
		            }

#define Y_INCREMENT_POINT() { Y_INCREMENT_CALC();\
			      POINT( current_colour);\
		            }

#define Y_DECREMENT_POINT() { Y_DECREMENT_CALC();\
			      POINT( current_colour);\
		            }




