; ************************************************************************
; File: Device.inc
;
; Copyright (c) 1988,1989  Borland International, Inc.
; Copyright (c) 1989,1990  R. Adsett 
;
; Purpose: define all the strucs/macros for the BGI interface
;	Heavily modified to provide a transparent C interface.
;
; Last Update: 15/06/90
;
; Updates: 30/09/88 -- Original
;	   22/06/89 -- Add stack switching logic so that a C interface can
;			be used without fear.  Requires the external word
;			_STACK_ which resides just before the end of the
;			driver stack.
;	   15/06/90 -- Change from ideal mode back to normal MASM syntax.
;			Avoid the use of the simplified model and segment
;			directives since the segment order has to be 
;			changed from the default DOSSEG ordering.  See
;			C0CBGI.ASM for a more complete explanation.  Also
;			some cosmetic changes.
;
; ************************************************************************

callBGI macro	p

	ifndef	BGI_add				; long call device driver ovr
	extrn	BGI_add:dword			; though pointer to driver
	endif
	mov	si,$&p				; (si) is the function code
	call	dword ptr BGI_add

endm

BGIstat macro	p				; get es:<si> --> ddo status
	ifndef	stable
	extrn	stable:dword
	endif
	les	si,cs:dword ptr stable		; get location of status to si
	add	si,$&p				; offset to correct location
endm

; **********************************************************************

; The following macro builds the required BGI header block

BGI	macro	name

EXTRN _stack_:WORD			; Where the stack is.

;;
;; Needed by other routines that do a stack switch.
;;

public	STACK_SEG			; Save SS:SP for stack switch
public	STACK_PTR
public	regbx	 			; These registers are overwritten
public	regdx	 			;   during the stack switch.  
public	regsi	 			;   They are saved here so they
public	regdi	 			;   can be restored.

					; the following builds
	public	name			; the required ddo header block
name	proc	far			; the vector table must be at
					; 'ddovec' if vector not speced
	push	ds			; (push ds, push cs are signature)
	push	cs			; make ds=cs
	pop	ds
	cld				; just in case
	push	bp			; 6 bytes

	call	dispatch

	nop

	pop	bp
	pop	ds			; restore
	ret				; far
endp
	db	'CB'			; just for fun
	dw	?
EMULATE2:ret				; emulate function (nop until
	dw	0,0			; patched by loader)
RESERVED:
NONE:	ret				; near ret for unused functions

STACK_SEG dw 0				; Save SS:SP for stack switch
STACK_PTR dw 0
regbx	dw	0			; These registers are overwritten
regdx	dw	0			;   during the stack switch.  
regsi	dw	0			;   They are saved here so they
regdi	dw	0			;   can be restored.

;;;;

dispatch	proc	near		;Perform the stack switch and 
					;call the desired routine.
	mov	[regbx],bx		;Save incoming registers.
	mov	[regdx],dx
	mov	[regsi],si
	mov	[regdi],di

	mov	dx,ds			;dx = ds = cs

        mov	di,ss			;Save old SS:SP
        mov	si,sp
	mov	[STACK_SEG],di
	mov	[STACK_PTR],si

	mov	bx, offset DGROUP:_stack_	;New stack is where?

;;	Set up the driver stack

	cli				;In case we have an old CPU.
	
	mov	ss, dx			; Stack goes here.
	mov	sp, bx

	sti				;Back to normal.

	mov	bx,[regbx]		;Restore all those registers.
	mov	dx,[regdx]
	mov	si,[regsi]
	mov	di,[regdi]
;;;;

	call	[DDOVEC+si]		; call the local function
;;;;
	mov	si,[STACK_SEG]		;Old stack was where?
	mov	di,[STACK_PTR]

	cli				;In case we have an old CPU.
	mov	ss,si			;Restore Old stack.
	mov	sp,di
	sti
	ret
;;;;
endp

EMULATE	proc	near			;Kernal can't handle a switched
					;stack so...
	mov	si,[STACK_SEG]		;Restore stack.
	mov	di,[STACK_PTR]

	cli
	mov	ss,si
	mov	sp,di
	sti

	mov	bx,[regbx]		;Restore registers.
	mov	dx,[regdx]
	mov	si,[regsi]
	mov	di,[regdi]
	jmp	EMULATE2		;call kernal emulator

endp

endm

; ************** the device driver vector table definition **************

$ddo		struc

$install	dw	?	; install device.
				; required to return es:<bx> to status table.

$init		dw	?	; (bh)=texture (bl)= background color to use.
				; ready device for output.
				; es:[di] --> rotate,xclip1,yclip1,xclip2,yclip2

$clear		dw	?	; clear graphics device and ready it for
				; output.

$post		dw	?	; make picture visible. used for making
				; printer bitmaps visible, for unloading
				; the plotter pen, or for restoring screen.

$move		dw	?	; used by text, arc, symbol, draw, fill etc.
				; set c.p. (ax,bx) = (x,y)

$draw		dw	?	; draw to (ax,bx) = (x,y)

$vect		dw	?	; (ax,bx,cx,dx) = x0,y0,x1,y1

$poly		dw	?	; draw polygon.
				; ax=0 start new polygon definition
				; ax=1 close and trace poly
				; ax=2 close,  fill poly and trace
				; ax=3 close and fill poly
				; ax=4 draw points and don't capture
				; ax=5 turn off polygon capture
				; ax=6 draw polygon at es:[bx] and (cx) points
				; ax=7 fill & trace polygon at es:[bx] with (cx) points
				; ax=8 fill polygon at es:[bx] with (cx) points

$dbar		dw	?	; bar fill (cpx,cpy,ax,bx)=x0,y0,x1,y1
				; (bx,cx)=dx,dy for 3d (with outline)

$patbar		dw	?	; pattern bar (no outline)

$darc		dw	?	; draw arc

$piesl		dw	?	; (ax,bx)= start ang, end ang
				; (cx,dx)= x radius, y radius
				; center is a cp. (with outline)

$fellipse	dw	?	; (ab,bx) = x radius, yradius
				; (no outline)

$palette	dw	?	; load a palette entry
				; (ax)=entry # (bx)=value
				; if (ax)=-1 set background

$allpalette	dw	?	; load the full palette
				; es:[bx] --> palette array

$color		dw	?	; set active draw color & pattern fill color
				; (al)= draw (trace) color (ah)=fill color

$fstyle		dw	?	; (al)=fill pattern #
				; (al)=0 no fill, 1 solid ...
				; (ah)=background color (normally 0)
				; (used only if pattern in al > 80h)
				; if (al)=ff es:<bx>--> pattern definition

$lstyle		dw	?	; (al)=0(solid) 1(dotted) 2(centerline) 3(dash)
				; 4(use pattern) (bx)=bit pattern
				; (cx)=line width (normally one)

$tstyle		dw	?	; (al)=font (ah)=style
				; (bx)=x charsize (cx)=y charsize
				; if (al)=ff es:<bx>--> font definition table
				; changes all params to those available.

$text		dw	?	; draw text. es:<bx> --> <string>, (0)

$textsize	dw	?	; text length.

$textinfo	dw	?	; extended text settings.

$flood		dw	?	; floodfill (ax,bx) = x,y seed coordinate.

$getpix		dw	?	; read pixel @(ax,bx) to (dl)

$putpix		dw	?	; put (dl) to pixel @(ax,bx)

$bitmaputil	dw	?	; returns (es:[bx]) = bitmap utilities.
				;	dw gotographic
				;	dw exitgraphic
				;	dw putpix
				;	dw getpix
				;	dw pixelsperbyte
				;	dw setwritemode

$savebitmap	dw	?	; es:[bx]--> buffer to save bitmap to.
				; contain bitmap size (pixels) in 1st 2 words
				; cx = start x	dx = start line # y


$restorebitmap	dw	?	; es:[bx]--> bitmap buffer to restore.
				; contains bitmap size (pixels) in 1st 2 words
				; cx=start x dx= start y to put
				; (al) = bitblt op (copy, xor, comp, etc.)

$setclip	dw	?	; extended function to set clip window
				; (ax,bx)-(cx,dx) = clip rectangle

$query_color	dw	?	; extended function for color information

$escape		dw	?	; escape function for direct i/o

$symbol		dw	?	; draw symbol (al) = symbol #
				; if (al)=ff es:<bx>--> symbol definition

$reserve	dw	?	; 32 reserved entry points

$user		dw	?	; User available entry points

ends

; ************** the device driver status table definition **************

$status		struc

$stat	db	0		; 0 = no errors
$devtyp db	0		; device type 0=screen 1=printer 2=plotter
$xres	dw	639		; full resolution
$yres	dw	199
$xefres dw	639		; effective resolution
$yefres dw	199
$xinch	dw	9000		; device size in inches*1000
$yinch	dw	7000
$aspec	dw	21200		; aspect ratio
$chsiz	dw	808h		; standard char size x,y (points)
$coltbl dw	9090h		; color tables
ends

; **********************************************************************
; this struc defines the info struc returned from the
; bgi bitmaputil function call @(es:[bx])
$bitmapinfo		struc
$gotographic	dw	?
$exitgraphic	dw	?
$putpixel	dw	?
$getpixel	dw	?
$bitsperpixel	dw	?
$setpage	dw	?	; draw page in (al)
$setvisual	dw	?	; visual display page (al)
$setwritemode	dw	?	; set write mode (al)
ends


