/********************************** BGI.H *******************************/
/*	BGI driver header file.  Contains defines and prototypes 	*/
/* specific to driver development.					*/
/*									*/
/*	V 1.00 20/05/90 Robert Adsett Release version.  Clean up 	*/
/*				comments.				*/
/*	V 1.10 27/05/90 Robert Adsett Add Extended memory functions for	*/
/*				use with AT class computers with video	*/
/*				card memory mapped above the 1M mark.	*/
/************************************************************************/

#define OUT_OF_RANGE -1			/* Error in clip.		*/

#define COPY		0		/* Drawing modes.		*/
#define XOR		1
#define OR		2
#define AND		3
#define NEGATE		4

#define NORMAL_PATH	0		/* Character paths.		*/
#define VERT_PATH	1
#define DOWN_PATH	2		/* O.K. But what do they mean 	*/ 
					/*   by down?			*/

#define SOLID_LINE	0      		/* Solid Line Style.		*/
#define DOTTED_LINE	1		/* Dotted Line.			*/
#define CENTRE_LINE	2		/* Centre Line.			*/
#define DASHED_LINE	3		/* Dashed line.			*/
#define USER_LINE	4		/* User-defined line style.	*/

		/*   These are equivalent to the Borland srrors of the	*/
		/* same name.						*/
#define	grOk		      0
#define	grNoInitGraph	     -1
#define	grNotDetected	     -2
#define	grFileNotFound	     -3
#define	grInvalidDriver      -4
#define	grNoLoadMem	     -5
#define	grNoScanMem	     -6
#define	grNoFloodMem	     -7
#define	grFontNotFound	     -8
#define	grNoFontMem	     -9
#define	grInvalidMode	    -10
#define	grError 	    -11   	/* Generic error.		*/
#define	grIOerror	    -12
#define	grInvalidFont	    -13
#define	grInvalidFontNum    -14
#define	grInvalidVersion    -18

typedef void far (*FRFPTR)( void );	/* Pointer to Void/Void Funct	*/
typedef void  (*NRFPTR)( void );	/* Pointer to Void/Void Funct	*/

/*									*/
/*	The following C structure defines a Device Status Block.	*/
/*									*/

typedef struct {
  char   stat;				/* Current device status.	*/
  unsigned char   devtype;		/* Device Type Identifier.	*/
  unsigned int	  xres;			/* Device Full Resolution in X	*/
  unsigned int	  yres;			/* Device Full Resolution in Y	*/
  unsigned int	  xefres;		/* Device Effective X Resolution*/
  unsigned int	  yefres;		/* Device Effective Y Resolution*/
  unsigned int	  xinch;		/* Device X Size in inches*1000 */
  unsigned int	  yinch;		/* Device Y Size in inches*1000 */
  unsigned int	  aspec;		/* Aspect Ratio * 10000		*/
  unsigned char   chsizx;		/* Standard char size X		*/
  unsigned char   chsizy;		/* Standard char size Y		*/
  unsigned char   fcolors;		/* Number of foreground colors	*/
  unsigned char   bcolors;		/* Number of background colors	*/
} STATUS;

/*									*/
/*	The following structure defines a palette record.		*/
/*									*/

typedef struct {
  unsigned char length;			/* # of color entries in palette*/
  unsigned char color[16];		/* Up to 16 color entries	*/
  } PALETTE;

/*									*/
/*	The following structure defines a utility function table.	*/
/*									*/

typedef struct {
  NRFPTR  goto_graph;			/* Enter graphics mode function */
  NRFPTR  exit_graph;			/* Leave graphics mode function */
  NRFPTR  putpix;			/* Write a pixel function	*/
  NRFPTR  getpix;			/* Read a pixel function	*/
  NRFPTR  bits_per_pixel;		/* Bits per pixel value		*/
  NRFPTR  set_page;			/* Set the active drawing page	*/
  NRFPTR  set_visual;			/* Set the active display page	*/
  NRFPTR  write_mode;			/* Set the current write mode	*/
  } UTILITIES;

/*									*/
/*	Device information table structure.				*/
/*									*/

struct DIT {
	unsigned char	background;
	unsigned char   init;
	char dummy[64];
	};

/*  Bitmap characters definition format.				*/
typedef struct { unsigned char row[8]; } CHAR_TABLE_ENTRY;

/*  Fillpattern definition format.					*/
typedef struct { unsigned char row[8]; } FILLPATTERN;

extern int MAXY, MAXX, MINY, MINX;	/* Clipping limits.		*/
extern unsigned int CP_X, CP_Y;		/* Current position.		*/
extern unsigned int char_size, char_path; /* Character size & path.	*/
extern unsigned char current_colour, 	/* Current draw,		*/
		     fill_colour, 	/* fill, and			*/
		     background_colour;	/* background colours.		*/
extern unsigned int current_line_style;	/* Current line style.		*/
extern int current_line_width;		/* Current line width.		*/
extern const unsigned int line_style_mask[16];	/* Bit mask for line	*/
						/*  style.		*/
extern int current_write_mode;		/* Current draw mode.		*/
extern const CHAR_TABLE_ENTRY far * const char_def;
					/* Pointer to Char defs in ROM.	*/
extern const FILLPATTERN def_patterns[12];   /* Standard fill patterns.	*/

/* Function prototype for the driver functions.  Required functions.	*/

long install( 			/* Install, but do not init device.	*/
	unsigned int mode, 	/* Mode to operate in/guery name of.	*/
	char command 		/* Subcommand (Install, query, name).	*/
	);			/* Return varies with subcommand.	*/

void init( 			/* Init (maybe) the device.		*/
	unsigned int dit_offset,/* Address of Device Information Table.	*/
	unsigned int dit_segment
	);
void clear( void );		/* Clear screen. 			*/
void post( void );		/* Back to test mode.			*/
void move(			/* Move to new current position (CP).	*/ 
	int x, 			/* Coordinates of new position.		*/
	int y
	);
void draw(			/* Draw a line from CP to a new CP.	*/
	int x,			/* Coordinates to draw to, becomes new 	*/
	int y			/*   CP.				*/
	);
void vect(			/* Draw a line.				*/
	int x1,			/* Starting point.			*/
	int y1,
	int x2,			/* Ending point.			*/
	int y2
	);
void patbar(			/* Draw but don't outline area.  Use	*/
	int x1,			/* current pattern.			*/
	int y1,			/* Upper left corner.			*/
	int x2,			/* Lower right corner.			*/
	int y2
	);
void palette( int flag_index, int red_colour,  int blue, int green);
void allpalette( unsigned int pptr_offset, unsigned int pptr_segment);
void color(			/* Set new drawing colours.		*/
	char new_fill_colour,	/* Colour to fill with.			*/
	char new_draw_colour	/* Colour to draw with.			*/
	);
void fillstyle(			/* Set current fillstyle.		*/
	unsigned char pattern,	/* Pattern, 0xff -> user defined.	*/
	unsigned int pptr_offset,	/* Address of user defined	*/
	unsigned int pptr_segment	/* pattern.			*/
	);
void linestyle(			/* Set current linestyle.		*/
	char style,		/* Line pattern.			*/
	int pattern,		/* User defined pattern.		*/
	int width		/* Line width (1, 3).			*/
	);
long textstyle(			/* Set text style.			*/
	char number,		/* Font number.				*/
	char path,		/* Drawing path.			*/
	int xsize,		/* Requested X size.			*/
	int ysize		/* Requested Y size.			*/
	);			/* Returns actual x/y size in 		*/
				/*  upper/lower int of a long.		*/
void text(			/* Draw text.				*/
	int length,		/* Number of characters.		*/
	unsigned int offset,	/* Pointer to string.			*/
	unsigned int segment
	);
void floodfill(			/* Flood fill an area.			*/
	int x,			/* Seed point.				*/
	int y,
	unsigned char boundary	/* Colour of the boundary.		*/
	);
void *bitmaputil( void );	/* Return a pointer to the bit map	*/
				/*  utility table.			*/
void restorebitmap(		/* Restore a bit map.			*/
	char mode,		/* Write mode.				*/
	unsigned int segment,	/* Bitmap buffer address.		*/
	unsigned int offset,
	int x1,			/* Where to put it.			*/
	int y1,
	int x2,
	int y2
	);
void savebitmap(		/* Save a bitmap.			*/
	unsigned int buff_segment,	/* Bitmap buffer address.	*/
	unsigned int buff_offset,
	int x1,			/* Where to get it from.		*/
	int y1,
	int x2,
	int y2
	);
void setclip(			/* Set a clipping area.			*/
	int x1,			/* Corners to clip to.			*/
	int y1,
	int x2,
	int y2
	);
char get_pixel(			/* Get the colour of the pixel.		*/
	int x,			/* At...				*/
	int y
	);			/* Returns the colour.			*/
void set_pixel(			/* Set the colour of a pixel.		*/
	int x,			/* At...				*/
	int y,
	char colour		/* Colour to set it to.			*/
	);
long textsiz(			/* Get the (pixel) length of a string.	*/
	int length,		/* Number of characters in the string.	*/
	unsigned int offset,	/* Address of the string.		*/
	unsigned int segment
	);
long color_query(		/* Get colour info.			*/
	char command_type	/* Type of info wanted.			*/
	);			/* Returns the pointer to the default 	*/
				/*   palette or the palette size.	*/

int line( int X, int Y, int X1, int Y1);
/************************************************************************/
/*  Bit map utility functions.						*/
/************************************************************************/
void enter_graphics( void );	/* Enter pixel graphics mode.		*/
void leave_graphics( void );	/* Leave pixel graphics mode.		*/
int  bits_per_pixel( void );	/* Return the number of bits per pixel. */
void putpix(			/* Draw a pixel.			*/
	int x,			/* At ..				*/
	int y,
	char colour		/* Colour of the pixel.			*/
	);
char getpix(			/* Read a pixel at a point.		*/
	int x,			/* Here...				*/
	int y
	);			/* Returns colour of the pixel.		*/
void set_page( char page);	/* Set the active drawing page.		*/
void set_visual( char page);	/* Set the active display page.		*/
void set_write_mode( int mode);	/* Set the current writeing mode.	*/
/************************************************************************/
/*  End bit map utility functions.					*/
/************************************************************************/

/*	These are shell functions.  These are actually	*/
/*	far functions.  We are labelling as near for	*/
/*	convienence in setting up vectors in the bitmap	*/
/*	utility table.					*/

void dispatch_enter_graphics( void);
void dispatch_leave_graphics( void);
void dispatch_putpix( void);
void dispatch_getpix( void);
void dispatch_set_page( void);
void dispatch_set_visual( void);
void dispatch_set_write_mode( void);
void dispatch_bits_per_pixel( void);

/* Utility functions.  Available for your use.				*/

void xor_mem( void far *, int, void far *, int);
void or_mem( void far *, int, void far *, int);
void and_mem( void far *, int, void far *, int);
void neg_mem( void far *, int, void far *, int);
void copy_mem( void far *, int, void far *, int);
void set_mem( void far *, unsigned, unsigned);

int copy_from_extended( 	/* Copy from extended to regular memory.*/
        void far *destination, 	/* Destination address.			*/
	unsigned long source,	/* Source address, absolute form.	*/
	int words		/* Number of words to transfer.		*/
	);

int copy_to_extended( 		/* Copy from regular to extended memory.*/
        unsigned long destination,  /* Destination address, absolute form.*/
	void far *source, 	/* Source address.			*/
	int words		/* Number of words to transfer.		*/
	);
