/*
 +---------------------------------------------------------------------+
 | Demonstration program which illustrates the usage of the VGA16.BGI  |
 | graphics device driver.                                             |
 |                                                                     |
 | Author: John Sieraski                                               |
 | Date:   2/23/90                                                     |
 +---------------------------------------------------------------------+
*/

#include <graphics.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <string.h>

/* function prototypes */

int huge detectVGA(void);
void checkerrors(void);
void wait(void);
void box_demo(void);
void cir_demo(void);
void page_demo(void);
void line_demo(void);
void random_lines(void);

int gdriver, gmode;

main()
{
   gdriver = installuserdriver("VGA16", detectVGA);
   while (1)
   {
      gdriver = DETECT;
      checkerrors();
      initgraph(&gdriver, &gmode, "");
      checkerrors();
      box_demo();
      cir_demo();
      page_demo();
      line_demo();
      random_lines();
      closegraph();
   }
   return 0;
}

/* detects EGA or VGA cards */
int huge detectVGA(void)
{
   #define ESC '\x1B'

   int driver, mode;
   char numstr[2] = {NULL, NULL};
   char ch;

   clrscr();

   while (kbhit())
      ch = getch(); /* clear keyboard buffer */

   detectgraph(&driver, &mode);
   switch (driver)
   {
      case VGA : cputs("9 : (800x600) SOTA VGA-16 16 color\r\n");
                 cputs("8 : (800x600) Video7 16 color\r\n");
                 cputs("7 : (800x600) Vega 16 color\r\n");
                 cputs("6 : (800x600) Paradise 16 color\r\n");
                 cputs("5 : (800x600) Orchid 16 color\r\n");
                 cputs("4 : (800x600) ATI 16 color\r\n");
                 cputs("3 : (640x480) VGA 16 color\r\n");
      case EGA : cputs("2 : (640x350) EGA/VGA 16 color\r\n");
                 cputs("1 : (640x200) EGA/VGA 16 color\r\n");
                 cputs("0 : (320x200) EGA/VGA 16 color\r\n");
                 cputs("------------------------------\r\n");
                 break;
      default  : return grError;
   }
   cputs("Which mode?, Esc to quit:");
   ch = getch();
   if (ch == ESC)
      exit(0);
   numstr[0] = ch;
   mode = atoi(numstr);
   if ( ((mode == 0) && (numstr[0] != '0')) || ((mode > 9) || (mode < 0)) )
   {
      cputs("\r\n\r\nError: Illegal mode value entered.\r\n");
      cputs("Press any key to halt:");
      getch();
      exit(1);
   }
   else
      return mode;
   return 0;
}

/* check for and report any graphics errors */
void checkerrors(void)
{
   int errorcode;

   /* read result of last graphics operation */
   errorcode = graphresult();
   if (errorcode != grOk)  /* an error occurred */
   {
      printf("Graphics error: %s\n", grapherrormsg(errorcode));
      printf("Press any key to halt:");
      getch();
      exit(1); /* terminate with an error code */
   }
}

/* wait for a keystroke, then clear the screen */
void wait(void)
{
   getch();
   cleardevice();
}

/* demonstrate setting the foreground and background fill colors */
void box_demo(void)
{
   #define SETBACK 6
   int startx, starty, width, height, i, j, bcolor;
   char style[8] = { 0x0, 0x10, 0x38, 0x7C, 0xFE, 0x7C, 0x38, 0x10 };

   rectangle(0, 0, getmaxx(), getmaxy());
   width = getmaxx() / 48;
   height = getmaxy() / 48;
   starty = height;
   bcolor = 0;
   for (j=0; j<16; j++)
   {
      startx = width;
      for (i=0; i<16; i++)
      {
         setfillpattern(style, i);
         setwritemode(SETBACK+bcolor);
         bar3d(startx, starty, startx+(2*width), starty+(2*height), 0, 0);
         startx += (3*width);
      }
      starty += (3*height);
      bcolor++;
   }
   settextstyle(DEFAULT_FONT, VERT_DIR, 1);
   settextjustify(CENTER_TEXT, CENTER_TEXT);
   outtextxy(getmaxx()-8, getmaxy()/2, "Press a key:");
   wait();
   settextstyle(DEFAULT_FONT, HORIZ_DIR, 1);
}

/* demonstrate the support for transparent fills */
void cir_demo(void)
{
   #define NO_BACK_FILL 4
   #define BACK_FILL_BLACK 6

   int width, height, xradius, yradius, xasp, yasp, i;

   width = getmaxx() / 6;
   height = getmaxy() / 6;
   xradius = getmaxx() / 5;
   getaspectratio(&xasp, &yasp);
   yradius = (int)(((long)xradius * xasp) / yasp);
   for (i=0; i<2; i++)
   {
      rectangle(0, 0, getmaxx(), getmaxy());
      if (i==0)
         setwritemode(BACK_FILL_BLACK); /* fill pattern zeros in black */
      else
         setwritemode(NO_BACK_FILL);    /* don't fill pattern zeros */
      setcolor(RED);
      setfillstyle(LTSLASH_FILL, RED);
      fillellipse(3*width, 2*height, xradius, yradius);
      setcolor(YELLOW);
      setfillstyle(LTBKSLASH_FILL, YELLOW);
      fillellipse(2*width, 4*height, xradius, yradius);
      setcolor(LIGHTBLUE);
      setfillstyle(CLOSE_DOT_FILL, LIGHTBLUE);
      fillellipse(4*width, 4*height, xradius, yradius);
      setcolor(WHITE);
      settextjustify(LEFT_TEXT, TOP_TEXT);
      outtextxy(5, 10, "Press a key:");
      wait();
   }
}

/* demonstrate the support for multiple display pages */
void page_demo(void)
{
   int max_pages, midx, midy, page;
   char *page_names[8] = { "Page: 0", "Page: 1", "Page: 2", "Page: 3",
                           "Page: 4", "Page: 5", "Page: 6", "Page: 7" };

   switch(gmode)
   {
      case 0: max_pages = 8;  /* 320x200 */
              break;
      case 1: max_pages = 4;  /* 640x200 */
              break;
      case 2: max_pages = 2;  /* 640x350 */
              break;
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
      case 8: max_pages = 1;  /* 640x480 and 800x600 */
              break;
   }
   setcolor(WHITE);
   midx = getmaxx() / 2;
   midy = getmaxy() / 2;
   settextjustify(CENTER_TEXT, CENTER_TEXT);
   for (page=0; page<max_pages; page++)
   {
      setactivepage(page);
      setfillstyle(SOLID_FILL, page+1);
      bar3d(0, 0, getmaxx(), getmaxy(), 0, 0);
      outtextxy(midx, midy, page_names[page]);
      outtextxy(midx, midy+(2*textheight("M")), "Press a key:");
   }
   for (page=0; page<max_pages; page++)
   {
      setvisualpage(page);
      getch();
   }
   cleardevice();
}

/* demonstrate setting the foreground and background line colors */
void line_demo(void)
{
   #define LINE_BACK 22
   int x, maxx, maxy, width, fcolor, bcolor;

   maxx = getmaxx();
   maxy = getmaxy();
   width = maxx / 16;
   setlinestyle(CENTER_LINE, 0, 1);
   for (bcolor=0; bcolor<=15; bcolor++)
   {
      x = 0;
      setwritemode(LINE_BACK+bcolor);
      for (fcolor=0; fcolor<=15; fcolor++)
      {
         setcolor(fcolor);
         line(x, 0, x, maxy);
         x += width;
      }
      settextstyle(DEFAULT_FONT, VERT_DIR, 1);
      settextjustify(CENTER_TEXT, CENTER_TEXT);
      outtextxy(maxx-8, maxy/2, "Press a key:");
      wait();
   }
   settextstyle(DEFAULT_FONT, HORIZ_DIR, 1);
}

/* demonstrate the support for transparent lines */
void random_lines(void)
{
   #define NUM_LINES 100
   #define NO_LINE_BACK 5

   int x1, y1, x2, y2, i, maxx, maxy;

   maxx = getmaxx();
   maxy = getmaxy();
   setwritemode(NO_LINE_BACK); /* toggle off the plotting of the */
                               /* zeros in line patterns.        */
   setlinestyle(DASHED_LINE, 0, 1);
   for (i=0; i<NUM_LINES; i++)
   {
      x1 = random(maxx);
      x2 = random(maxx);
      y1 = random(maxy);
      y2 = random(maxy);
      setcolor(random(15)+1);
      line(x1, y1, x2, y2);
   }
   wait();
}
