ideal			; Set up in ideal mode
model	tiny		; This is done in tiny model

;******************* dispatch_savebitmap *********************************
;  Interfaces BGI driver code to the calling interface.  Save old DS and 
;     sets up a new one for the driver to use.  Restores the old DS and
;     does a far return on exit.  It passes and returns the parameters in
;     the conventional 'C' fashion.  This makes it much easier to write
;     the main driver in C and let the compiler optimize to its hearts 
;     content.
;
;		INPUT:	si	-- x1
;			di	-- y1.  (x1, y1) describe one corner of a 
;				     rectangle to save.
;			cx	-- x2
;			dx	-- y2.  (x2, y2) describe the other corner.
;			es	-- segment of data area to save to.
;			bx	-- offset of data area to save to.
;
;		OUTPUT:	none
;
;	V 1.00 12/07/89  Robert Adsett.
;	V 1.01 15/06/90  Robert Adsett.  Eliminate DOSSEG ordering.
;
;  (C) Robert Adsett 1989,1990
;*************************************************************************

codeseg			; Start of the code segment

;*************************************************************************
;	Declare publics and externals.
;*************************************************************************

extrn	_savebitmap	: near		;external function, does actual 
					;  work.
public	dispatch_savebitmap		;make this routine public so it
					;  can be hooked.


proc dispatch_savebitmap  near

	push	dx			;y2
	push	cx			;x2
	push	di			;y1
	push	si			;x1
	push	bx			;offset
	push	es			;segment
	call	_savebitmap		;call 'C' driver
	add	sp,12			;restore stack
	ret				;return to caller

endp

ends
end



