ideal			; Set up in ideal mode
model	tiny		; This is done in tiny model

;******************* dispatch_arc ****************************************
;  Interfaces BGI driver code to the calling interface.  Save old DS and 
;     sets up a new one for the driver to use.  Restores the old DS and
;     does a far return on exit.  It passes and returns the parameters in
;     the conventional 'C' fashion.  This makes it much easier to write
;     the main driver in C and let the compiler optimize to its hearts 
;     content.
;
;		INPUT:	ax	-- Start Angle.
;			bx	-- End angle.
;			cx	-- X radius.
;			dx	-- Y radius.
;
;		OUTPUT:	none
;
;	V 1.00 28/06/89  Robert Adsett.
;	V 1.01 15/06/90  Robert Adsett.  Eliminate DOSSEG ordering.
;
;  (C) Robert Adsett 1989, 1990
;*************************************************************************

codeseg			; Start of the code segment

;*************************************************************************
;	Declare publics and externals.
;*************************************************************************

extrn	_arc		: near		;external function, does actual 
					;  work.
public	dispatch_arc			;make this routine public so it
					;  can be hooked.


proc dispatch_arc  near

	push	dx			;Y radius
	push	cx			;X radius
	push	bx			;End angle
	push	ax			;Start angle
	call	_arc			;call 'C' driver
	add	sp,8			;restore stack
	ret				;return to caller

endp

ends
end

