#pragma inline

#include <stdio.h>
#include <dos.h>
#include <mem.h>

char *signature = "761295520";
char *extended_vga = "31";

#define EXTENDED_REG  0x1ce
#define DATA_I 	      0xbb

main()
{
char memsize, monitor;

if( !memicmp( signature, MK_FP( 0xc000, 0x31), 9) && 
    !memicmp( extended_vga, MK_FP( 0xc000, 0x40), 2))
    {
    printf( "Found an ATI VGA Wonder card.\n");
    }
else
    {
    printf( "Did not find an ATI VGA Wonder card.\n");
    return( 0);
    }
asm	cli
asm	mov	dx, EXTENDED_REG
asm	mov	al,DATA_I
asm	out	dx,al
asm	inc	dx
asm	in	al,dx
asm	sti
asm	and	al,0x20
asm	mov	memsize, al
if( memsize == 0x20)
    {
    printf( "Board has 512K installed.\n");
    }
else
    {
    printf( "Board has 256K installed.\n");
    }
asm	cli
asm	mov     dx,EXTENDED_REG
asm	mov     al,DATA_I
asm	out     dx,al
asm	inc     dx
asm	in      al,dx
asm	sti
asm	and     al,0fh
asm	mov	monitor, al
switch( monitor)
    {
    case 0:
         printf( "EGA monitor installed.\n");
	 break;

    case 1:
         printf( "PS/2 monochrome monitor installed.\n");
	 break;

    case 2:
         printf( "TTl monochrome monitor installed.\n");
	 break;

    case 3:
         printf( "PS/2 color monitor installed.\n");
	 break;

    case 4:
         printf( "RGB color monitor installed.\n");
	 break;

    case 5:
         printf( "Multisync monitor installed.\n");
	 break;

    case 7:
         printf( "PS/2 8514 monitor installed.\n");
	 break;

    case 9:
         printf( "Nec Multisync 2A monitor installed.\n");
	 break;

    case 0xb:
         printf( "Nec Multisync 3D monitor installed.\n");
	 break;

    case 0xd:
         printf( "Nec Multisync XL monitor installed.\n");
	 break;

    default:
         printf( "Unknown monitor installed.\n");
	 break;

    }
return( 0);
}
