; =======================================================================
; FILE: C0CBGI.ASM
;
; Based on Borlands original DEBVECT.ASM.
; Copyright (c) 1989,1990  R. Adsett 
;
; PURPOSE: Device Driver Overlay (DDO) for the COCBGI.OBJ driver startup.
;          This file defines the vector table at the beginning of the
;          driver.
;
; Current Date: 15/06/90
;
; Updates: 22/04/90 -- General release version.
;	   15/06/90 -- Change from ideal mode back to normal MASM syntax.
;			Avoid the use of the simplified model and segment
;			directives since the segment order has to be 
;			changed from the default DOSSEG ordering.  This
;			change is needed since DOSSEG segment ordering 
;			puts the uninitialized data segment last in the
;			resulting code (there is no stack segment).  This
;			segment is not actually included in the binary 
;			image built of the driver and so no space is
;			reserved for it.  By manually defining the 
;			segments it is possible to force the uninitialised
;			data segment to be placed ahead of the initialised
;			data segment.  This forces space be reserved for 
;			uninitialised data in the binary image of the 
;			driver.
;		       Also some cosmetic changes.	
;
; =======================================================================

.SEQ		;Place segments in object file in the order in which they
		;are encountered.

;       Segment and Group declarations

_TEXT   SEGMENT BYTE PUBLIC 'CODE'	;Code,
_TEXT   ENDS
_BSS    SEGMENT WORD PUBLIC 'BSS'	;followed by unitialised data,
_BSS    ENDS
_DATA   SEGMENT PARA PUBLIC 'DATA'	;followed finally by initialised
_DATA   ENDS				;data.

DGROUP  GROUP   _TEXT, _BSS, _DATA	;Tiny model.  All segments in the
					;same 64 K.

        ASSUME  CS:_TEXT, DS:DGROUP

include device.inc			; File defines vector table format

_TEXT   SEGMENT

;; The following table defines all of the available vectors as
;;   residing in the assembly shells in the library 'cbgi.lib'.

extrn	dispatch_install	: near,	dispatch_init		: near
extrn	dispatch_clear		: near,	dispatch_post		: near
extrn	dispatch_move		: near,	dispatch_draw		: near
extrn	dispatch_vect		: near
extrn	dispatch_patbar		: near
extrn	dispatch_palette	: near,	dispatch_allpalette	: near
extrn	dispatch_color		: near,	dispatch_fillstyle	: near
extrn	dispatch_linestyle	: near,	dispatch_textstyle	: near
extrn	dispatch_text		: near,	dispatch_textsiz	: near
extrn	dispatch_floodfill	: near,	dispatch_getpixel	: near
extrn	dispatch_putpixel	: near,	dispatch_bitmaputil	: near
extrn	dispatch_savebitmap	: near,	dispatch_restorebitmap	: near
extrn	dispatch_setclip	: near,	dispatch_color_query	: near


;;
;;  These are vectors that would normally be available, but are emulated
;;    for this driver.
;;

;extrn	dispatch_bar		: near
;extrn	dispatch_arc		: near
;extrn	dispatch_filled_ellipse	: near
;extrn	dispatch_pieslice	: near

        BGI     C0CBGI           ; Defining Standard Driver Startup

DDOVEC  DW      dispatch_install ; Driver initialization and installation
        DW      dispatch_init    ; Initialize device for output
        DW      dispatch_clear   ; Clear graphics device and ready it for new
                                 ; output.
        DW      dispatch_post    ; End Graphics Mode.
        DW      dispatch_move    ; Set Current Drawing Pointer to value.
        DW      dispatch_draw    ; Draw a line from the Current Pointer to
                                 ; the given coordinate.
        DW      dispatch_vect    ; Draw a line between the given coordinate
                                 ; pairs.
        DW      EMULATE          ; Emulated polygon
        DW      EMULATE		 ; Draw a filled rectangle with the CP as the
                                 ; Lower Left corner, and the given coordinate
                                 ; as the upper right.
        DW      dispatch_patbar  ; Draw a patterned rectangle with the given
                                 ; coorinate pair. The pattern is provided by
                                 ; the set fill pattern entry.
        DW      EMULATE		 ; Draw an elliptical arc from the given start
                                 ; angle to the given end angle, using the CP
                                 ; as the Center Point, and the given X and Y
                                 ; Radii. Angles are 0-360 degrees.
        DW      EMULATE		 ; Draw an elliptical sector from the given start
                                 ; angle to the given end angle, using the CP
                                 ; as the Center Point, and the given X and Y
                                 ; Radii. Angles are 0-360 degrees.
        DW      EMULATE 	 ; Draw an ellipse using the CP as the Center
                                 ; Point, and the given X and Y radii.
        DW      dispatch_palette ; Set a palette entry to a given color.
        DW      dispatch_allpalette ; Load the palette with a table of colors.
        DW      dispatch_color   ; Set the palette indexs for the current
                                 ; drawing color and the current fill color.
        DW      dispatch_fillstyle  ; Set current fill pattern. The fill pattern is
                                 ; set to the pattern specified. If the pattern
                                 ; number is -1 then the pattern is define in
                                 ; a user supplied array.
        DW      dispatch_linestyle  ; Set current line style. The line style is
                                 ; set to the style specified. If the style
                                 ; number is -1 then the style is define in
                                 ; a user supplied pattern.
        DW      dispatch_textstyle  ; Set the text attributes for font rendering
        DW      dispatch_text    ; Draw a string in the current font with the
                                 ; justification point at the CP.
        DW      dispatch_textsiz ; Calculate the dimensions (in pixels) of an
                                 ; input text string.
        DW      RESERVED         ; RESERVED

        DW      dispatch_floodfill  ; Do a floodfill in the current color using
                                 ; the given (X,Y) address as the seed.
        DW      dispatch_getpixel   ; Read a pixel from the given coord.
        DW      dispatch_putpixel   ; Write a pixel to the given coord.
        DW      dispatch_bitmaputil ; Return a pointer to a table of misc driver
                                 ; utilities. The following describes the table.
        DW      dispatch_savebitmap ; Save a portion of the screen to CPU memory.
        DW      dispatch_restorebitmap ; Restore a portion of the screen from CPU memory.
        DW      dispatch_setclip ; Set the clipping window to the rectangle
                                 ; defined by the two (X,Y) pairs
        DW      dispatch_color_query ; Return the parameters of the device color
                                 ; table (Size, Default Palette, etc)
        DW     35 DUP (NONE)     ; Reserved Entry Points

_TEXT   ENDS

end

