/**************************** ATI.H *************************************/
/*	ATI Wonder driver header file.  Contains driver specific macros	*/
/*  and structures.							*/
/************************************************************************/

#include <dos.h>		/* Outport etc.				*/

typedef unsigned char far * SCREEN_PTR;

typedef struct {
  unsigned char length;			/* # of color entries in palette*/
  unsigned char colora[256*3];		/* Up to 16 color entries	*/
  } ATIPALETTE;

#define MAX_MODES 	3		/* The maximum number of modes.	*/
#define ATI256LO	0
#define ATI256MED	1
#define ATI256HI	2

#define PLANE_SELECT	0xb2
#define PLANE_MASK	0xe1
#define EXTENDED_REG	0x1ce

#define ATI_SEGMENT	0xa000

#define BANK_SELECT()	{\
			int BANK_SELECT_temp;\
			disable();\
			outportb( EXTENDED_REG, PLANE_SELECT);\
			BANK_SELECT_temp = inportb( EXTENDED_REG+1) & \
			                   PLANE_MASK;\
			BANK_SELECT_temp |= current_bank << 1;\
			outport( EXTENDED_REG, (BANK_SELECT_temp << 8) |\
			         PLANE_SELECT);\
			enable();\
			}

				/* A macro to calculate the current	*/
				/*  address from (x,y) position info.	*/
#define CALC_ADDR( x, y)   { int CALC_ADDR_temp_i; \
			     for( CALC_ADDR_temp_i = 0; CALC_ADDR_temp_i \
			              < maximum_bank; CALC_ADDR_temp_i++)\
			       { \
			       if( y < bank[CALC_ADDR_temp_i].rowmax)\
				   { \
				   current_bank = CALC_ADDR_temp_i; \
				   BANK_SELECT();\
				   current_address = screen_buffer + \
				       (y - bank[CALC_ADDR_temp_i].rowmin)*rowsize + \
				       x - bank[CALC_ADDR_temp_i].colmin;\
				   break;\
				   }\
			       else if( y == bank[CALC_ADDR_temp_i].rowmax && \
			                x <= bank[CALC_ADDR_temp_i].colmax)\
				   { \
				   current_bank = CALC_ADDR_temp_i; \
				   BANK_SELECT();\
				   current_address = screen_buffer + \
				       (y - bank[CALC_ADDR_temp_i].rowmin)*rowsize + \
				       x - bank[CALC_ADDR_temp_i].colmin;\
				   break;\
				   }\
			       }\
			   }


		    		/* A macro to change the current address*/
				/*  by 1 in the x direction.		*/
#define X_INCREMENT_CALC() { current_address++;\
			     if( FP_OFF( current_address) == 0){\
			        current_bank++;\
			        BANK_SELECT();}\
			    }

		    		/* A macro to change the current address*/
				/*  by 1 in the y direction.		*/
#define Y_INCREMENT_CALC() { old_address = current_address;\
			     current_address += rowsize;\
			     if( FP_OFF( current_address) < \
			         FP_OFF( old_address))\
				{\
				current_bank++;\
				BANK_SELECT();\
				}\
			   }

		    		/* A macro to change the current address*/
				/*  by -1 in the y direction.		*/
#define Y_DECREMENT_CALC() { old_address = current_address;\
			     current_address -= rowsize;\
			     if( FP_OFF( current_address) > \
			         FP_OFF( old_address))\
				{\
				current_bank--;\
				BANK_SELECT();\
				}\
			   }

		      		/* A macro to put a pixel of colour 	*/
				/*  colour on the screen at the current	*/
				/*  address.				*/
#define POINT( colour)	{ *current_address = colour;}

		      		/* A macro to xor a pixel of colour 	*/
				/*  colour on the screen at the current	*/
				/*  address.				*/
#define XOR_POINT( colour) { *current_address = (*current_address) ^\
		      			 colour; }

		      		/* A macro to read a pixel from the    	*/
				/*  screen at the current address.	*/
#define RD_POINT()	( (unsigned char)*current_address)

/* Combinations of the address calculation macros with the draw pixel	*/
/*  macro using the current colour.					*/

#define DRAW_POINT( x, y)   { CALC_ADDR( (x), (y));\
			      POINT( current_colour);\
		            }

#define X_INCREMENT_POINT() { X_INCREMENT_CALC();\
			      POINT( current_colour);\
		            }

#define Y_INCREMENT_POINT() { Y_INCREMENT_CALC();\
			      POINT( current_colour);\
		            }

#define Y_DECREMENT_POINT() { Y_DECREMENT_CALC();\
			      POINT( current_colour);\
		            }


struct BANK {			/* Bank description.			*/
	unsigned int rowmin;
	unsigned int rowmax;
	unsigned int colmin;
	unsigned int colmax;
	};

extern struct BANK bank[8];		/* An array of 8 of them, 	*/
					/* describes all bank.		*/

extern SCREEN_PTR const screen_buffer;	/* Point to base of video 	*/
					/*  memory.			*/
extern SCREEN_PTR current_address,	/* Current offset into video.	*/
		  old_address;		/* For Incrementing calc's.	*/
extern unsigned char current_bank; 		/* Current bank.		*/
extern unsigned char maximum_bank; 		/* Maximum bank available.	*/
extern int rowsize;


