/*_______________________________________________________________

TC-08.C

Purpose:  Demonstrates surface mapping of a 3D solid cylinder.
A two-color design is mapped onto a can.

Compatibility:  Supports all VGA, EGA, CGA, and MCGA
graphics adapters and monitors.  Uses the 640x480 16-color
mode if a VGA is present, the 640x350 16-color mode if an EGA
and enhanced monitor are present, the 640x200 16-color mode
if an EGA and standard monitor are present, the 320x200
4-color mode if a CGA or MCGA is present.

Remarks:  Requires Borland Turbo C 1.5 or newer.

Copyright 1989 Lee Adams and TAB BOOKS Inc.

_________________________________________________________________


I N C L U D E    F I L E S                                       */

#include <process.h>               /* supports the exit function */
#include <bios.h>                 /* supports keyboard functions */
#include <stdio.h>               /* supports the printf function */
#include <graphics.h>         /* supports the graphics functions */
#include <math.h>          /* supports sine and cosine functions */

/*_______________________________________________________________


D E C L A R A T I O N S                                          */

float x=0.0,y=0.0,z=0.0;                    /* world coordinates */
float x1=0.0,x2=0.0,x3=0.0;                  /* polygon vertices */
float y01=0.0,y2=0.0,y3=0.0;                 /* polygon vertices */
float z1=0.0,z2=0.0,z3=0.0;                  /* polygon vertices */
float sx1=0.0,sx2=0.0,sx3=0.0,sx4=0.0,sx5=0.0; /* display coords */
float sy1=0.0,sy2=0.0,sy3=0.0,sy4=0.0,sy5=0.0; /* display coords */
float sx=0.0,sy=0.0;        /* output of 3D perspective formulas */
float xa=0.0,ya=0.0,za=0.0;   /* temporary values in 3D formulas */
float d=1200.0;                    /* angular perspective factor */
double r1=5.89778;                       /* yaw angle in radians */
double r2=6.28319;                      /* roll angle in radians */
double r3=.58539;                      /* pitch angle in radians */
double sr1=0.0,sr2=0.0,sr3=0.0;         /* sine rotation factors */
double cr1=0.0,cr2=0.0,cr3=0.0;       /* cosine rotation factors */
float mx=0.0,my=0.0,mz=-350.0;             /* viewpoint position */
int maxx=639,minx=0,maxy=199,miny=0;         /* scaling viewport */
float screen_x=639,screen_y=199;    /* dimensions of screen mode */
float rx=0.0,ry=0.0;   /* scaling values used in mapping routine */
int t=0,t1=0,t2=0;                              /* loop counters */
int p1=0;                                       /* array indexer */
int C0=0,C1=1,C2=2,C3=3,C4=4,C5=5,C6=6,C7=7,C8=8,C9=9,C10=10,
				C11=11,C12=12,C13=13,C14=14,C15=15,mode_flag=0;
int key_matte_clr=6;                /* exclusive key matte color */
int edge_clr=7;                  /* used to draw edges of models */
int solid_clr=0;        /* used to fill surfaces of solid models */
int design_clr=1;        /* used to draw the design on the model */
float x_res,y_res;  /* used for 2D mapping from 640x480 template */
float sp=0.0;     /* visibility factor in hidden surface routine */
float sp1=0.0,sp2=0.0,sp3=0.0;         /* temporary values of sp */

int q=0,q1=0,q2=0;         /* cylinder surface & vertex counters */
double r4=6.28319,r5=6.28319;     /* spherical coordinate angles */
float B11[36][3];        /* 36 sets of xyz view coords, near end */
float B12[36][3];         /* 36 sets of xyz view coords, far end */
float B21[36][2];      /* 36 sets sx,sy display coords, near end */
float B22[36][2];       /* 36 sets sx,sy display coords, far end */
double sr4=0.0,cr4=0.0,sr5=0.0,cr5=0.0;      /* rotation factors */

																	/* declare global subroutines */
void keyboard(void);void quit_pgm(void);void calc_3d(void);
void rotation(void);void window(void);void graphics_setup(void);
void coords(void);void draw_poly(void);void notice(int x,int y);
void visibility_test(void);

void cyl_coords(void);void draw_surface(void);

/*_______________________________________________________________


M A I N    R O U T I N E                                         */

main(){
graphics_setup();                     /* establish graphics mode */
setviewport(0,0,maxx,maxy,1);      /* define clipping boundaries */
key_matte_clr=C6;                      /* define key matte color */
edge_clr=C7;solid_clr=C0;              /* define modeling colors */
rotation();            /* calculate the yaw, roll, pitch factors */

/*         calculate coordinates for near end of cylinder        */
r4=0;r5=0;
for (t=0;t<=35;t++){
		x=30;cyl_coords();z=z+60;calc_3d();window();
		B11[t][0]=x;B11[t][1]=y;B11[t][2]=z;    /* store view coords */
		B21[t][0]=sx;B21[t][1]=sy;           /* store display coords */
		keyboard();
		r5=r5+.17453;}                 /* increment r5 by 10 degrees */

/*         calculate coordinates for far end of cylinder         */
r4=0;r5=0;
for (t=0;t<=35;t++){
		x=30;cyl_coords();z=z-60;calc_3d();window();
		B12[t][0]=x;B12[t][1]=y;B12[t][2]=z;    /* store view coords */
		B22[t][0]=sx;B22[t][1]=sy;           /* store display coords */
		keyboard();
		r5=r5+.17453;}                 /* increment r5 by 10 degrees */

/*                draw surfaces of 3D cylinder                   */
for (q1=0;q1<=35;q1++){                /* 36 four-sided polygons */
		q2=q1+1;if (q2>35) q2=0;
		draw_surface();keyboard();}

/*                draw near end of 3D cylinder                   */
x1=B11[0][0];y01=B11[0][1];z1=B11[0][2];
x2=B11[25][0];y2=B11[25][1];z2=B11[25][2];
x3=B11[11][0];y3=B11[11][1];z3=B11[11][2];
visibility_test();if (sp>0) goto draw_the_design;
setcolor(key_matte_clr);setfillstyle(SOLID_FILL,key_matte_clr);
setlinestyle(USERBIT_LINE,0xffff,NORM_WIDTH);
for (q1=0;q1<=35;q1++){                             /* key matte */
		q2=q1+1;if (q2>35) q2=0;
		sx1=B21[q1][0];sy1=B21[q1][1];
		sx2=B21[q2][0];sy2=B21[q2][1];
		moveto(sx1,sy1);lineto(sx2,sy2);}
x=0.0;y=0.0;z=60.0;calc_3d();window();floodfill(sx,sy,key_matte_clr);
keyboard();
setcolor(edge_clr);
for (q1=0;q1<=35;q1++){          /* draw 36 vertices of polyline */
		q2=q1+1;if (q2>35) q2=0;
		sx1=B21[q1][0];sy1=B21[q1][1];
		sx2=B21[q2][0];sy2=B21[q2][1];
		moveto(sx1,sy1);lineto(sx2,sy2);}
x=0.0;y=0.0;z=60.0;calc_3d();window();
setfillstyle(SOLID_FILL,solid_clr);floodfill(sx,sy,edge_clr);

/*                   draw design on cylinder                    */
draw_the_design:
r4=0;r5=1.5;
design_clr=C1;                 /* prepare to draw lower graphic */
setcolor(design_clr);
x=30;cyl_coords();z=z+20;calc_3d();window();moveto(sx,sy);
r5=r5+.08727;
for (t=0;t<=21;t++){
		x=30;cyl_coords();z=z+20;calc_3d();window();
		lineto(sx,sy);
		keyboard();
		r5=r5+.08727;}                 /* increment r5 by 5 degrees */
r5=r5-.08727;                /* negate the final loop increment */
x=30;cyl_coords();z=z-40;calc_3d();window();lineto(sx,sy);
r5=r5-.08727;
for (t=0;t<=21;t++){
		x=30;cyl_coords();z=z-40;calc_3d();window();
		lineto(sx,sy);
		keyboard();
		r5=r5-.08727;}                 /* decrement r5 by 5 degrees */
r5=r5+.08727;                /* negate the final loop decrement */
x=30;cyl_coords();z=z+20;calc_3d();window();lineto(sx,sy);
r5=r5+(10*.08727);
x=30;cyl_coords();z=z-10;calc_3d();window();
setfillstyle(SOLID_FILL,design_clr);
floodfill(sx,sy,design_clr);

r4=0;r5=1.5;
design_clr=C4;                 /* prepare to draw upper graphic */
setcolor(design_clr);
x=30;cyl_coords();z=z+30;calc_3d();window();moveto(sx,sy);
r5=r5+.08727;
for (t=0;t<=21;t++){
		x=30;cyl_coords();z=z+30;calc_3d();window();
		lineto(sx,sy);
		keyboard();
		r5=r5+.08727;}                 /* increment r5 by 5 degrees */
r5=r5-.08727;
x=30;cyl_coords();z=z+50;calc_3d();window();lineto(sx,sy);
r5=r5-.08727;
for (t=0;t<=21;t++){
		x=30;cyl_coords();z=z+50;calc_3d();window();
		lineto(sx,sy);
		keyboard();
		r5=r5-.08727;}                 /* decrement r5 by 5 degrees */
r5=r5+.08727;
x=30;cyl_coords();z=z+30;calc_3d();window();lineto(sx,sy);
r5=r5+(10*.08727);
x=30;cyl_coords();z=z+40;calc_3d();window();
setfillstyle(SOLID_FILL,design_clr);
floodfill(sx,sy,design_clr);

setcolor(C7);notice(0,0);
for (t1=1;t1!=2; ) keyboard();          /* press any key to stop */
quit_pgm();}                       /* end the program gracefully */

/*_______________________________________________________________


SUBROUTINE: CALCULATE WORLD COORDS FOR CYLINDER

This subroutine uses sine and cosine to calculate the x,y,z
coordinates of various vertices at each end of the 3D cylinder.
The variables r4 and r5 refer to yaw and roll in the 3D
spherical coordinate system, respectively.                       */

void cyl_coords(void){sr4=sin(r4);cr4=cos(r4);sr5=sin(r5);
cr5=cos(r5);x1=sr5*x;y=cr5*x;x=cr4*x1;z=sr4*x1;return;}

/*_______________________________________________________________


SUBROUTINE: DRAW POLYGONAL SURFACE ON CYLINDER

This subroutine retrieves the pre-calculated view coordinates
from the appropriate arrays, tests for hidden surfaces, retreives
the appropriate pre-calculated display coordinates, and then
calls upon the modeling and rendering routines.                  */

void draw_surface(void){
x1=B11[q1][0];y01=B11[q1][1];z1=B11[q1][2];   /* get view coords */
x2=B11[q2][0];y2=B11[q2][1];z2=B11[q2][2];    /* get view coords */
x3=B12[q2][0];y3=B12[q2][1];z3=B12[q2][2];    /* get view coords */
visibility_test();if (sp>0) return;   /* test if surface visible */
sx1=B21[q1][0];sy1=B21[q1][1];        /* retrieve display coords */
sx2=B21[q2][0];sy2=B21[q2][1];        /* retrieve display coords */
sx3=B22[q2][0];sy3=B22[q2][1];        /* retrieve display coords */
sx4=B22[q1][0];sy4=B22[q1][1];        /* retrieve display coords */
x=x1+.5*(x3-x1);y=y01+.5*(y3-y01);z=z1+.5*(z3-z1);   /* midpoint */
sx=d*x/z;sy=d*y/z;window();sx5=sx;sy5=sy;    /* area fill coords */
draw_poly();                               /* draw solid polygon */
return;}

/*_______________________________________________________________


SUBROUTINE: CALCULATE SIN, COS FACTORS                           */

void rotation(void){
sr1=sin(r1);sr2=sin(r2);sr3=sin(r3);cr1=cos(r1);cr2=cos(r2);
cr3=cos(r3);return;}

/*_______________________________________________________________


SUBROUTINE: STANDARD 3D FORMULAS                                 */

void calc_3d(void){
x=(-1)*x;xa=cr1*x-sr1*z;za=sr1*x+cr1*z;x=cr2*xa+sr2*y;
ya=cr2*y-sr2*xa;z=cr3*za-sr3*ya;y=sr3*za+cr3*ya;x=x+mx;y=y+my;
z=z+mz;sx=d*x/z;sy=d*y/z;return;}

/*_______________________________________________________________


SUBROUTINE: HIDDEN SURFACE VISIBILITY TEST                       */

void visibility_test(void){
sp1=x1*(y2*z3-y3*z2);sp1=(-1)*sp1;sp2=x2*(y3*z1-y01*z3);
sp3=x3*(y01*z2-y2*z1);sp=sp1-sp2-sp3;return;}

/*_______________________________________________________________


SUBROUTINE: DRAW 4-SIDED SOLID POLYGON IN 3D SPACE               */

void draw_poly(void){
setlinestyle(USERBIT_LINE,0xffff,NORM_WIDTH);
setcolor(key_matte_clr);moveto(sx1,sy1);
lineto(sx2,sy2);lineto(sx3,sy3);lineto(sx4,sy4);lineto(sx1,sy1);
setfillstyle(SOLID_FILL,key_matte_clr);floodfill(sx5,sy5,key_matte_clr);
setcolor(edge_clr);moveto(sx1,sy1);
lineto(sx2,sy2);lineto(sx3,sy3);lineto(sx4,sy4);lineto(sx1,sy1);
setfillstyle(SOLID_FILL,solid_clr);floodfill(sx5,sy5,edge_clr);return;}

/*_______________________________________________________________


SUBROUTINE: MAP CARTESIAN COORDS TO PHYSICAL SCREEN COORDS       */

void window(void){
sx=sx+399;sy=sy+299;rx=screen_x/799;ry=screen_y/599;sx=sx*rx;
sy=sy*ry;return;}

/*_______________________________________________________________


SUBROUTINE: CHECK THE KEYBOARD BUFFER                            */

void keyboard(void){
if (bioskey(1)==0) return; else quit_pgm();}

/*_______________________________________________________________


SUBROUTINE: GRACEFUL EXIT FROM THE PROGRAM                       */

void quit_pgm(void){
cleardevice();restorecrtmode();exit(0);}

/*_______________________________________________________________


SUBROUTINE: VGA/EGA/CGA/MCGA compatibility module                */

void graphics_setup(void){
int graphics_adapter,graphics_mode;
detectgraph(&graphics_adapter,&graphics_mode);
if (graphics_adapter==VGA) goto VGA_mode;              /* if VGA */
if (graphics_mode==EGAHI) goto EGA_ECD_mode;   /* if EGA and ECD */
if (graphics_mode==EGALO) goto EGA_SCD_mode;   /* if EGA and SCD */
if (graphics_adapter==CGA) goto CGA_mode;              /* if CGA */
if (graphics_adapter==MCGA) goto CGA_mode;            /* if MCGA */
goto abort_message;              /* if no VGA, EGA, CGA, or MCGA */

VGA_mode:
graphics_adapter=VGA;graphics_mode=VGAHI;
initgraph(&graphics_adapter,&graphics_mode,"");
x_res=640;y_res=480;mode_flag=1;
			maxx=639;minx=0;maxy=479;miny=0;screen_x=639;screen_y=479;
			setcolor(7);moveto(0,472);
			outtext("640x480 16-color VGA mode");
			moveto(472,472);
			outtext("Press any key to quit");
			moveto(160,0);
			outtext("USING C TO MAP DESIGNS ONTO A 3D CYLINDER");
			return;

EGA_ECD_mode:
graphics_adapter=EGA;graphics_mode=EGAHI;
initgraph(&graphics_adapter,&graphics_mode,"");
x_res=640;y_res=350;mode_flag=2;
			maxx=639;minx=0;maxy=349;miny=0;screen_x=639;screen_y=349;
			setcolor(7);moveto(0,342);
			outtext("640x350 16-color EGA mode");
			moveto(472,342);
			outtext("Press any key to quit");
			moveto(160,0);
			outtext("USING C TO MAP DESIGNS ONTO A 3D CYLINDER");
			return;

EGA_SCD_mode:
graphics_adapter=EGA;graphics_mode=EGALO;
initgraph(&graphics_adapter,&graphics_mode,"");
x_res=640;y_res=200;mode_flag=3;
			maxx=639;minx=0;maxy=199;miny=0;screen_x=639;screen_y=199;
			setcolor(7);moveto(0,192);
			outtext("640x200 16-color EGA mode");
			moveto(472,192);
			outtext("Press any key to quit");
			moveto(160,0);
			outtext("USING C TO MAP DESIGNS ONTO A 3D CYLINDER");
			return;

CGA_mode:
graphics_adapter=CGA;graphics_mode=CGAC3;
initgraph(&graphics_adapter,&graphics_mode,"");
x_res=320;y_res=200;
			mode_flag=4;
			maxx=319;minx=0;maxy=199;miny=0;screen_x=319;screen_y=199;
      C0=0;C1=1;C2=1;C3=1;C4=2;C5=1;C6=2;C7=3;C8=1;C9=3;C10=3;
			C11=3;C12=3;C13=3;C14=3;C15=3;
      setcolor(3);moveto(48,192);
			outtext("320x200 4-color CGA & MCGA mode");
			moveto(80,0);
			outtext("DESIGN ON 3D CYLINDER");
			return;

abort_message:
printf("\n\nUnable to proceed.\n");
printf("Requires VGA, EGA, CGA, or MCGA adapter\n");
printf("   with appropriate monitor.\n");
printf("Please refer to the book.\n\n");
exit(0);
}

/*_______________________________________________________________


SUBROUTINE: MAP 640x480 TEMPLATE TO 2D SCREEN                    */

void coords(void){sx=sx*(x_res/640);sy=sy*(y_res/480);return;}

/*_______________________________________________________________


SUBROUTINE: Copyright Notice                                     */

int copyright[][3]={0x7c00,0x0000,0x0000,0x8231,
0x819c,0x645e,0xba4a,0x4252,0x96d0,0xa231,0x8252,0x955e,0xba4a,
0x43d2,0xf442,0x8231,0x825c,0x945e,0x7c00,0x0000,0x0000};

void notice(int x, int y){
int a,b,c; int t1=0;
for (t1=0;t1<=6;t1++){a=copyright[t1][0];b=copyright[t1][1];
c=copyright[t1][2];
setlinestyle(USERBIT_LINE,a,NORM_WIDTH);
moveto(x,y);lineto(x+15,y);
setlinestyle(USERBIT_LINE,b,NORM_WIDTH);
moveto(x+16,y);lineto(x+31,y);
setlinestyle(USERBIT_LINE,c,NORM_WIDTH);
moveto(x+32,y);lineto(x+47,y);y=y+1;};
setlinestyle(USERBIT_LINE,0xFFFF,NORM_WIDTH);
return;}

/*_______________________________________________________________


End of source code                                               */


