/*_______________________________________________________________

TC-03.C

Purpose:  Draws a 3D solid cube using the plane equation
method of hidden surface removal.

Compatibility:  Supports all VGA, EGA, CGA, and MCGA
graphics adapters and monitors.  Uses the 640x480 16-color
mode if a VGA is present, the 640x350 16-color mode if an EGA
and enhanced monitor are present, the 640x200 16-color mode
if an EGA and standard monitor are present, the 320x200
4-color mode if a CGA or MCGA is present.

Remarks:  Requires Borland Turbo C 1.5 or newer.

Copyright 1989 Lee Adams and TAB BOOKS Inc.

_________________________________________________________________


I N C L U D E    F I L E S                                       */

#include <process.h>               /* supports the exit function */
#include <bios.h>                 /* supports keyboard functions */
#include <stdio.h>               /* supports the printf function */
#include <graphics.h>         /* supports the graphics functions */
#include <math.h>          /* supports sine and cosine functions */

/*_______________________________________________________________


D E C L A R A T I O N S                                          */

float x=0.0,y=0.0,z=0.0;                    /* world coordinates */
float x1=0.0,x2=0.0,x3=0.0;                  /* polygon vertices */
float y01=0.0,y2=0.0,y3=0.0;                 /* polygon vertices */
float z1=0.0,z2=0.0,z3=0.0;                  /* polygon vertices */
float sx1=0.0,sx2=0.0,sx3=0.0,sx4=0.0,sx5=0.0; /* display coords */
float sy1=0.0,sy2=0.0,sy3=0.0,sy4=0.0,sy5=0.0; /* display coords */
float sx=0.0,sy=0.0;        /* output of 3D perspective formulas */
float xa=0.0,ya=0.0,za=0.0;   /* temporary values in 3D formulas */
float d=1200.0;                    /* angular perspective factor */
double r1=5.68319;                       /* yaw angle in radians */
double r2=6.28319;                      /* roll angle in radians */
double r3=5.79778;                     /* pitch angle in radians */
double sr1=0.0,sr2=0.0,sr3=0.0;         /* sine rotation factors */
double cr1=0.0,cr2=0.0,cr3=0.0;       /* cosine rotation factors */
float mx=0.0,my=0.0,mz=-350.0;             /* viewpoint position */
int maxx=639,minx=0,maxy=199,miny=0;         /* scaling viewport */
float screen_x=639,screen_y=199;    /* dimensions of screen mode */
float rx=0.0,ry=0.0;   /* scaling values used in mapping routine */
int t=0,t1=0,t2=0;                              /* loop counters */
int p1=0;                                       /* array indexer */
int C0=0,C1=1,C2=2,C3=3,C4=4,C5=5,C6=6,C7=7,C8=8,C9=9,C10=10,
				C11=11,C12=12,C13=13,C14=14,C15=15,mode_flag=0;
int key_matte_clr=6;                /* exclusive key matte color */
int edge_clr=7;                  /* used to draw edges of models */
int solid_clr=0;        /* used to fill surfaces of solid models */
float x_res,y_res;  /* used for 2D mapping from 640x480 template */
float sp=0.0;     /* visibility factor in hidden surface routine */
float sp1=0.0,sp2=0.0,sp3=0.0;         /* temporary values of sp */

																				/* declare database arrays */
int array1[][3]={           /* database of vertices for 3D model */
30,-30,30,   30,30,30,   -30,30,30,   -30,-30,30,   30,30,-30,
-30,30,-30,   -30,-30,-30,   30,-30,-30};
int array2[][3]={       /* database of fill origins for 3D model */
0,-30,0,   0,0,-30,   -30,0,0,   0,0,30,   30,0,0,   0,30,0};
float B1[8][3];       /* array of 8 sets of xyz view coordinates */
float B2[8][2];  /* array of 8 sets of sx,sy display coordinates */
float B3[6][2];     /* array of 6 sets of sx,sy fill coordinates */

                                   /* declare global subroutines */
void keyboard(void);void quit_pgm(void);void calc_3d(void);
void rotation(void);void window(void);void graphics_setup(void);
void coords(void);void draw_poly(void);void notice(int x,int y);
void visibility_test(void);void store_coords(void);

/*_______________________________________________________________


M A I N    R O U T I N E                                         */

main(){
graphics_setup();                     /* establish graphics mode */
setviewport(0,0,maxx,maxy,1);      /* define clipping boundaries */
key_matte_clr=C6;                      /* define key matte color */
edge_clr=C7;solid_clr=C0;              /* define modeling colors */

store_coords();       /* calculate and store 3D coords in arrays */

surface0:
x1=B1[7][0];y01=B1[7][1];z1=B1[7][2];x2=B1[0][0];y2=B1[0][1];
z2=B1[0][2];x3=B1[3][0];y3=B1[3][1];z3=B1[3][2];visibility_test();
if (sp>0) goto surface1;
sx1=B2[7][0];sy1=B2[7][1];sx2=B2[0][0];sy2=B2[0][1];sx3=B2[3][0];
sy3=B2[3][1];sx4=B2[6][0];sy4=B2[6][1];sx5=B3[0][0];sy5=B3[0][1];
draw_poly();

surface1:
x1=B1[6][0];y01=B1[6][1];z1=B1[6][2];x2=B1[5][0];y2=B1[5][1];
z2=B1[5][2];x3=B1[4][0];y3=B1[4][1];z3=B1[4][2];visibility_test();
if (sp>0) goto surface2;
sx1=B2[6][0];sy1=B2[6][1];sx2=B2[5][0];sy2=B2[5][1];sx3=B2[4][0];
sy3=B2[4][1];sx4=B2[7][0];sy4=B2[7][1];sx5=B3[1][0];sy5=B3[1][1];
draw_poly();

surface2:
x1=B1[3][0];y01=B1[3][1];z1=B1[3][2];x2=B1[2][0];y2=B1[2][1];
z2=B1[2][2];x3=B1[5][0];y3=B1[5][1];z3=B1[5][2];visibility_test();
if (sp>0) goto surface3;
sx1=B2[3][0];sy1=B2[3][1];sx2=B2[2][0];sy2=B2[2][1];sx3=B2[5][0];
sy3=B2[5][1];sx4=B2[6][0];sy4=B2[6][1];sx5=B3[2][0];sy5=B3[2][1];
draw_poly();

surface3:
x1=B1[0][0];y01=B1[0][1];z1=B1[0][2];x2=B1[1][0];y2=B1[1][1];
z2=B1[1][2];x3=B1[2][0];y3=B1[2][1];z3=B1[2][2];visibility_test();
if (sp>0) goto surface4;
sx1=B2[0][0];sy1=B2[0][1];sx2=B2[1][0];sy2=B2[1][1];sx3=B2[2][0];
sy3=B2[2][1];sx4=B2[3][0];sy4=B2[3][1];sx5=B3[3][0];sy5=B3[3][1];
draw_poly();

surface4:
x1=B1[7][0];y01=B1[7][1];z1=B1[7][2];x2=B1[4][0];y2=B1[4][1];
z2=B1[4][2];x3=B1[1][0];y3=B1[1][1];z3=B1[1][2];visibility_test();
if (sp>0) goto surface5;
sx1=B2[7][0];sy1=B2[7][1];sx2=B2[4][0];sy2=B2[4][1];sx3=B2[1][0];
sy3=B2[1][1];sx4=B2[0][0];sy4=B2[0][1];sx5=B3[4][0];sy5=B3[4][1];
draw_poly();

surface5:
x1=B1[1][0];y01=B1[1][1];z1=B1[1][2];x2=B1[4][0];y2=B1[4][1];
z2=B1[4][2];x3=B1[5][0];y3=B1[5][1];z3=B1[5][2];visibility_test();
if (sp>0) goto surfaces_done;
sx1=B2[1][0];sy1=B2[1][1];sx2=B2[4][0];sy2=B2[4][1];sx3=B2[5][0];
sy3=B2[5][1];sx4=B2[2][0];sy4=B2[2][1];sx5=B3[5][0];sy5=B3[5][1];
draw_poly();

surfaces_done:setcolor(C7);notice(0,0);
for (t1=1;t1!=2; ) keyboard();          /* press any key to stop */
quit_pgm();}                       /* end the program gracefully */

/*_______________________________________________________________


SUBROUTINE: CALCULATE SIN, COS FACTORS                           */

void rotation(void){
sr1=sin(r1);sr2=sin(r2);sr3=sin(r3);cr1=cos(r1);cr2=cos(r2);
cr3=cos(r3);return;}

/*_______________________________________________________________


SUBROUTINE: STANDARD 3D FORMULAS                                 */

void calc_3d(void){
x=(-1)*x;xa=cr1*x-sr1*z;za=sr1*x+cr1*z;x=cr2*xa+sr2*y;
ya=cr2*y-sr2*xa;z=cr3*za-sr3*ya;y=sr3*za+cr3*ya;x=x+mx;y=y+my;
z=z+mz;sx=d*x/z;sy=d*y/z;return;}

/*_______________________________________________________________


SUBROUTINE: CALCULATE & STORE VIEW COORDS & DISPLAY COORDS       */

void store_coords(void){
rotation();       /* calculate yaw, roll, pitch rotation factors */
for (t=0;t<=7;t++){
			x=array1[t][0];y=array1[t][1];z=array1[t][2];
			calc_3d();window();
			B1[t][0]=x;B1[t][1]=y;B1[t][2]=z;     /* store view coords */
			B2[t][0]=sx;B2[t][1]=sy;           /* store display coords */
			};
for (t=0;t<=5;t++){
			x=array2[t][0];y=array2[t][1];z=array2[t][2];
			calc_3d();window();
			B3[t][0]=sx;B3[t][1]=sy;      /* store fill display coords */
			};
return;}

/*_______________________________________________________________


SUBROUTINE: HIDDEN SURFACE VISIBILITY TEST                       */

void visibility_test(void){
sp1=x1*(y2*z3-y3*z2);sp1=(-1)*sp1;sp2=x2*(y3*z1-y01*z3);
sp3=x3*(y01*z2-y2*z1);sp=sp1-sp2-sp3;return;}

/*_______________________________________________________________


SUBROUTINE: DRAW 4-SIDED SOLID POLYGON IN 3D SPACE               */

void draw_poly(void){
setlinestyle(USERBIT_LINE,0xffff,NORM_WIDTH);
setcolor(key_matte_clr);moveto(sx1,sy1);
lineto(sx2,sy2);lineto(sx3,sy3);lineto(sx4,sy4);lineto(sx1,sy1);
setfillstyle(SOLID_FILL,key_matte_clr);floodfill(sx5,sy5,key_matte_clr);
setcolor(edge_clr);moveto(sx1,sy1);
lineto(sx2,sy2);lineto(sx3,sy3);lineto(sx4,sy4);lineto(sx1,sy1);
setfillstyle(SOLID_FILL,solid_clr);floodfill(sx5,sy5,edge_clr);return;}

/*_______________________________________________________________


SUBROUTINE: MAP CARTESIAN COORDS TO PHYSICAL SCREEN COORDS       */

void window(void){
sx=sx+399;sy=sy+299;rx=screen_x/799;ry=screen_y/599;sx=sx*rx;
sy=sy*ry;return;}

/*_______________________________________________________________


SUBROUTINE: CHECK THE KEYBOARD BUFFER                            */

void keyboard(void){
if (bioskey(1)==0) return; else quit_pgm();}

/*_______________________________________________________________


SUBROUTINE: GRACEFUL EXIT FROM THE PROGRAM                       */

void quit_pgm(void){
cleardevice();restorecrtmode();exit(0);}

/*_______________________________________________________________


SUBROUTINE: VGA/EGA/CGA/MCGA compatibility module                */

void graphics_setup(void){
int graphics_adapter,graphics_mode;
detectgraph(&graphics_adapter,&graphics_mode);
if (graphics_adapter==VGA) goto VGA_mode;              /* if VGA */
if (graphics_mode==EGAHI) goto EGA_ECD_mode;   /* if EGA and ECD */
if (graphics_mode==EGALO) goto EGA_SCD_mode;   /* if EGA and SCD */
if (graphics_adapter==CGA) goto CGA_mode;              /* if CGA */
if (graphics_adapter==MCGA) goto CGA_mode;            /* if MCGA */
goto abort_message;              /* if no VGA, EGA, CGA, or MCGA */

VGA_mode:
graphics_adapter=VGA;graphics_mode=VGAHI;
initgraph(&graphics_adapter,&graphics_mode,"");
x_res=640;y_res=480;mode_flag=1;
			maxx=639;minx=0;maxy=479;miny=0;screen_x=639;screen_y=479;
			setcolor(7);moveto(0,472);
			outtext("640x480 16-color VGA mode");
			moveto(472,472);
			outtext("Press any key to quit");
			moveto(176,0);
			outtext("USING C TO GENERATE A SOLID 3D MODEL");
			return;

EGA_ECD_mode:
graphics_adapter=EGA;graphics_mode=EGAHI;
initgraph(&graphics_adapter,&graphics_mode,"");
x_res=640;y_res=350;mode_flag=2;
			maxx=639;minx=0;maxy=349;miny=0;screen_x=639;screen_y=349;
			setcolor(7);moveto(0,342);
			outtext("640x350 16-color EGA mode");
			moveto(472,342);
			outtext("Press any key to quit");
			moveto(176,0);
			outtext("USING C TO GENERATE A SOLID 3D MODEL");
			return;

EGA_SCD_mode:
graphics_adapter=EGA;graphics_mode=EGALO;
initgraph(&graphics_adapter,&graphics_mode,"");
x_res=640;y_res=200;mode_flag=3;
			maxx=639;minx=0;maxy=199;miny=0;screen_x=639;screen_y=199;
			setcolor(7);moveto(0,192);
			outtext("640x200 16-color EGA mode");
			moveto(472,192);
			outtext("Press any key to quit");
			moveto(176,0);
			outtext("USING C TO GENERATE A SOLID 3D MODEL");
			return;

CGA_mode:
graphics_adapter=CGA;graphics_mode=CGAC3;
initgraph(&graphics_adapter,&graphics_mode,"");
x_res=320;y_res=200;C7=3;
			mode_flag=4;
			maxx=319;minx=0;maxy=199;miny=0;screen_x=319;screen_y=199;
			setcolor(3);moveto(48,192);
			outtext("320x200 4-color CGA & MCGA mode");
			moveto(104,0);
			outtext("SOLID 3D MODEL");
			return;

abort_message:
printf("\n\nUnable to proceed.\n");
printf("Requires VGA, EGA, CGA, or MCGA adapter\n");
printf("   with appropriate monitor.\n");
printf("Please refer to the book.\n\n");
exit(0);
}

/*_______________________________________________________________


SUBROUTINE: MAP 640x480 TEMPLATE TO 2D SCREEN                    */

void coords(void){sx=sx*(x_res/640);sy=sy*(y_res/480);return;}

/*_______________________________________________________________


SUBROUTINE: Copyright Notice                                     */

int copyright[][3]={0x7c00,0x0000,0x0000,0x8231,
0x819c,0x645e,0xba4a,0x4252,0x96d0,0xa231,0x8252,0x955e,0xba4a,
0x43d2,0xf442,0x8231,0x825c,0x945e,0x7c00,0x0000,0x0000};

void notice(int x, int y){
int a,b,c; int t1=0;
for (t1=0;t1<=6;t1++){a=copyright[t1][0];b=copyright[t1][1];
c=copyright[t1][2];
setlinestyle(USERBIT_LINE,a,NORM_WIDTH);
moveto(x,y);lineto(x+15,y);
setlinestyle(USERBIT_LINE,b,NORM_WIDTH);
moveto(x+16,y);lineto(x+31,y);
setlinestyle(USERBIT_LINE,c,NORM_WIDTH);
moveto(x+32,y);lineto(x+47,y);y=y+1;};
setlinestyle(USERBIT_LINE,0xFFFF,NORM_WIDTH);
return;}

/*_______________________________________________________________

End of source code                                               */


