//**************************************************************************
//
//  Title: BASE.C
//
//  Author: Jim Cash
//  Version: 1.2
//  Revision History:
//    Original version: June 5, 1990
//    v1.1: February 13, 1991
//    v1.2: June 21, 1991
//
//  LAB #15
//
//  Purpose:
//      The primary purpose of this lab is to demonstrate a way to use
//      a modal dialog box.  This builds on the several of the previous
//      labs which includes the combination of a menu, an edit box, and
//      a File I/O dialog box.
//
//**************************************************************************
#define DEBUGGING
#define DEBUGMSGS
#define _WINDOWS
#include <WINDOWS.H>
#include "BASE.H"
#include <GENLIB.H>

//*------------------------------------------------------------------------
//| Global Variables
//*------------------------------------------------------------------------
HWND    hWnd1;
char    szClassName[] = "OVERLAPPED:1";
char    szAppName[] = "BASE";
HANDLE  hInst;
char    szFileName[80];

//*------------------------------------------------------------------------
//| WinMain:
//|     Parameters:
//|         hInstance     - Handle to current Data Segment
//|         hPrevInstance - Handle to previous Data Segment (NULL if none)
//|         lpszCmdLine   - Long pointer to command line info
//|         nCmdShow      - Integer value specifying how to start app.,
//|                            (Iconic [7] or Normal [1,5])
//*------------------------------------------------------------------------
int PASCAL WinMain (HANDLE hInstance,
                    HANDLE hPrevInstance,
                    LPSTR  lpszCmdLine,
                    int    nCmdShow)
{
int nReturn;

    if (Init(hInstance, hPrevInstance,lpszCmdLine,nCmdShow))
    {
        nReturn = DoMain(hInstance);
        CleanUp();
    }
    return nReturn;
}

//*------------------------------------------------------------------------
//| Init
//|     Initialization for the program is done here:
//|     1)  Register the window class (if this is the first instance)
//|     2)  Create the desktop window for the app.
//|     3)  Show the desktop window in the manner requested by the User.
//|
//*------------------------------------------------------------------------
BOOL Init(HANDLE hInstance,   HANDLE hPrevInstance,
          LPSTR  lpszCmdLine, int    nCmdShow)
{
WNDCLASS    rClass;

    DEBUG("\r\nLAB #15: Sample Name\r\n",0)
    DEBUG("----  Application Initiated  ----\r\n",0)
    DEBUG("hInstance = %04x\r\n",hInstance)
    DEBUG("hPrevInstance = %04x\r\n",hPrevInstance)
    DEBUG("lpszCmdLine = %s\r\n",lpszCmdLine)
    DEBUG("nCmdShow = %04x\r\n",nCmdShow)

    hInst = hInstance;

    if (!hPrevInstance)
    {
        /*  Register Class for First Overlapped Window  */
        rClass.lpszClassName = szClassName;
        rClass.hInstance     = hInstance;
        rClass.lpfnWndProc   = OverlappedWindowProc1;
        rClass.hCursor       = LoadCursor(hInstance,"BASECURSOR");
        rClass.hIcon         = LoadIcon(hInstance,"BASEICON");
        rClass.lpszMenuName  = "BASEMENU";
        rClass.hbrBackground = COLOR_WINDOW+1;
        rClass.style         = CS_VREDRAW | CS_HREDRAW;
        rClass.cbClsExtra    = 0;
        rClass.cbWndExtra    = 0;

        if (!RegisterClass( &rClass))
            return FALSE;
    }

    hWnd1 = CreateWindow(szClassName,
            szAppName,
            WS_OVERLAPPEDWINDOW,
            GetPrivateProfileInt(szAppName,"X",CW_USEDEFAULT,szAppName),
            GetPrivateProfileInt(szAppName,"Y",CW_USEDEFAULT,szAppName),
            GetPrivateProfileInt(szAppName,"CX",CW_USEDEFAULT,szAppName),
            GetPrivateProfileInt(szAppName,"CY",CW_USEDEFAULT,szAppName),
            NULL,
            NULL,
            hInstance,
            NULL);

    DEBUG("hWnd1 = %04x\r\n",hWnd1)

    ShowWindow(hWnd1,nCmdShow);

    return hWnd1;
}

//*------------------------------------------------------------------------
//| DoMain:
//|     This is the main loop for the application:
//*------------------------------------------------------------------------
int  DoMain(HANDLE hInstance)
{
MSG msg;

    while (GetMessage(&msg,NULL,0,0))
    {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
    }
    return msg.wParam;
}

//*------------------------------------------------------------------------
//| CleanUp:
//|     Any last-minute application cleanup activities are done here:
//*------------------------------------------------------------------------
void CleanUp(void)
{
    DEBUG("----  Application Terminated ----\r\n",0)
}

//*------------------------------------------------------------------------
//| OverlappedWindowProc1
//|     Parameters:
//|         hWnd    - Handle to Window which message is delivered to.
//|         msgID   - ID number of message
//|         wParam  - 16-bit parameter
//|         lParam  - 32-bit parameter
//|
//*------------------------------------------------------------------------
long FAR PASCAL OverlappedWindowProc1 (HWND     hWnd,
                                       unsigned wMsgID,
                                       WORD     wParam,
                                       LONG     lParam)
{
RECT    rect;
char    szTempStr[10];
static HANDLE hBuffer=0;
LPSTR       lpBuffer;
int         hFile;
LONG        lFileSize;
static  HWND hWndEdit;
FARPROC     lpfnFileIOProc;
OFSTRUCT    of;
int         nBufferSize;

    DEBUGMSG("O1")
    switch (wMsgID)
    {
    case WM_CREATE:
        hWndEdit = CreateWindow("edit","",
                     WS_CHILD|WS_VISIBLE|ES_AUTOVSCROLL|ES_MULTILINE,
                     0,0,0,0,hWnd,1,hInst, NULL);
        break;

    case WM_SIZE:
        MoveWindow(hWndEdit,0,0,LOWORD(lParam),HIWORD(lParam),TRUE);
        break;

    case WM_SETFOCUS:
        SetFocus(hWndEdit);
        break;

    case WM_DESTROY:
        GetWindowRect(hWnd,&rect);
        wsprintf(szTempStr,"%d",rect.left);
        WritePrivateProfileString(szAppName,"X",szTempStr,szAppName);
        wsprintf(szTempStr,"%d",rect.top);
        WritePrivateProfileString(szAppName,"Y",szTempStr,szAppName);
        wsprintf(szTempStr,"%d",rect.right-rect.left);
        WritePrivateProfileString(szAppName,"CX",szTempStr,szAppName);
        wsprintf(szTempStr,"%d",rect.bottom-rect.top);
        WritePrivateProfileString(szAppName,"CY",szTempStr,szAppName);
        PostQuitMessage(0);
        break;

    case WM_COMMAND:
        DEBUG("wParam = %d\r\n",wParam)
        switch(wParam)
        {
        case IDM_SAVE:
            lpfnFileIOProc = MakeProcInstance(FileIOProc,hInst);
            if (DialogBox(hInst,"FILEIO",hWnd,lpfnFileIOProc))
            {
                hFile = OpenFile(szFileName,&of,OF_CREATE);
                if (hFile == -1)
                {
                    MessageBox(GetFocus(),"File Could Not be Created!","File I/O Error",MB_OK);
                    return 0;
                }

                nBufferSize = GetWindowTextLength(hWndEdit);
                if (hBuffer != NULL)
                    GlobalFree(hBuffer);
                hBuffer = GlobalAlloc(GHND, (LONG)nBufferSize+1);
                lpBuffer = GlobalLock(hBuffer);
                GetWindowText(hWndEdit,lpBuffer,nBufferSize+1);
                _lwrite(hFile,lpBuffer,nBufferSize);
                GlobalUnlock(hBuffer);
                GlobalFree(hBuffer);
                hBuffer = NULL;
                _lclose(hFile);
                DEBUG("File saved...\r\n",0)
            }
            FreeProcInstance(lpfnFileIOProc);
            break;

        case IDM_OPEN:
            lpfnFileIOProc = MakeProcInstance(FileIOProc,hInst);
            if (DialogBox(hInst,"FILEIO",hWnd,lpfnFileIOProc))
            {
                hFile = _lopen(szFileName,OF_READ);
                if (hFile == -1)
                {
                    MessageBox(GetFocus(),"File Not found!","File I/O Error",MB_OK);
                    return 0;
                }

                lFileSize = _llseek(hFile,0L,2);
                _llseek(hFile,0L,0);
                if (lFileSize < 65536)
                {
                    if (hBuffer != NULL)
                        GlobalFree(hBuffer);
                    hBuffer = GlobalAlloc(GHND,lFileSize+1);
                    lpBuffer = GlobalLock(hBuffer);
                    _lread(hFile,lpBuffer,LOWORD(lFileSize));
                    SetWindowText(hWndEdit,lpBuffer);
                    GlobalUnlock(hBuffer);
                    GlobalFree(hBuffer);
                    hBuffer = NULL;
                }
                _lclose(hFile);
            }
            FreeProcInstance(lpfnFileIOProc);
            break;

        case IDM_EXIT:
            DEBUG("Exit\r\n",0)
            PostMessage(hWnd,WM_CLOSE,0,0L);
            break;
        }
        break;

    default:
        return DefWindowProc(hWnd, wMsgID, wParam, lParam);
    }
    return 0;
}

//*------------------------------------------------------------------------
//| FileIOProc
//|     Parameters:
//|         hWnd    - Handle to Window which message is delivered to.
//|         msgID   - ID number of message
//|         wParam  - 16-bit parameter
//|         lParam  - 32-bit parameter
//|
//*------------------------------------------------------------------------
BOOL FAR PASCAL FileIOProc (HWND     hWnd,
                            unsigned wMsgID,
                            WORD     wParam,
                            LONG     lParam)
{

    switch(wMsgID)
    {
    case WM_INITDIALOG:
        return TRUE;

    case WM_COMMAND:
        switch (wParam)
        {
        case IDOK:
            GetDlgItemText(hWnd,IDC_FILENAME,szFileName,80);
            EndDialog(hWnd,TRUE);
            return TRUE;

        case IDCANCEL:
            EndDialog(hWnd,FALSE);
            return TRUE;
        }
        break;
    }
    return FALSE;
}
