//**************************************************************************
//
//  Title: REPAINT.C
//
//  Purpose:
//      This program demonstrates the issues involved with repainting
//      the client area with and without the CS_HREDRAW|CS_VREDRAW
//      attributes.
//
//**************************************************************************
//#define DEBUGGING
#define _WINDOWS
#include <WINDOWS.H>
#include "REPAINT.H"

//*------------------------------------------------------------------------
//| Global Variables
//*------------------------------------------------------------------------
DWORD   rgbColors[NUM_COLORS] = {RGB(255,255,255), RGB(0,0,255),
                                 RGB(0,255,0), RGB(255,0,0),
                                 RGB(0,255,255), RGB(255,0,255),
                                 RGB(255,255,0), RGB(0,0,0) };
HBRUSH  hBrush[NUM_COLORS];
int     nBrushIndex = 0;
#ifdef PAINT1
char    szAppName[] = "REPAINT1";
#else
char    szAppName[] = "REPAINT2";
#endif
BOOL    bPaint = FALSE;


//*------------------------------------------------------------------------
//| WinMain:
//|     Parameters:
//|         hInstance     - Handle to current Data Segment
//|         hPrevInstance - Handle to previous Data Segment (NULL if none)
//|         lpszCmdLine   - Long pointer to command line info
//|         nCmdShow      - Integer value specifying how to start app.,
//|                            (Iconic [7] or Normal [1,5])
//*------------------------------------------------------------------------
int PASCAL WinMain (HANDLE hInstance,
                    HANDLE hPrevInstance,
                    LPSTR  lpszCmdLine,
                    int    nCmdShow)
{
int nReturn;

    if (Init(hInstance, hPrevInstance,lpszCmdLine,nCmdShow))
    {
        nReturn = DoMain(hInstance);
        CleanUp();
    }
    else
        MessageBox(GetFocus(), "Application intialization error!","Error",MB_OK);

    return nReturn;
}

//*------------------------------------------------------------------------
//| Init
//|     Initialization for the program is done here:
//|     1)  Register the window class (if this is the first instance)
//|     2)  Create the desktop window for the app.
//|     3)  Show the desktop window in the manner requested by the User.
//|
//*------------------------------------------------------------------------
BOOL Init(HANDLE hInstance,   HANDLE hPrevInstance,
          LPSTR  lpszCmdLine, int    nCmdShow)
{
WNDCLASS    rClass;
HWND        hWnd1;
int         i;

#ifdef PAINT1
    DEBUG("\n\rREPAINT #1 (Without CS_VREDRAW|CSHREDRAW)\n\r",0)
#else
    DEBUG("\n\rREPAINT #2 (With CS_VREDRAW|CSHREDRAW active)\n\r",0)
#endif
    DEBUG("----  Application Initiated  ----\n\r",0)

    for (i=0; i<NUM_COLORS; i++)
       hBrush[i] = CreateSolidBrush (rgbColors[i]);

    if (!hPrevInstance)
    {
        /*  Register Class for First Overlapped Window  */
        rClass.lpszClassName = "OVERLAPPED:1";
        rClass.hInstance     = hInstance;
        rClass.lpfnWndProc   = OverlappedWindowProc1;
        rClass.hCursor       = LoadCursor(NULL, IDC_ARROW);
        rClass.hIcon         = LoadIcon(hInstance,"REPAINTICON");
        rClass.lpszMenuName  = "REPAINT_MENU";
        rClass.hbrBackground = COLOR_WINDOW+1;
#ifdef PAINT1
        rClass.style         = 0L;
#else
        rClass.style         = CS_HREDRAW|CS_VREDRAW;
#endif
        rClass.cbClsExtra    = 0;
        rClass.cbWndExtra    = 0;

        if (!RegisterClass( &rClass))
            return FALSE;

        /*  Register Class for First Child Window  */
/*
        rClass.lpszClassName = "CHILD:1";
        rClass.lpfnWndProc   = ChildWindowProc1;
        rClass.hCursor       = LoadCursor(NULL, IDC_ARROW);
        rClass.hIcon         = NULL;
        rClass.lpszMenuName  = NULL;
        rClass.style         = 0L;

        if (!RegisterClass( &rClass))
            return FALSE;
*/
    }

    hWnd1 = CreateWindow("OVERLAPPED:1",
#ifdef PAINT1
            "Repaint #1",
#else
            "Repaint #2",
#endif
            WS_OVERLAPPEDWINDOW,
            GetProfileInt(szAppName,"X",CW_USEDEFAULT),
            GetProfileInt(szAppName,"Y",CW_USEDEFAULT),
            GetProfileInt(szAppName,"CX",CW_USEDEFAULT),
            GetProfileInt(szAppName,"CY",CW_USEDEFAULT),
            NULL,
            NULL,
            hInstance,
            NULL);

    DEBUG("hWnd1 = %04x\n\r",hWnd1)
    ShowWindow(hWnd1,nCmdShow);

    return hWnd1;
}

//*------------------------------------------------------------------------
//| DoMain:
//|     This is the main loop for the application:
//*------------------------------------------------------------------------
int  DoMain(HANDLE hInstance)
{
MSG msg;

    while (GetMessage(&msg,NULL,0,0))
    {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
    }
    return msg.wParam;
}

//*------------------------------------------------------------------------
//| CleanUp:
//|     Any last-minute application cleanup activities are done here:
//*------------------------------------------------------------------------
void CleanUp(void)
{
    DEBUG("----  Application Terminated ----\n\r",0)
}

//*------------------------------------------------------------------------
//| OverlappedWindowProc1
//|     Parameters:
//|         hWnd    - Handle to Window which message is delivered to.
//|         msgID   - ID number of message
//|         wParam  - 16-bit parameter
//|         lParam  - 32-bit parameter
//|
//*------------------------------------------------------------------------
long FAR PASCAL OverlappedWindowProc1 (HWND     hWnd,
                                       unsigned wMsgID,
                                       WORD     wParam,
                                       LONG     lParam)
{
RECT        rect;
char        szTempStr[10];
int         i;
PAINTSTRUCT ps;
static RECT rClient;

    //DEBUGMSG("O1")
    switch (wMsgID)
    {
    case WM_COMMAND:
        switch (wParam)
        {
        case REPMENU_CLEAR:
            nBrushIndex = 0;
            InvalidateRect(hWnd,NULL,TRUE);
            break;

        case REPMENU_DIALOGBOX:
            break;

        case REPMENU_CREATECHILD:
            break;
        }
        break;

    case WM_ERASEBKGND:
        if (!bPaint)
        {
            DEBUG("WM_ERASEBKGND\n\r",0)
            GetClientRect(hWnd,&rClient);
            FillRect((HDC)wParam, &rClient, hBrush[nBrushIndex]);
            nBrushIndex = ++nBrushIndex % NUM_COLORS;
        }
        return (LONG) !bPaint;

    case WM_PAINT:
        if (bPaint)
        {
            BeginPaint (hWnd, &ps);
            FillRect (ps.hdc, &ps.rcPaint, hBrush[nBrushIndex]);
            nBrushIndex = ++nBrushIndex % NUM_COLORS;
            EndPaint (hWnd, &ps);
            break;
        }
        else
            return DefWindowProc(hWnd, wMsgID, wParam, lParam);

    case WM_DESTROY:
        for (i=0; i<NUM_COLORS; i++)
           DeleteObject (hBrush[i]);

        GetWindowRect(hWnd,&rect);
        wsprintf(szTempStr,"%d",rect.left);
        WriteProfileString(szAppName,"X",szTempStr);
        wsprintf(szTempStr,"%d",rect.top);
        WriteProfileString(szAppName,"Y",szTempStr);
        wsprintf(szTempStr,"%d",rect.right-rect.left);
        WriteProfileString(szAppName,"CX",szTempStr);
        wsprintf(szTempStr,"%d",rect.bottom-rect.top);
        WriteProfileString(szAppName,"CY",szTempStr);
        PostQuitMessage(0);
        break;

    default:
        return DefWindowProc(hWnd, wMsgID, wParam, lParam);
    }
    return 0;
}
