//**************************************************************************
//
//  Title: BASE.C
//
//  Purpose:
//      This program is a demo of the different mapping modes available in
//      Windows.
//
//**************************************************************************
//#define DEBUGGING
//#define DEBUGMSGS
#define _WINDOWS
#include <WINDOWS.H>
#include "BASE.H"
#include <GENLIB.H>

//*------------------------------------------------------------------------
//| Global Variables
//*------------------------------------------------------------------------
HWND    hWnd1;

//*------------------------------------------------------------------------
//| WinMain:
//|     Parameters:
//|         hInstance     - Handle to current Data Segment
//|         hPrevInstance - Handle to previous Data Segment (NULL if none)
//|         lpszCmdLine   - Long pointer to command line info
//|         nCmdShow      - Integer value specifying how to start app.,
//|                            (Iconic [7] or Normal [1,5])
//*------------------------------------------------------------------------
int PASCAL WinMain (HANDLE hInstance,
                    HANDLE hPrevInstance,
                    LPSTR  lpszCmdLine,
                    int    nCmdShow)
{
int nReturn;

    if (Init(hInstance, hPrevInstance,lpszCmdLine,nCmdShow))
    {
        nReturn = DoMain(hInstance);
        CleanUp();
    }
    return nReturn;
}

//*------------------------------------------------------------------------
//| Init
//|     Initialization for the program is done here:
//|     1)  Register the window class (if this is the first instance)
//|     2)  Create the desktop window for the app.
//|     3)  Show the desktop window in the manner requested by the User.
//|
//*------------------------------------------------------------------------
BOOL Init(HANDLE hInstance,   HANDLE hPrevInstance,
          LPSTR  lpszCmdLine, int    nCmdShow)
{
WNDCLASS    rClass;

    DEBUG("----  Application Initiated  ----\n\r",0)

    if (!hPrevInstance)
    {
        /*  Register Class for First Overlapped Window  */
        rClass.lpszClassName = "OVERLAPPED:1";
        rClass.hInstance     = hInstance;
        rClass.lpfnWndProc   = OverlappedWindowProc1;
        rClass.hCursor       = LoadCursor(hInstance,"BASECURSOR");
        rClass.hIcon         = LoadIcon(hInstance,"BASEICON");
        rClass.lpszMenuName  = "BASEMENU";
        rClass.hbrBackground = COLOR_WINDOW+1;
        rClass.style         = CS_VREDRAW | CS_HREDRAW;
        rClass.cbClsExtra    = 0;
        rClass.cbWndExtra    = 0;

        if (!RegisterClass( &rClass))
            return FALSE;
    }

    hWnd1 = CreateWindow("OVERLAPPED:1",
            "BASE",
            WS_OVERLAPPEDWINDOW,
            GetProfileInt("BASE","X",CW_USEDEFAULT),
            GetProfileInt("BASE","Y",CW_USEDEFAULT),
            GetProfileInt("BASE","CX",CW_USEDEFAULT),
            GetProfileInt("BASE","CY",CW_USEDEFAULT),
            NULL,
            NULL,
            hInstance,
            NULL);

    DEBUG("hWnd1 = %04x\n\r",hWnd1)

    ShowWindow(hWnd1,nCmdShow);

    return hWnd1;
}

//*------------------------------------------------------------------------
//| DoMain:
//|     This is the main loop for the application:
//*------------------------------------------------------------------------
int  DoMain(HANDLE hInstance)
{
MSG msg;
HANDLE  hAccel;

    hAccel = LoadAccelerators(hInstance,"BASEACCELS");
    while (GetMessage(&msg,NULL,0,0))
    {
        if (!TranslateAccelerator(hWnd1,hAccel,&msg))
        {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }
    }
    return msg.wParam;
}

//*------------------------------------------------------------------------
//| CleanUp:
//|     Any last-minute application cleanup activities are done here:
//*------------------------------------------------------------------------
void CleanUp(void)
{
    DEBUG("----  Application Terminated ----\n\r",0)
}

//*------------------------------------------------------------------------
//| OverlappedWindowProc1
//|     Parameters:
//|         hWnd    - Handle to Window which message is delivered to.
//|         msgID   - ID number of message
//|         wParam  - 16-bit parameter
//|         lParam  - 32-bit parameter
//|
//*------------------------------------------------------------------------
long FAR PASCAL OverlappedWindowProc1 (HWND     hWnd,
                                       unsigned wMsgID,
                                       WORD     wParam,
                                       LONG     lParam)
{
RECT    rect;
char    szTempStr[10];
HDC     hMetaDC;
HFONT   hFont;
PAINTSTRUCT ps;
static  int nWidth,nHeight;
static  int nCurMapMode=MM_TEXT;
static  HANDLE hMF;

    DEBUGMSG("O1")
    switch (wMsgID)
    {
    case WM_CREATE:
        hMetaDC = CreateMetaFile(NULL);
        Rectangle(hMetaDC,0,0,100,100);
        Arc(hMetaDC,0,50,100,150,100,100,0,100);
        Arc(hMetaDC,50,0,150,100,100,0,100,100);
        Arc(hMetaDC,0,-50,100,50,0,0,100,0);
        Arc(hMetaDC,-50,0,50,100,0,100,0,0);
        hMF = CloseMetaFile(hMetaDC);
        break;

    case WM_DESTROY:
        GetWindowRect(hWnd,&rect);
        wsprintf(szTempStr,"%d",rect.left);
        WriteProfileString("BASE","X",szTempStr);
        wsprintf(szTempStr,"%d",rect.top);
        WriteProfileString("BASE","Y",szTempStr);
        wsprintf(szTempStr,"%d",rect.right-rect.left);
        WriteProfileString("BASE","CX",szTempStr);
        wsprintf(szTempStr,"%d",rect.bottom-rect.top);
        WriteProfileString("BASE","CY",szTempStr);
        PostQuitMessage(0);
        break;

    case WM_COMMAND:
        switch(wParam)
        {
        case IDM_TEXT:
        case IDM_LOMETRIC:
        case IDM_HIMETRIC:
        case IDM_LOENGLISH:
        case IDM_HIENGLISH:
        case IDM_TWIPS:
        case IDM_ISOTROPIC:
        case IDM_ANISOTROPIC:
            nCurMapMode = wParam-100;
            DEBUG("Map Mode = %d\n\r",nCurMapMode)
            InvalidateRect(hWnd,NULL,TRUE);
            break;

        case IDM_EXIT:
            PostMessage(hWnd,WM_CLOSE,0,0L);
            break;
        }
        break;

    case WM_SIZE:
        nWidth = LOWORD(lParam);
        nHeight = HIWORD(lParam);
        break;

    case WM_PAINT:
        BeginPaint(hWnd,&ps);
        MoveTo(ps.hdc,nWidth/2,0);
        LineTo(ps.hdc,nWidth/2,nHeight);
        MoveTo(ps.hdc,0,nHeight/2);
        LineTo(ps.hdc,nWidth,nHeight/2);
        SetMapMode(ps.hdc,nCurMapMode);
        if ((nCurMapMode == MM_ISOTROPIC) || (nCurMapMode == MM_ANISOTROPIC))
        {
            SetWindowExt(ps.hdc,500,500);
            SetViewportExt(ps.hdc,nWidth,nHeight);
        }
        SetViewportOrg(ps.hdc,nWidth/2,nHeight/2);
        PlayMetaFile(ps.hdc,hMF);
        EndPaint(hWnd,&ps);
        break;

    default:
        return DefWindowProc(hWnd, wMsgID, wParam, lParam);
    }
    return 0;
}
