//**************************************************************************
//
//  Title: BASE.C
//
//  Author: Jim Cash
//  Version: 1.2
//  Revision History:
//    Original version: June 5, 1990
//    v1.1: February 13, 1991
//    v1.2: June 21, 1991
//
//  LAB #11
//
//  Purpose:
//      This continues LAB10 by adding Scrolling capabilities.
//
//**************************************************************************
#define DEBUGGING
//#define DEBUGMSGS
#define _WINDOWS
#include <WINDOWS.H>
#include "BASE.H"
#include <GENLIB.H>

//*------------------------------------------------------------------------
//| Global Variables
//*------------------------------------------------------------------------
HWND    hWnd1;
char    szClassName[] = "OVERLAPPED:1";
char    szAppName[] = "BASE";

//*------------------------------------------------------------------------
//| WinMain:
//|     Parameters:
//|         hInstance     - Handle to current Data Segment
//|         hPrevInstance - Handle to previous Data Segment (NULL if none)
//|         lpszCmdLine   - Long pointer to command line info
//|         nCmdShow      - Integer value specifying how to start app.,
//|                            (Iconic [7] or Normal [1,5])
//*------------------------------------------------------------------------
int PASCAL WinMain (HANDLE hInstance,
                    HANDLE hPrevInstance,
                    LPSTR  lpszCmdLine,
                    int    nCmdShow)
{
int nReturn;

    if (Init(hInstance, hPrevInstance,lpszCmdLine,nCmdShow))
    {
        nReturn = DoMain(hInstance);
        CleanUp();
    }
    return nReturn;
}

//*------------------------------------------------------------------------
//| Init
//|     Initialization for the program is done here:
//|     1)  Register the window class (if this is the first instance)
//|     2)  Create the desktop window for the app.
//|     3)  Show the desktop window in the manner requested by the User.
//|
//*------------------------------------------------------------------------
BOOL Init(HANDLE hInstance,   HANDLE hPrevInstance,
          LPSTR  lpszCmdLine, int    nCmdShow)
{
WNDCLASS    rClass;

    DEBUG("\r\nLAB #11: Sample Name\r\n",0)
    DEBUG("----  Application Initiated  ----\r\n",0)
    DEBUG("hInstance = %04x\r\n",hInstance)
    DEBUG("hPrevInstance = %04x\r\n",hPrevInstance)
    DEBUG("lpszCmdLine = %s\r\n",lpszCmdLine)
    DEBUG("nCmdShow = %04x\r\n",nCmdShow)

    if (!hPrevInstance)
    {
        /*  Register Class for First Overlapped Window  */
        rClass.lpszClassName = szClassName;
        rClass.hInstance     = hInstance;
        rClass.lpfnWndProc   = OverlappedWindowProc1;
        rClass.hCursor       = LoadCursor(hInstance,"BASECURSOR");
        rClass.hIcon         = LoadIcon(hInstance,"BASEICON");
        rClass.lpszMenuName  = "BASEMENU";
        rClass.hbrBackground = COLOR_WINDOW+1;
        rClass.style         = 0L;
        rClass.cbClsExtra    = 0;
        rClass.cbWndExtra    = 0;

        if (!RegisterClass( &rClass))
            return FALSE;
    }

    hWnd1 = CreateWindow(szClassName,
            szAppName,
            WS_VSCROLL|
            WS_OVERLAPPEDWINDOW,
            GetPrivateProfileInt(szAppName,"X",CW_USEDEFAULT,szAppName),
            GetPrivateProfileInt(szAppName,"Y",CW_USEDEFAULT,szAppName),
            GetPrivateProfileInt(szAppName,"CX",CW_USEDEFAULT,szAppName),
            GetPrivateProfileInt(szAppName,"CY",CW_USEDEFAULT,szAppName),
            NULL,
            NULL,
            hInstance,
            NULL);

    DEBUG("hWnd1 = %04x\r\n",hWnd1)

    ShowWindow(hWnd1,nCmdShow);

    return hWnd1;
}

//*------------------------------------------------------------------------
//| DoMain:
//|     This is the main loop for the application:
//*------------------------------------------------------------------------
int  DoMain(HANDLE hInstance)
{
MSG msg;
HANDLE  hAccel;

    hAccel = LoadAccelerators(hInstance,"BASEACCELS");
    while (GetMessage(&msg,NULL,0,0))
    {
        if (!TranslateAccelerator(hWnd1,hAccel,&msg))
        {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }
    }
    return msg.wParam;
}

//*------------------------------------------------------------------------
//| CleanUp:
//|     Any last-minute application cleanup activities are done here:
//*------------------------------------------------------------------------
void CleanUp(void)
{
    DEBUG("----  Application Terminated ----\r\n",0)
}

//*------------------------------------------------------------------------
//| OverlappedWindowProc1
//|     Parameters:
//|         hWnd    - Handle to Window which message is delivered to.
//|         msgID   - ID number of message
//|         wParam  - 16-bit parameter
//|         lParam  - 32-bit parameter
//|
//*------------------------------------------------------------------------
long FAR PASCAL OverlappedWindowProc1 (HWND     hWnd,
                                       unsigned wMsgID,
                                       WORD     wParam,
                                       LONG     lParam)
{
RECT    rect;
char    szTempStr[10];
HDC     hDC;
HFONT   hFont;
PAINTSTRUCT ps;
static  int nWidth,nHeight;
TEXTMETRIC  tm;
int         nLineHeight,nY,nStrLen;
static HANDLE hBuffer=0;
LPSTR       lpBuffer;
int         hFile;
LONG        lFileSize;
static  int nLineCtr,nLinePtr;
int     i;

    DEBUGMSG("O1")
    switch (wMsgID)
    {
    case WM_CREATE:
        SetScrollRange(hWnd,SB_VERT,0,0,TRUE);
        break;

    case WM_DESTROY:
        GetWindowRect(hWnd,&rect);
        wsprintf(szTempStr,"%d",rect.left);
        WritePrivateProfileString(szAppName,"X",szTempStr,szAppName);
        wsprintf(szTempStr,"%d",rect.top);
        WritePrivateProfileString(szAppName,"Y",szTempStr,szAppName);
        wsprintf(szTempStr,"%d",rect.right-rect.left);
        WritePrivateProfileString(szAppName,"CX",szTempStr,szAppName);
        wsprintf(szTempStr,"%d",rect.bottom-rect.top);
        WritePrivateProfileString(szAppName,"CY",szTempStr,szAppName);
        if (hBuffer)
            GlobalFree(hBuffer);
        PostQuitMessage(0);
        break;

    case WM_COMMAND:
        DEBUG("wParam = %d\r\n",wParam)
        hDC = GetDC(hWnd);
        SetViewportOrg(hDC,nWidth/2,nHeight/2);
        switch(wParam)
        {
        case IDM_TEXTOUT1:
            DEBUG("TextOut1\r\n",0)
            TextOut(hDC,0,0,"TextOut #1",10);
            break;

        case IDM_TEXTOUT2:
            DEBUG("TextOut2\r\n",0)
            SetTextColor(hDC,RGB(0xFF,0x00,0x00));
            SetBkColor(hDC,RGB(0x00,0xFF,0x00));
            break;

        case IDM_TEXTOUT3:
            DEBUG("TextOut3\r\n",0)
            SetTextColor(hDC,RGB(0xFF,0x00,0xFF));
            SetBkColor(hDC,RGB(0x00,0xFF,0xFF));
            hFont = GetStockObject(SYSTEM_FIXED_FONT);
            SelectObject(hDC,hFont);
            SetTextAlign(hDC,TA_CENTER|TA_BOTTOM);
            break;

        case IDM_MODAL:
            DEBUG("Modal\r\n",0)
            hFile = _lopen("base.def",OF_READ);
            if (hFile != -1)
            {
                lFileSize = _llseek(hFile,0L,2);
                _llseek(hFile,0L,0);
                if (lFileSize < 65536)
                {
                    if (hBuffer != NULL)
                        GlobalFree(hBuffer);
                    hBuffer = GlobalAlloc(GMEM_MOVEABLE|GMEM_ZEROINIT,lFileSize);
                    lpBuffer = GlobalLock(hBuffer);
                    _lread(hFile,lpBuffer,LOWORD(lFileSize));
                    nLineCtr = 0;
                    while (nStrLen = FindChr(lpBuffer,'\r'))
                    {
                        lpBuffer += nStrLen;
                        nLineCtr++;
                    }
                    nLineCtr++;
                    SetScrollRange(hWnd,SB_VERT,0,nLineCtr,TRUE);
                    GlobalUnlock(hBuffer);
                    InvalidateRect(hWnd,NULL,TRUE);
                }
                _lclose(hFile);
            }
            break;

        case IDM_MODELESS:
            DEBUG("Modeless\r\n",0)
            break;
        case IDM_EXIT:
            DEBUG("Exit\r\n",0)
            PostMessage(hWnd,WM_CLOSE,0,0L);
            break;
        }
        ReleaseDC(hWnd,hDC);
        break;

    case WM_SIZE:
        nWidth = LOWORD(lParam);
        nHeight = HIWORD(lParam);
        break;

    case WM_PAINT:
        BeginPaint(hWnd,&ps);
        if (hBuffer != NULL)
        {
            nY = 0;
            GetTextMetrics(ps.hdc,&tm);
            nLineHeight = tm.tmHeight + tm.tmExternalLeading;
            lpBuffer = GlobalLock(hBuffer);
            if (lpBuffer != NULL)
            {
                for (i=0; i < nLinePtr; i++)
                {
                    lpBuffer += FindChr(lpBuffer,'\r');
                    if (*lpBuffer == '\n')
                        lpBuffer++;
                }

                while (nStrLen = FindChr(lpBuffer,'\r'))
                {
                    TextOut(ps.hdc,0,nY,lpBuffer,nStrLen-1);
                    nY += nLineHeight;
                    lpBuffer += nStrLen;
                    if (*lpBuffer == '\n')
                        lpBuffer++;
                }
                TextOut(ps.hdc,0,nY,lpBuffer,lstrlen(lpBuffer));
            }
            GlobalUnlock(hBuffer);
        }
        EndPaint(hWnd,&ps);
        break;

    case WM_VSCROLL:
        switch(wParam)
        {
        case SB_LINEUP:
            if (nLinePtr > 0)
            {
                nLinePtr--;
                InvalidateRect(hWnd,NULL,TRUE);
            }
            break;

        case SB_LINEDOWN:
            if (nLinePtr < nLineCtr)
            {
                nLinePtr++;
                InvalidateRect(hWnd,NULL,TRUE);
            }
            break;
        }
        SetScrollPos(hWnd,SB_VERT,nLinePtr,TRUE);
        UpdateWindow(hWnd);
        break;
    default:
        return DefWindowProc(hWnd, wMsgID, wParam, lParam);
    }
    return 0;
}

