%-*
0 \wpelabs\lab00\base.c     Minimum program
1 \wpelabs\lab01\base.c     Debugging info added
2 \wpelabs\lab02\base.c     Register Class + Create Window + ShowWindow
3 \wpelabs\lab03\base.c     Message Loop + PostQuitMessage
4 \wpelabs\lab04\base.c     Window background & stock Icon/Cursor
5 \wpelabs\lab05\base.c     Custom Icon Cursor
6 \wpelabs\lab06\base.c     Profile File handling
7 \wpelabs\lab07\base.c     Attach Menu to app.
8 \wpelabs\lab08\base.c     TextOut
9 \wpelabs\lab09\base.c     Paint/Repaint
A \wpelabs\lab10\base.c     Memory Mgmt + File I/O
B \wpelabs\lab11\base.c     Scrolling
C \wpelabs\lab14\base.c     Edit box added to client area
D \wpelabs\lab15\base.c     File I/O dialog box
E \wpelabs\lab16\base.c     Mouse Movement info
F \wpelabs\lab18\base.c     MetaFile
%+*
//**************************************************************************
//
//  Title: BASE.C
//
//  Author: Jim Cash
//  Version: 1.2
//  Revision History:
//    Original version: June 5, 1990
//    v1.1: February 13, 1991
//    v1.2: June 21, 1991
//
%=0
//  LAB #00
%=1
//  LAB #01
%=2
//  LAB #02
%=3
//  LAB #03
%=4
//  LAB #04
%=5
//  LAB #05
%=6
//  LAB #06
%=7
//  LAB #07
%=8
//  LAB #08
%=9
//  LAB #09
%=A
//  LAB #10
%=B
//  LAB #11
%=C
//  LAB #14
%=D
//  LAB #15
%=E
//  LAB #16
%=F
//  LAB #18
%+*
//
//  Purpose:
%=0
//      This is the bare Minimum program: It compiles without warnings or
//      errors, and it runs without crashing the system.
%=1
//      This is LAB00 plus a demonstration of the use of the DEBUG macro
//      to display the contents of the WinMain parameters.
%=2
//      This is LAB01 plus the RegisterClass, CreateWindow, and ShowWindow
//      routines added.
%=3
//      This is LAB02 plus the Message Loop and PostQuitMessage handling
//      routines.
%=4
//      This is LAB03 with a real Window background & a stock Icon and
//      Cursor.
%=5
//      This is LAB04, but with a Custom Icon and Cursor.
%=6
//      This is LAB05 with the code which allows the app to "remember"
//      its last location and size on the screen.
%=7
//      This is LAB06, but with a minimal menu attached.  The menuitems
//      only report that they have been selected to the debug terminal.
%=8
//      This builds on LAB07 to cause text to be output to the client
//      area on certain WM_COMMAND messages from the attached menu.
%=9
//      This builds on LAB08 to include the handling needed for the
//      WM_PAINT message.
%=A
//      This builds on LAB09 to demonstrate some simplistic Memory Mgmt
//      and File I/O techniques.
%=B
//      This continues LAB10 by adding Scrolling capabilities.
%=C
//      This builds on LAB06 to demonstrate how a predefined window type
//      can be attached to an overlapped window.  (This is similar to
//      what is done in MDI - but in this case uses an Edit box.)
%=D
//      The primary purpose of this lab is to demonstrate a way to use
//      a modal dialog box.  This builds on the several of the previous
//      labs which includes the combination of a menu, an edit box, and
//      a File I/O dialog box.
%=E
//      This builds on LAB06 to demonstrate Mouse Movement information.
%=F
//      This builds on LAB06 to demonstrate simple methods of using a
//      MetaFile.
%+*
//
//**************************************************************************
#define DEBUGGING
%=2>
//#define DEBUGMSGS
%+*
#define _WINDOWS
#include <WINDOWS.H>
#include "BASE.H"
%=2>
#include <GENLIB.H>
%+*

%=2>
//*------------------------------------------------------------------------
//| Global Variables
//*------------------------------------------------------------------------
%=2>
HWND    hWnd1;
char    szClassName[] = "OVERLAPPED:1";
char    szAppName[] = "BASE";
%=CD
HANDLE  hInst;
%=D
char    szFileName[80];
%+*

//*------------------------------------------------------------------------
//| WinMain:
//|     Parameters:
//|         hInstance     - Handle to current Data Segment
//|         hPrevInstance - Handle to previous Data Segment (NULL if none)
//|         lpszCmdLine   - Long pointer to command line info
//|         nCmdShow      - Integer value specifying how to start app.,
//|                            (Iconic [7] or Normal [1,5])
//*------------------------------------------------------------------------
int PASCAL WinMain (HANDLE hInstance,
                    HANDLE hPrevInstance,
                    LPSTR  lpszCmdLine,
                    int    nCmdShow)
{
int nReturn;

    if (Init(hInstance, hPrevInstance,lpszCmdLine,nCmdShow))
    {
        nReturn = DoMain(hInstance);
        CleanUp();
    }
    return nReturn;
}

//*------------------------------------------------------------------------
//| Init
//|     Initialization for the program is done here:
%=2>
//|     1)  Register the window class (if this is the first instance)
//|     2)  Create the desktop window for the app.
//|     3)  Show the desktop window in the manner requested by the User.
%+*
//|
//*------------------------------------------------------------------------
BOOL Init(HANDLE hInstance,   HANDLE hPrevInstance,
          LPSTR  lpszCmdLine, int    nCmdShow)
{
%=2>
WNDCLASS    rClass;

%=0
    DEBUG("\r\nLAB #00: STUDENT\r\n",0)
%=1
    DEBUG("\r\nLAB #01: Sample Name\r\n",0)
%=2
    DEBUG("\r\nLAB #02: Sample Name\r\n",0)
%=3
    DEBUG("\r\nLAB #03: Sample Name\r\n",0)
%=4
    DEBUG("\r\nLAB #04: Sample Name\r\n",0)
%=5
    DEBUG("\r\nLAB #05: Sample Name\r\n",0)
%=6
    DEBUG("\r\nLAB #06: Sample Name\r\n",0)
%=7
    DEBUG("\r\nLAB #07: Sample Name\r\n",0)
%=8
    DEBUG("\r\nLAB #08: Sample Name\r\n",0)
%=9
    DEBUG("\r\nLAB #09: Sample Name\r\n",0)
%=A
    DEBUG("\r\nLAB #10: Sample Name\r\n",0)
%=B
    DEBUG("\r\nLAB #11: Sample Name\r\n",0)
%=C
    DEBUG("\r\nLAB #14: Sample Name\r\n",0)
%=D
    DEBUG("\r\nLAB #15: Sample Name\r\n",0)
%=E
    DEBUG("\r\nLAB #16: Sample Name\r\n",0)
%=F
    DEBUG("\r\nLAB #18: Sample Name\r\n",0)
%+*
    DEBUG("----  Application Initiated  ----\r\n",0)
%=1>
    DEBUG("hInstance = %04x\r\n",hInstance)
    DEBUG("hPrevInstance = %04x\r\n",hPrevInstance)
    DEBUG("lpszCmdLine = %s\r\n",lpszCmdLine)
    DEBUG("nCmdShow = %04x\r\n",nCmdShow)

%=CD
    hInst = hInstance;

%=2>
    if (!hPrevInstance)
    {
        /*  Register Class for First Overlapped Window  */
        rClass.lpszClassName = szClassName;
        rClass.hInstance     = hInstance;
        rClass.lpfnWndProc   = OverlappedWindowProc1;
%=23
        rClass.hCursor       = NULL;
%=4
        rClass.hCursor       = LoadCursor(NULL,IDC_ARROW);
%=5>
        rClass.hCursor       = LoadCursor(hInstance,"BASECURSOR");
%=23
        rClass.hIcon         = NULL;
%=4
        rClass.hIcon         = LoadIcon(NULL,IDI_APPLICATION);
%=5>
        rClass.hIcon         = LoadIcon(hInstance,"BASEICON");
%=2~6
        rClass.lpszMenuName  = NULL;
%=7>
        rClass.lpszMenuName  = "BASEMENU";
%=23
        rClass.hbrBackground = NULL;
%=4
        rClass.hbrBackground = GetStockObject(WHITE_BRUSH);
%=5>
        rClass.hbrBackground = COLOR_WINDOW+1;
%=2~8ABE>
        rClass.style         = 0L;
%=9CD
        rClass.style         = CS_VREDRAW | CS_HREDRAW;
%=2>
        rClass.cbClsExtra    = 0;
        rClass.cbWndExtra    = 0;

        if (!RegisterClass( &rClass))
            return FALSE;
    }

    hWnd1 = CreateWindow(szClassName,
            szAppName,
%=B
            WS_VSCROLL|
%=2>
            WS_OVERLAPPEDWINDOW,
%=6>
            GetPrivateProfileInt(szAppName,"X",CW_USEDEFAULT,szAppName),
            GetPrivateProfileInt(szAppName,"Y",CW_USEDEFAULT,szAppName),
            GetPrivateProfileInt(szAppName,"CX",CW_USEDEFAULT,szAppName),
            GetPrivateProfileInt(szAppName,"CY",CW_USEDEFAULT,szAppName),
%=2~5
            CW_USEDEFAULT,
            CW_USEDEFAULT,
            CW_USEDEFAULT,
            CW_USEDEFAULT,
%=2>
            NULL,
            NULL,
            hInstance,
            NULL);

    DEBUG("hWnd1 = %04x\r\n",hWnd1)

    ShowWindow(hWnd1,nCmdShow);

%=01
    return TRUE;
%=2>
    return hWnd1;
%+*
}

//*------------------------------------------------------------------------
//| DoMain:
//|     This is the main loop for the application:
//*------------------------------------------------------------------------
int  DoMain(HANDLE hInstance)
{
%=3>
MSG msg;
%=7~B
HANDLE  hAccel;
%+*

%=7~B
    hAccel = LoadAccelerators(hInstance,"BASEACCELS");
%=3>
    while (GetMessage(&msg,NULL,0,0))
    {
%=3~6C>
        TranslateMessage(&msg);
        DispatchMessage(&msg);
%=7~B
        if (!TranslateAccelerator(hWnd1,hAccel,&msg))
        {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }
%=3>
    }
    return msg.wParam;
%=0~2
    return 0;
%+*
}

%+*
//*------------------------------------------------------------------------
//| CleanUp:
//|     Any last-minute application cleanup activities are done here:
//*------------------------------------------------------------------------
void CleanUp(void)
{
    DEBUG("----  Application Terminated ----\r\n",0)
}

%=2>
//*------------------------------------------------------------------------
//| OverlappedWindowProc1
//|     Parameters:
//|         hWnd    - Handle to Window which message is delivered to.
//|         msgID   - ID number of message
//|         wParam  - 16-bit parameter
//|         lParam  - 32-bit parameter
//|
//*------------------------------------------------------------------------
long FAR PASCAL OverlappedWindowProc1 (HWND     hWnd,
                                       unsigned wMsgID,
                                       WORD     wParam,
                                       LONG     lParam)
{
%=6>
RECT    rect;
char    szTempStr[10];
%=8~BEF
HDC     hDC;
%=F
HDC     hMetaDC;
%=8~B
HFONT   hFont;
%=9~B
PAINTSTRUCT ps;
static  int nWidth,nHeight;
%=A~B
TEXTMETRIC  tm;
int         nLineHeight,nY,nStrLen;
%+D
static HANDLE hBuffer=0;
LPSTR       lpBuffer;
int         hFile;
LONG        lFileSize;
%=B
static  int nLineCtr,nLinePtr;
int     i;
%=CD
static  HWND hWndEdit;
%=D
FARPROC     lpfnFileIOProc;
OFSTRUCT    of;
int         nBufferSize;
%=E
int static  nX=0;
int static  nY=0;
char static szPosition[20] = "";
DWORD       dwOldColor;
%=F
static  HANDLE  hMF;
%=2>

    DEBUGMSG("O1")
    switch (wMsgID)
    {
%=F
    case WM_LBUTTONDOWN:
        hDC = GetDC(hWnd);
        SetViewportOrg(hDC,LOWORD(lParam),HIWORD(lParam));
        PlayMetaFile(hDC,hMF);
        ReleaseDC(hWnd,hDC);
        break;

%=E
    case WM_MOUSEMOVE:
        hDC = GetDC(hWnd);
        SetTextAlign(hDC,TA_RIGHT);
        dwOldColor = SetTextColor(hDC,GetSysColor(COLOR_WINDOW));
        TextOut(hDC,nX,nY,szPosition,lstrlen(szPosition));
        SetTextColor(hDC,dwOldColor);
        nX = LOWORD(lParam);
        nY = HIWORD(lParam);
        wsprintf(szPosition,"X:%d; Y:%d",nX,nY);
        TextOut(hDC,nX,nY,szPosition,lstrlen(szPosition));
        ReleaseDC(hWnd,hDC);
        return DefWindowProc(hWnd, wMsgID, wParam, lParam);

%=B>
    case WM_CREATE:
%=B
        SetScrollRange(hWnd,SB_VERT,0,0,TRUE);
%=CD
        hWndEdit = CreateWindow("edit","",
                     WS_CHILD|WS_VISIBLE|ES_AUTOVSCROLL|ES_MULTILINE,
                     0,0,0,0,hWnd,1,hInst, NULL);
%=F
        hMetaDC = CreateMetaFile(NULL);
        Rectangle(hMetaDC,0,0,100,100);
        Arc(hMetaDC,0,50,100,150,100,100,0,100);
        Arc(hMetaDC,50,0,150,100,100,0,100,100);
        Arc(hMetaDC,0,-50,100,50,0,0,100,0);
        Arc(hMetaDC,-50,0,50,100,0,100,0,0);
        hMF = CloseMetaFile(hMetaDC);
%=B>
        break;

%=CD
    case WM_SIZE:
        MoveWindow(hWndEdit,0,0,LOWORD(lParam),HIWORD(lParam),TRUE);
        break;

    case WM_SETFOCUS:
        SetFocus(hWndEdit);
        break;

%=3>
    case WM_DESTROY:
%=6>
        GetWindowRect(hWnd,&rect);
        wsprintf(szTempStr,"%d",rect.left);
        WritePrivateProfileString(szAppName,"X",szTempStr,szAppName);
        wsprintf(szTempStr,"%d",rect.top);
        WritePrivateProfileString(szAppName,"Y",szTempStr,szAppName);
        wsprintf(szTempStr,"%d",rect.right-rect.left);
        WritePrivateProfileString(szAppName,"CX",szTempStr,szAppName);
        wsprintf(szTempStr,"%d",rect.bottom-rect.top);
        WritePrivateProfileString(szAppName,"CY",szTempStr,szAppName);
%=AB
        if (hBuffer)
            GlobalFree(hBuffer);
%=3>
        PostQuitMessage(0);
        break;

%=7~BD
    case WM_COMMAND:
        DEBUG("wParam = %d\r\n",wParam)
%=8~B
        hDC = GetDC(hWnd);
%=9~B
        SetViewportOrg(hDC,nWidth/2,nHeight/2);
%=7~BD
        switch(wParam)
        {
%=D
        case IDM_SAVE:
            lpfnFileIOProc = MakeProcInstance(FileIOProc,hInst);
            if (DialogBox(hInst,"FILEIO",hWnd,lpfnFileIOProc))
            {
                hFile = OpenFile(szFileName,&of,OF_CREATE);
                if (hFile == -1)
                {
                    MessageBox(GetFocus(),"File Could Not be Created!","File I/O Error",MB_OK);
                    return 0;
                }

                nBufferSize = GetWindowTextLength(hWndEdit);
                if (hBuffer != NULL)
                    GlobalFree(hBuffer);
                hBuffer = GlobalAlloc(GHND, (LONG)nBufferSize+1);
                lpBuffer = GlobalLock(hBuffer);
                GetWindowText(hWndEdit,lpBuffer,nBufferSize+1);
                _lwrite(hFile,lpBuffer,nBufferSize);
                GlobalUnlock(hBuffer);
                GlobalFree(hBuffer);
                hBuffer = NULL;
                _lclose(hFile);
                DEBUG("File saved...\r\n",0)
            }
            FreeProcInstance(lpfnFileIOProc);
            break;

        case IDM_OPEN:
            lpfnFileIOProc = MakeProcInstance(FileIOProc,hInst);
            if (DialogBox(hInst,"FILEIO",hWnd,lpfnFileIOProc))
            {
                hFile = _lopen(szFileName,OF_READ);
                if (hFile == -1)
                {
                    MessageBox(GetFocus(),"File Not found!","File I/O Error",MB_OK);
                    return 0;
                }

                lFileSize = _llseek(hFile,0L,2);
                _llseek(hFile,0L,0);
                if (lFileSize < 65536)
                {
                    if (hBuffer != NULL)
                        GlobalFree(hBuffer);
                    hBuffer = GlobalAlloc(GHND,lFileSize+1);
                    lpBuffer = GlobalLock(hBuffer);
                    _lread(hFile,lpBuffer,LOWORD(lFileSize));
                    SetWindowText(hWndEdit,lpBuffer);
                    GlobalUnlock(hBuffer);
                    GlobalFree(hBuffer);
                    hBuffer = NULL;
                }
                _lclose(hFile);
            }
            FreeProcInstance(lpfnFileIOProc);
            break;

%=7~B
        case IDM_TEXTOUT1:
            DEBUG("TextOut1\r\n",0)
%=8~B
            TextOut(hDC,0,0,"TextOut #1",10);
%=7~B
            break;

        case IDM_TEXTOUT2:
            DEBUG("TextOut2\r\n",0)
%=8~B
            SetTextColor(hDC,RGB(0xFF,0x00,0x00));
            SetBkColor(hDC,RGB(0x00,0xFF,0x00));
%=8
            TextOut(hDC,10,20,"TextOut #2",10);
%=9
            TextOut(hDC,0,0,"TextOut #2",10);
%=7~B
            break;

        case IDM_TEXTOUT3:
            DEBUG("TextOut3\r\n",0)
%=8~B
            SetTextColor(hDC,RGB(0xFF,0x00,0xFF));
            SetBkColor(hDC,RGB(0x00,0xFF,0xFF));
            hFont = GetStockObject(SYSTEM_FIXED_FONT);
            SelectObject(hDC,hFont);
%=9~B
            SetTextAlign(hDC,TA_CENTER|TA_BOTTOM);
%=8
            TextOut(hDC,40,40,"TextOut #3",10);
%=9
            TextOut(hDC,0,0,"TextOut #3",10);
%=7~B
            break;

        case IDM_MODAL:
            DEBUG("Modal\r\n",0)
%=AB
            hFile = _lopen("base.def",OF_READ);
            if (hFile != -1)
            {
                lFileSize = _llseek(hFile,0L,2);
                _llseek(hFile,0L,0);
                if (lFileSize < 65536)
                {
                    if (hBuffer != NULL)
                        GlobalFree(hBuffer);
                    hBuffer = GlobalAlloc(GMEM_MOVEABLE|GMEM_ZEROINIT,lFileSize);
                    lpBuffer = GlobalLock(hBuffer);
                    _lread(hFile,lpBuffer,LOWORD(lFileSize));
%=B
                    nLineCtr = 0;
                    while (nStrLen = FindChr(lpBuffer,'\r'))
                    {
                        lpBuffer += nStrLen;
                        nLineCtr++;
                    }
                    nLineCtr++;
                    SetScrollRange(hWnd,SB_VERT,0,nLineCtr,TRUE);
%=AB
                    GlobalUnlock(hBuffer);
                    InvalidateRect(hWnd,NULL,TRUE);
                }
                _lclose(hFile);
            }
%=7~B
            break;

        case IDM_MODELESS:
            DEBUG("Modeless\r\n",0)
            break;
%+D
        case IDM_EXIT:
            DEBUG("Exit\r\n",0)
            PostMessage(hWnd,WM_CLOSE,0,0L);
            break;
%=7~BD
        }
%=8~B
        ReleaseDC(hWnd,hDC);
%=7~BD
        break;

%=9~B
    case WM_SIZE:
        nWidth = LOWORD(lParam);
        nHeight = HIWORD(lParam);
        break;

%=9~B
    case WM_PAINT:
        BeginPaint(hWnd,&ps);
%=AB
        if (hBuffer != NULL)
        {
            nY = 0;
            GetTextMetrics(ps.hdc,&tm);
            nLineHeight = tm.tmHeight + tm.tmExternalLeading;
            lpBuffer = GlobalLock(hBuffer);
            if (lpBuffer != NULL)
            {
%=B
                for (i=0; i < nLinePtr; i++)
                {
                    lpBuffer += FindChr(lpBuffer,'\r');
                    if (*lpBuffer == '\n')
                        lpBuffer++;
                }

%=AB
                while (nStrLen = FindChr(lpBuffer,'\r'))
                {
                    TextOut(ps.hdc,0,nY,lpBuffer,nStrLen-1);
                    nY += nLineHeight;
                    lpBuffer += nStrLen;
                    if (*lpBuffer == '\n')
                        lpBuffer++;
                }
                TextOut(ps.hdc,0,nY,lpBuffer,lstrlen(lpBuffer));
            }
            GlobalUnlock(hBuffer);
        }
%=9
        MoveTo(ps.hdc,nWidth/2,0);
        LineTo(ps.hdc,nWidth/2,nHeight);
        MoveTo(ps.hdc,0,nHeight/2);
        LineTo(ps.hdc,nWidth,nHeight/2);
%=9~B
        EndPaint(hWnd,&ps);
        break;

%=B
    case WM_VSCROLL:
        switch(wParam)
        {
        case SB_LINEUP:
            if (nLinePtr > 0)
            {
                nLinePtr--;
                InvalidateRect(hWnd,NULL,TRUE);
            }
            break;

        case SB_LINEDOWN:
            if (nLinePtr < nLineCtr)
            {
                nLinePtr++;
                InvalidateRect(hWnd,NULL,TRUE);
            }
            break;
        }
        SetScrollPos(hWnd,SB_VERT,nLinePtr,TRUE);
        UpdateWindow(hWnd);
        break;
%=2>
    default:
        return DefWindowProc(hWnd, wMsgID, wParam, lParam);
    }
    return 0;
}

%=D
//*------------------------------------------------------------------------
//| FileIOProc
//|     Parameters:
//|         hWnd    - Handle to Window which message is delivered to.
//|         msgID   - ID number of message
//|         wParam  - 16-bit parameter
//|         lParam  - 32-bit parameter
//|
//*------------------------------------------------------------------------
BOOL FAR PASCAL FileIOProc (HWND     hWnd,
                            unsigned wMsgID,
                            WORD     wParam,
                            LONG     lParam)
{

    switch(wMsgID)
    {
    case WM_INITDIALOG:
        return TRUE;

    case WM_COMMAND:
        switch (wParam)
        {
        case IDOK:
            GetDlgItemText(hWnd,IDC_FILENAME,szFileName,80);
            EndDialog(hWnd,TRUE);
            return TRUE;

        case IDCANCEL:
            EndDialog(hWnd,FALSE);
            return TRUE;
        }
        break;
    }
    return FALSE;
}
