//**************************************************************************
//
//  Title: CREATOR.C
//
//  Purpose:
//      To allow a student to quickly create and examine windows of
//      types, and with different style bits selected.
//
//**************************************************************************
#define DEBUGGING
//#define DEBUGMSGS
#define _WINDOWS
#include <WINDOWS.H>
#include "CREATOR.H"
#include <STDIO.H>
#ifdef DEBUGMSGS
#include <GENLIB.H>
#endif

//*------------------------------------------------------------------------
//| Global Variables
//*------------------------------------------------------------------------
HANDLE  hInst;
HANDLE  hAccels;

HWND    hWndDesktop;
HWND    hWndOverlapped;
HWND    hWndPopup;
HWND    hWndChild1,hWndChild2;

FARPROC lpfnCreatorProc1;
FARPROC lpfnCreatorProc2;
FARPROC lpfnCreatorProc3;

LONG    lDecorations[MAXDECORATIONS] = {WS_CAPTION,WS_HSCROLL,WS_VSCROLL,
                                        WS_MINIMIZEBOX,WS_MAXIMIZEBOX,
                                        WS_SYSMENU};

LONG    lFrames[4] = {WS_BORDER,WS_THICKFRAME,WS_DLGFRAME,0};

int     nScreenHeight,nScreenWidth;
int     nClientHeight,nClientWidth;

int     nCurBorder = IDC_THINFRAME;
LONG    lCurIState = 0L;
int     nCurDecorations[MAXDECORATIONS] = {0,0,0,0,0,0};
BOOL    bParent,bClipSibs,bClipKids;


//*------------------------------------------------------------------------
//| WinMain:
//|     Parameters:
//|         hInstance     - Handle to current Data Segment
//|         hPrevInstance - Handle to previous Data Segment (NULL if none)
//|         lpszCmdLine   - Long pointer to command line info
//|         CmdShow       - Integer value specifying how to start app.,
//|                            (Iconic or Normal)
//*------------------------------------------------------------------------
int PASCAL WinMain (HANDLE hInstance,
                    HANDLE hPrevInstance,
                    LPSTR  lpszCmdLine,
                    int    CmdShow)
{
int nReturn;

    if (Init(hInstance, hPrevInstance,lpszCmdLine,CmdShow))
    {
        nReturn = DoMain(hInstance);
        CleanUp();
    }
    return nReturn;
}

//*------------------------------------------------------------------------
//| Init
//|     Initialization for the program is done here:
//|     1)  Register the window class (if this is the first instance)
//|     2)  Create the desktop window for the app.
//|     3)  Show the desktop window in the manner requested by the User.
//|
//*------------------------------------------------------------------------
BOOL Init(HANDLE hInstance,   HANDLE hPrevInstance,
          LPSTR  lpszCmdLine, int    nCmdShow)
{
WNDCLASS    rClass;

    DEBUG("\n\r----  Application Initiated  ----\n\r",0)

    hInst = hInstance;

    if (!hPrevInstance)
    {
        /*  Register Class for Creator Desktop Window  */
        rClass.lpszClassName = "MSU:CREATOR:DESKTOP";
        rClass.hInstance     = hInst;
        rClass.lpfnWndProc   = CreatorDesktopProc;
        rClass.hCursor       = LoadCursor(NULL,IDC_ARROW);
        rClass.hIcon         = LoadIcon(hInstance,"CREATORICON");
        rClass.lpszMenuName  = "CREATORMENU";
        rClass.hbrBackground = COLOR_WINDOW+1;
        rClass.style         = 0L;
        rClass.cbClsExtra    = 0;
        rClass.cbWndExtra    = 0;

        if (!RegisterClass( &rClass))
            return FALSE;

        /*  Register Class for First Overlapped Window  */
        rClass.lpszClassName = "MSU:CREATOR:OVERLAPPED";
        rClass.lpfnWndProc   = GenericWindowProc;
        rClass.hIcon         = LoadIcon(hInstance,"OVERLAPPEDICON");
        rClass.hbrBackground = GetStockObject(WHITE_BRUSH);
        rClass.lpszMenuName  = NULL;

        if (!RegisterClass( &rClass))
            return FALSE;

        rClass.lpszClassName = "MSU:CREATOR:POPUP";
        rClass.hIcon         = LoadIcon(hInstance,"POPUPICON");
        rClass.hbrBackground = GetStockObject(LTGRAY_BRUSH);

        if (!RegisterClass( &rClass))
            return FALSE;

        rClass.lpszClassName = "MSU:CREATOR:CHILD1";
        rClass.hIcon         = LoadIcon(hInstance,"CHILD1ICON");
        rClass.hbrBackground = GetStockObject(GRAY_BRUSH);

        if (!RegisterClass( &rClass))
            return FALSE;

        rClass.lpszClassName = "MSU:CREATOR:CHILD2";
        rClass.hIcon         = LoadIcon(hInstance,"CHILD2ICON");
        rClass.hbrBackground = GetStockObject(DKGRAY_BRUSH);

        if (!RegisterClass( &rClass))
            return FALSE;
    }

    nScreenWidth  = GetSystemMetrics(SM_CXSCREEN);
    nScreenHeight = GetSystemMetrics(SM_CYSCREEN);

    hWndDesktop = CreateWindow("MSU:CREATOR:DESKTOP",
            "The Window Generator",
            WS_CLIPCHILDREN |
            WS_OVERLAPPEDWINDOW,
            GetProfileInt("CREATOR","X",nScreenWidth/4 ),
            GetProfileInt("CREATOR","Y",nScreenHeight/4),
            GetProfileInt("CREATOR","CX",nScreenWidth/2 ),
            GetProfileInt("CREATOR","CY",nScreenHeight/2),
            NULL,
            NULL,
            hInstance,
            NULL);

    ShowWindow(hWndDesktop,nCmdShow);

    hAccels = LoadAccelerators(hInstance,"CREATORACCELS");

    lpfnCreatorProc1 = MakeProcInstance(CreatorProc1,hInst);
    lpfnCreatorProc2 = MakeProcInstance(CreatorProc2,hInst);
    lpfnCreatorProc3 = MakeProcInstance(CreatorProc3,hInst);

    return hWndDesktop;
}

//*------------------------------------------------------------------------
//| DoMain:
//|     This is the main loop for the application:
//*------------------------------------------------------------------------
int  DoMain(HANDLE hInstance)
{
MSG     msg;
BOOL    bResult;

    while (GetMessage(&msg,NULL,0,0))
    {
        bResult = TranslateAccelerator(hWndDesktop,hAccels,&msg);
        if (!bResult)
        {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }
    }
    return (msg.wParam);
}

//*------------------------------------------------------------------------
//| CleanUp:
//|     Any last-minute application cleanup activities are done here:
//*------------------------------------------------------------------------
void CleanUp(void)
{
    FreeProcInstance(lpfnCreatorProc1);
    FreeProcInstance(lpfnCreatorProc2);
    FreeProcInstance(lpfnCreatorProc3);
    DEBUG("--- Application Terminated ---\n\r",0)
}

//*------------------------------------------------------------------------
//| CreatorDesktopProc:
//|     Parameters:
//|         hWnd    - Handle to Window which message is delivered to.
//|         msgID   - ID number of message
//|         wParam  - 16-bit parameter
//|         lParam  - 32-bit parameter
//|
//*------------------------------------------------------------------------
long FAR PASCAL CreatorDesktopProc (HWND     hWnd,
                                    unsigned uMsgID,
                                    WORD     wParam,
                                    LONG     lParam)
{
HWND    hParent;
char    szMsgBuffer[40];
LONG    lWindowStyle;
int     i;
char    szTemp[10];
RECT    rect;

    #ifdef DEBUGMSGS
        wsprintf(szDebugBuffer,"DT: %s | %04X | %08lX\n\r",
                 MessageName(szMsgBuffer,uMsgID),wParam,lParam);
        OutputDebugString(szDebugBuffer);
    #endif

    switch (uMsgID)
    {
    case WM_CREATE:
        break;

    case WM_SIZE:
        nClientWidth = LOWORD(lParam);
        nClientHeight = HIWORD(lParam);
        break;

    case WM_DESTROY:
        if (!IsIconic(hWnd))
        {
            GetWindowRect(hWnd,&rect);
            wsprintf(szTemp,"%d",rect.left);
            WriteProfileString("CREATOR","X",szTemp);
            wsprintf(szTemp,"%d",rect.top);
            WriteProfileString("CREATOR","Y",szTemp);
            wsprintf(szTemp,"%d",rect.right-rect.left);
            WriteProfileString("CREATOR","CX",szTemp);
            wsprintf(szTemp,"%d",rect.bottom - rect.top);
            WriteProfileString("CREATOR","CY",szTemp);
        }
        PostQuitMessage(0);
        break;

    case WM_COMMAND:
        switch (wParam)
        {
        case IDM_OVERLAPPED:
            if (DialogBox(hInst,"OVERLAPPED",hWnd,lpfnCreatorProc1))
            {
                lWindowStyle = WS_OVERLAPPED;

                for (i=0; i < MAXDECORATIONS; i++)
                    if (nCurDecorations[i])
                        lWindowStyle = lWindowStyle | lDecorations[i];

                lWindowStyle |= lCurIState;
                lWindowStyle |= lFrames[nCurBorder-IDC_THINFRAME];
                DEBUG("lWindowStyle = %08lx\n\r",lWindowStyle)

                if (hWndOverlapped)
                    DestroyWindow(hWndOverlapped);

                hWndOverlapped = CreateWindow("MSU:CREATOR:OVERLAPPED",
                                      "Overlapped",
                                      lWindowStyle,
                                      CW_USEDEFAULT,
                                      CW_USEDEFAULT,
                                      nScreenWidth/3,
                                      nScreenHeight/3,
                                      NULL,NULL,hInst,NULL);

                DEBUG("hWndOverlapped = %04x\n\r",hWndOverlapped);
            }
            break;

        case IDM_POPUP:
            if (DialogBox(hInst,"POPUP",hWnd,lpfnCreatorProc2))
            {
                lWindowStyle = WS_POPUP;

                for (i=0; i < MAXDECORATIONS; i++)
                    if (nCurDecorations[i])
                        lWindowStyle = lWindowStyle | lDecorations[i];

                lWindowStyle |= lCurIState;
                lWindowStyle |= lFrames[nCurBorder-IDC_THINFRAME];
                DEBUG("lWindowStyle = %08lx\n\r",lWindowStyle)

                if (hWndPopup)
                    DestroyWindow(hWndPopup);

                if (bParent)
                    hParent = hWndDesktop;
                else
                    hParent = NULL;

                if (bClipKids)
                    lWindowStyle |= WS_CLIPCHILDREN;

                hWndPopup = CreateWindow("MSU:CREATOR:POPUP",
                                      "Popup",
                                      lWindowStyle,
                                      nScreenWidth/6,
                                      nScreenHeight/6,
                                      nScreenWidth/3,
                                      nScreenHeight/3,
                                      hParent,NULL,hInst,NULL);

                DEBUG("hWndPopup = %04x\n\r",hWndPopup);
            }
            break;

        case IDM_CHILD1:
            if (DialogBox(hInst,"CHILD",hWnd,lpfnCreatorProc3))
            {
                lWindowStyle = WS_CHILD;

                for (i=0; i < MAXDECORATIONS; i++)
                    if (nCurDecorations[i])
                        lWindowStyle = lWindowStyle | lDecorations[i];

                lWindowStyle |= lCurIState;
                lWindowStyle |= lFrames[nCurBorder-IDC_THINFRAME];

                if (bClipSibs)
                    lWindowStyle |= WS_CLIPSIBLINGS;

                DEBUG("lWindowStyle = %08lx\n\r",lWindowStyle)

                if (hWndChild1)
                    DestroyWindow(hWndChild1);

                hWndChild1 = CreateWindow("MSU:CREATOR:CHILD1",
                                      "Child #1",
                                      lWindowStyle,
                                      nClientWidth/6,
                                      nClientHeight/6,
                                      nClientWidth/3,
                                      nClientHeight/3,
                                      hWndDesktop,NULL,hInst,NULL);

                DEBUG("hWndChild1 = %04x\n\r",hWndChild1);
            }
            break;

        case IDM_CHILD2:
            if (DialogBox(hInst,"CHILD",hWnd,lpfnCreatorProc3))
            {
                lWindowStyle = WS_CHILD;

                for (i=0; i < MAXDECORATIONS; i++)
                    if (nCurDecorations[i])
                        lWindowStyle = lWindowStyle | lDecorations[i];

                lWindowStyle |= lCurIState;
                lWindowStyle |= lFrames[nCurBorder-IDC_THINFRAME];

                if (bClipSibs)
                    lWindowStyle |= WS_CLIPSIBLINGS;

                DEBUG("lWindowStyle = %08lx\n\r",lWindowStyle)

                if (hWndChild2)
                    DestroyWindow(hWndChild2);

                hWndChild2 = CreateWindow("MSU:CREATOR:CHILD2",
                                      "Child #2",
                                      lWindowStyle,
                                      nClientWidth/3,
                                      nClientHeight/3,
                                      nClientWidth/3,
                                      nClientHeight/3,
                                      hWndDesktop,NULL,hInst,NULL);

                DEBUG("hWndChild2 = %04x\n\r",hWndChild2);
            }
            break;

        }
        break;

    default:
        return(DefWindowProc(hWnd, uMsgID, wParam, lParam));
    }
    return(0);
}

//*------------------------------------------------------------------------
//| ProcessCmdMsg
//|     Parameters:
//|         hWnd    - Handle to Window which message is delivered to.
//|         wIDCtl  - ID value of control
//|
//*------------------------------------------------------------------------
void ProcessCmdMsg1(HWND hWnd, WORD wIDCtl)
{
int i;

    switch (wIDCtl)
    {
    case IDOK:
        for (i=0; i<MAXDECORATIONS; i++)
            nCurDecorations[i] = IsDlgButtonChecked(hWnd,i+IDC_CAPTION);
        lCurIState = 0;
        if (IsDlgButtonChecked(hWnd,IDC_VISIBLE))
            lCurIState = WS_VISIBLE;
        if (IsDlgButtonChecked(hWnd,IDC_MINIMIZE))
            lCurIState |= WS_MINIMIZE;
        if (IsDlgButtonChecked(hWnd,IDC_MAXIMIZE))
            lCurIState |= WS_MAXIMIZE;

        for (i=0; i<4; i++)
            if (IsDlgButtonChecked(hWnd,IDC_THINFRAME+i))
                nCurBorder = IDC_THINFRAME+i;

        bParent = IsDlgButtonChecked(hWnd,IDC_PARENT);
        bClipSibs = IsDlgButtonChecked(hWnd,IDC_CLIPSIBLINGS);
        bClipKids = IsDlgButtonChecked(hWnd,IDC_CLIPCHILDREN);

        EndDialog(hWnd,TRUE);
        break;

    case IDCANCEL:
        EndDialog(hWnd,FALSE);
        break;

    case IDC_MAXIMIZE:
        CheckDlgButton(hWnd,IDC_MINIMIZE,0);
        break;

    case IDC_MINIMIZE:
        CheckDlgButton(hWnd,IDC_MAXIMIZE,0);
        break;
    }
}

//*------------------------------------------------------------------------
//| CreatorProc1: Dialog Window Proc for Overlapped cases...
//|     Parameters:
//|         hWnd    - Handle to Window which message is delivered to.
//|         msgID   - ID number of message
//|         wParam  - 16-bit parameter
//|         lParam  - 32-bit parameter
//|
//*------------------------------------------------------------------------
BOOL FAR PASCAL CreatorProc1 (HWND     hWnd,
                              unsigned uMsgID,
                              WORD     wParam,
                              LONG     lParam)
{
char    szMsgBuffer[40];
int     i;

    #ifdef DEBUGMSGS
        wsprintf(szDebugBuffer,"D1: %s | %04X | %08lX\n\r",
                 MessageName(szMsgBuffer,uMsgID),wParam,lParam);
        OutputDebugString(szDebugBuffer);
    #endif

    switch (uMsgID)
    {
    case WM_INITDIALOG:
        /*  Establish prior values...  */
        CheckDlgButton(hWnd,nCurBorder,TRUE);
        CheckDlgButton(hWnd,IDC_CLIPCHILDREN,bClipKids);

        nCurDecorations[0] = TRUE;
        for (i=0; i < MAXDECORATIONS; i++)
           CheckDlgButton(hWnd,i+IDC_CAPTION,nCurDecorations[i]);

        if (lCurIState & WS_VISIBLE)
            CheckDlgButton(hWnd,IDC_VISIBLE,TRUE);
        if (lCurIState & WS_MINIMIZE)
            CheckDlgButton(hWnd,IDC_MINIMIZE,TRUE);
        if (lCurIState & WS_MAXIMIZE)
            CheckDlgButton(hWnd,IDC_MAXIMIZE,TRUE);

        SetFocus(GetDlgItem(hWnd,IDOK));
        return FALSE;

    case WM_COMMAND:
        ProcessCmdMsg1(hWnd,wParam);
        return TRUE;
    }
    return FALSE;
}

//*------------------------------------------------------------------------
//| CreatorProc2: Dialog Window Proc for POPUP cases...
//|     Parameters:
//|         hWnd    - Handle to Window which message is delivered to.
//|         msgID   - ID number of message
//|         wParam  - 16-bit parameter
//|         lParam  - 32-bit parameter
//|
//*------------------------------------------------------------------------
BOOL FAR PASCAL CreatorProc2 (HWND     hWnd,
                              unsigned uMsgID,
                              WORD     wParam,
                              LONG     lParam)
{
char    szMsgBuffer[40];
int     i;

    #ifdef DEBUGMSGS
        wsprintf(szDebugBuffer,"D1: %s | %04X | %08lX\n\r",
                 MessageName(szMsgBuffer,uMsgID),wParam,lParam);
        OutputDebugString(szDebugBuffer);
    #endif

    switch (uMsgID)
    {
    case WM_INITDIALOG:
        /*  Establish prior values...  */
        CheckDlgButton(hWnd,IDC_PARENT,bParent);
        CheckDlgButton(hWnd,IDC_CLIPCHILDREN,bClipKids);
        CheckDlgButton(hWnd,nCurBorder,TRUE);

        for (i=0; i < MAXDECORATIONS; i++)
           CheckDlgButton(hWnd,i+IDC_CAPTION,nCurDecorations[i]);

        if (lCurIState & WS_VISIBLE)
            CheckDlgButton(hWnd,IDC_VISIBLE,TRUE);
        if (lCurIState & WS_MINIMIZE)
            CheckDlgButton(hWnd,IDC_MINIMIZE,TRUE);
        if (lCurIState & WS_MAXIMIZE)
            CheckDlgButton(hWnd,IDC_MAXIMIZE,TRUE);

        SetFocus(GetDlgItem(hWnd,IDOK));
        return FALSE;

    case WM_COMMAND:
        ProcessCmdMsg1(hWnd,wParam);
        return TRUE;
    }
    return FALSE;
}

//*------------------------------------------------------------------------
//| CreatorProc3: Dialog Window Proc for Child cases...
//|     Parameters:
//|         hWnd    - Handle to Window which message is delivered to.
//|         msgID   - ID number of message
//|         wParam  - 16-bit parameter
//|         lParam  - 32-bit parameter
//|
//*------------------------------------------------------------------------
BOOL FAR PASCAL CreatorProc3 (HWND     hWnd,
                              unsigned uMsgID,
                              WORD     wParam,
                              LONG     lParam)
{
char    szMsgBuffer[40];
int     i;

    #ifdef DEBUGMSGS
        wsprintf(szDebugBuffer,"D1: %s | %04X | %08lX\n\r",
                 MessageName(szMsgBuffer,uMsgID),wParam,lParam);
        OutputDebugString(szDebugBuffer);
    #endif

    switch (uMsgID)
    {
    case WM_INITDIALOG:
        /*  Establish prior values...  */
        CheckDlgButton(hWnd,nCurBorder,TRUE);
        CheckDlgButton(hWnd,IDC_CLIPSIBLINGS,bClipSibs);

        for (i=0; i < MAXDECORATIONS; i++)
           CheckDlgButton(hWnd,i+IDC_CAPTION,nCurDecorations[i]);

        if (lCurIState & WS_VISIBLE)
            CheckDlgButton(hWnd,IDC_VISIBLE,TRUE);
        if (lCurIState & WS_MINIMIZE)
            CheckDlgButton(hWnd,IDC_MINIMIZE,TRUE);
        if (lCurIState & WS_MAXIMIZE)
            CheckDlgButton(hWnd,IDC_MAXIMIZE,TRUE);

        SetFocus(GetDlgItem(hWnd,IDOK));
        return FALSE;

    case WM_COMMAND:
        ProcessCmdMsg1(hWnd,wParam);
        return TRUE;
    }
    return FALSE;
}

//*------------------------------------------------------------------------
//| GenericWindowProc: This is used by all of the demo windows...
//|
//|     Parameters:
//|         hWnd    - Handle to Window which message is delivered to.
//|         msgID   - ID number of message
//|         wParam  - 16-bit parameter
//|         lParam  - 32-bit parameter
//|
//*------------------------------------------------------------------------
long FAR PASCAL GenericWindowProc (HWND     hWnd,
                                   unsigned uMsgID,
                                   WORD     wParam,
                                   LONG     lParam)
{
    #ifdef DEBUGMSGS
        wsprintf(szDebugBuffer,"%s | %04X | %08lX\n\r",
                 MessageName(szMsgBuffer,uMsgID),wParam,lParam);
        OutputDebugString(szDebugBuffer);
    #endif

    switch (uMsgID)
    {
    case WM_DESTROY:

	if (hWndOverlapped == hWnd) hWndOverlapped = 0;
	else if (hWndPopup == hWnd) hWndPopup = 0;
        else if (hWndChild1 == hWnd) hWndChild1 = 0;
        else if (hWndChild2 == hWnd) hWndChild2 = 0;

	break;
    default:
        return(DefWindowProc(hWnd, uMsgID, wParam, lParam));
    }
    return(0);
}
