	page	60,132
        title   WinAuxDrv - Windows AUX driver
        .286p
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

; This device directs AUX output to a buffer which is then read by Windows.
; At boot time, it saves the vectors for INT 9 and INT 16h, and when AUX input
; is requested temporarily restores them.  So, it can be used for AUX input
; and output from inside Windows.

; You should still use the /M option with SymDeb rather than /"=AUX", because
; SymDeb has a bug where it puts out memory allocation messages to CON even
; though you said /"=AUX".

; In case you're wondering why the screen output code is so simple (i.e. there
; is no "current row" variable), it always outputs to the last row of the
; screen, instead of starting at the top.  Don't laugh, it works fine and made
; it easier to code this pup.

; This driver is in the public domain.
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

; request header entries

cmdCode 	equ	2
status		equ	3

ndInputChar	equ	13

brkOff		equ	14
brkSeg		equ	brkOff+2

xferOff 	equ	14
xferSeg 	equ	xferOff+2

xferCount	equ	18

MyCmdCode       equ     0
BufferSeg       equ     1

; constants

BS		equ	08h
TAB		equ	09h
LF		equ	0Ah
CR		equ	0Dh

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

Zseg	    segment at 0

	    org     9*4
KbdInt	    label   dword
KbdIntOff   dw	    ?
KbdIntSeg   dw	    ?

	    org     16h*4
KbdBios     label   dword
KbdBiosOff  dw	    ?
KbdBiosSeg  dw	    ?

Zseg	    endS

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

Cseg	segment para public 'code'

		assume	cs:Cseg, ds:nothing, es:nothing
begin:

; device driver header

nextDev 	dd	-1
attribute       dw      1100100000000000b
strategy	dw	devStrategy
interrupt	dw	devInt
devName 	db	'AUX     '

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

rhAddr		label	dword
rhOff		dw	?
rhSeg		dw	?

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

funTab		label	word
		dw	init
		dw	mediaCheck
		dw	buildBpb
                dw      ioCtlRead
		dw	input
		dw	ndInput
		dw	inStat
		dw	inFlush
		dw	output
		dw	outVerify
		dw	outStat
		dw	outFlush
                dw      ioCtlWrite
		dw	open
		dw	close

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

scrMinOff       dw      160*24
scrMaxOff       dw      160*25

scrCurOff       dw      160*24
scrCurSeg       dw      0B000h

nCtr1           dw      1               ; outChar incr value
nCtr2           dw      160             ; outLF start position
nCtr3           dw      24*80           ; # of WORDS to move in buffer
nCtr4           dw      80              ; # of WORDS to blank on last line
nCtr5           dw      2               ; outBS Amt to decrement DI
nBlank          dw      0720h           ; Value to blank line with


WinInfo         label   word
ScrBufStart     dw      0               ; starting offset of Screen Buffer
ScrPtr          dw      0

WinScrBuf       label   word
                db      2000 dup(" ")

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

SaveKbdInt	label	dword
SaveKbdIntOff	dw	0
SaveKbdIntSeg	dw	0

SaveKbdBios	label	dword
SaveKbdBiosOff	dw	0
SaveKbdBiosSeg	dw	0

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

devStrategy:
	mov	cs:rhSeg, es
	mov	cs:rhOff, bx
	retf

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

devInt:
	pushf
	push	ds
	push	es
	push	ax
	push	bx
	push	cx
	push	dx
	push	di
	push	si
	cld

	les	bx, cs:rhAddr
	mov	al, es:[bx].cmdCode
	shl	al, 1
	lea	di, funTab
	xor	ah, ah
	add	di, ax
	jmp	word ptr[di]

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

outVerify:
output:
	mov	cx, es:[bx].xferCount	; CX = # bytes to write
	lds	si, es:[bx].xferOff	; DS:SI --> text

        les     di, dword ptr scrCurOff

outLoop:
	lodsb

	cmp	al, CR
	ja	outChar
	je	outCR

	cmp	al, LF
	je	outLF

	cmp	al, TAB
	je	outTAB

	cmp	al, BS
	je	outBS

outChar:
        stosb
        add     di, nCtr1           ; 1=Mono output, 0=buffer output
	cmp	di, scrMaxOff
	jb	outDone

        mov     di, scrMinOff

outLF:
	push	ds
	push	es
	push	si
	push	di
	push	cx

	mov	ax, es
	mov	ds, ax


        mov     di, ScrBufStart         ; Get address of start of Buffer
        mov     si, di                  ; Calc offset of 2nd line
        add     si, nCtr2               ;
        mov     cx, nCtr3               ; Get # of words to move
	rep movsw

        mov     ax, nBlank              ; Blank bottom line
        mov     cx, nCtr4               ; # of WORDS to blank
	rep stosw

        mov     ax, ScrPtr              ; Get ptr to new data
        sub     ax, 80                  ; adjust pointer for scroll op
        jnc     PtrOk                   ; Have we gone past the start?

        mov     ax, ScrBufStart         ; Yes: Reset ptr to start of buffer

PtrOk:
        mov     ScrPtr, ax              ; Store value for later
	pop	cx
	pop	di
	pop	si
	pop	es
	pop	ds
        jmp     outDone

LoopBridge:
        jmp     outLoop

outBS:
	cmp	di, scrMinOff
	je	outDone
        sub     di,nCtr5
	jmp	outDone

outTAB:
        or      di, 0Eh
	add	di, 2
	jmp	outDone

outCR:
        mov     di, scrMinOff

outDone:
        loop    LoopBridge
        mov     scrCurOff, di

        mov     ax, word ptr scrCurOff+2
        cmp     ax,0B000h
        jne     outExit

	mov	dx, 3B4h
	shr	di, 1			; Set cursor position
	mov	ax, di
	mov	al, 0Eh
	out	dx, ax
	mov	ax, di
	xchg	ah, al
	mov	al, 0Fh
	out	dx, ax

outExit:
	jmp	exit

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

input:
	call	SetOldKbdInts

	mov	ah, 0
	int	16h

	les	di, es:[bx].xferOff	; ES:DI --> text
	stosb
	mov	byte ptr es:[bx].xferCount, 1

	call	SetNewKbdInts

	jmp	exit

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

ndInput:
	call	SetOldKbdInts

	mov	ah, 1
	int	16h
	jz	ndInputNone

	mov	es:[bx].ndInputChar, al

	call	SetNewKbdInts

	jmp	exit

ndInputNone:
	call	SetNewKbdInts

	les	bx, rhAddr
	or	word ptr es:status[bx], 0300h	; set busy flag

	jmp	exit1

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

inStat:
	call	SetOldKbdInts

	mov	ah, 1
	int	16h
	jz	ndInputNone

	call	SetNewKbdInts

	jmp	exit

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

inFlush:
	call	SetOldKbdInts

inFlushLoop:
	mov	ah, 1
	int	16h
	jz	inFlushDone

	mov	ah, 0
	int	16h
	jmp	inFlushLoop

inFlushDone:
	call	SetNewKbdInts

	jmp	exit

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

open:
        mov     ax, word ptr scrCurOff+2
        cmp     ax,0B000h
        jne     OpenExit

	mov	dx, 3B4h		; Set standard monochrome cursor
	mov	ax, 0B0Ah
	out	dx, ax
	mov	ax, 0C0Bh
        out     dx, ax

OpenExit:
        jmp     exit

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
ioCtlWrite:
        les     bx, es:[bx].xferOff
        mov     al, byte ptr es:[bx].MyCmdCode
        cmp     al,0
        je      EndWinApp

BeginWinApp:
        ;mov     ax, offset WinScrBuf+80*24
        mov     word ptr scrCurOff, offset WinScrBuf+80*24
        mov     word ptr scrCurSeg,cs

        mov     word ptr nCtr1,0
        mov     word ptr nCtr2,80
        mov     word ptr nCtr3,24*40
        mov     word ptr nCtr4,40
        mov     word ptr nCtr5,1
        mov     word ptr scrMinOff, offset WinScrBuf+80*24
        mov     word ptr scrMaxOff, offset WinScrBuf+80*25
        mov     ax,2020h
        mov     word ptr nBlank,ax

        mov     di, offset WinScrBuf        ; blank out the buffer
        mov     ScrPtr,di                   ; save for ioctlRead operation
        mov     ScrBufStart,di              ; and for later work here
        push    cs
        pop     es
        mov     cx,1000
        rep     stosw
        jmp     exit

EndWinApp:
        mov     word ptr scrCurOff,160*24
        mov     word ptr scrCurSeg,0B000h
        mov     word ptr ScrBufStart,0
        mov     word ptr ScrPtr,0
        mov     word ptr nCtr1,1
        mov     word ptr nCtr2,160
        mov     word ptr nCtr3,24*80
        mov     word ptr nCtr4,80
        mov     word ptr nCtr5,2
        mov     word ptr scrMinOff,160*24
        mov     word ptr scrMaxOff,160*25
        mov     word ptr nBlank,0720h
        jmp     exit

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

mediaCheck:
buildBpb:
outStat:
outFlush:
close:

exit:
	les	bx, rhAddr
	or	word ptr es:status[bx], 0100h
exit1:
	pop	si
	pop	di
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	pop	es
	pop	ds
	popf
	retf

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

SetOldKbdInts:

	push	es
	push	ax
	xor	ax, ax
	mov	es, ax
	assume	es:Zseg

	CLI

	mov	ax, SaveKbdIntOff
	xchg	ax, KbdIntOff
	mov	SaveKbdIntOff, ax

	mov	ax, SaveKbdIntSeg
	xchg	ax, KbdIntSeg
	mov	SaveKbdIntSeg, ax

	mov	ax, SaveKbdBiosOff
	xchg	ax, KbdBiosOff
	mov	SaveKbdBiosOff, ax

	mov	ax, SaveKbdBiosSeg
	xchg	ax, KbdBiosSeg
	mov	SaveKbdBiosSeg, ax

	STI

	pop	ax
	pop	es
	assume	es:nothing

	ret

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

SetNewKbdInts:

	push	es
	push	ax
	xor	ax, ax
	mov	es, ax
	assume	es:Zseg

	CLI

	mov	ax, SaveKbdIntOff
	mov	KbdIntOff, ax

	mov	ax, SaveKbdIntSeg
	mov	KbdIntSeg, ax

	mov	ax, SaveKbdBiosOff
	mov	KbdBiosOff, ax

	mov	ax, SaveKbdBiosSeg
	mov	KbdBiosSeg, ax

	STI

	pop	ax
	pop	es
	assume	es:nothing

        ret

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

ioCtlRead:

        int     3
        mov     si, offset WinInfo
        mov     cx, es:[bx].xferCount   ; CX --> # of bytes to transfer
        shr     cx,1                    ; convert to # of words to xfer
        mov     dx,cx                   ; save for exit check
        les     di, es:[bx].xferOff     ; ES:DI --> Transfer Buffer
        push    cs                      ; DS:SI --> My buffer
        pop     ds
        rep     movsw

        cmp     dx,2                    ; Did we deliver just 2 words?
        jne     ReadExit                ; No: then skip resetting ptr

        mov     ax,scrCurOff            ; get current offset in buffer
        mov     ScrPtr,ax               ; store it in for later retrieval

ReadExit:
        jmp     exit

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

init:	; everything from here on is discarded

	push	es
	xor	ax, ax
	mov	es, ax
	assume	es:Zseg

	mov	ax, KbdIntOff
	mov	SaveKbdIntOff, ax
	mov	ax, KbdIntSeg
	mov	SaveKbdIntSeg, ax

	mov	ax, KbdBiosOff
	mov	SaveKbdBiosOff, ax
	mov	ax, KbdBiosSeg
	mov	SaveKbdBiosSeg, ax

	pop	es
	assume	es:nothing

	mov	es:brkSeg[bx], cs
	mov	es:word ptr brkOff[bx], offset init

        mov     cx, MsgLen
        mov     si, offset StartupMsg
        push    cs
        pop     ds
        mov     bx,0
        mov     ah,14

MsgLoop:
        lodsb
        int     10h
        loop    MsgLoop

	jmp	exit

StartupMsg  label byte
        db      0Dh,0Ah
        db      'Ŀ',0Dh,0Ah
        db      '===  WinAux      ',0Dh,0Ah
        db      'Ĵ',0Dh,0Ah
        db      '   Driver has been    ',0Dh,0Ah
        db      '      installed.      ',0Dh,0Ah
        db      '',0Dh,0Ah
MsgLen  equ $-StartupMsg

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

Cseg	endS

	end	begin

