/*
	btr_stru.h

	Copyright (c) 1990, by Jeffrey K Regan
	ALL RIGHTS RESERVED.

	Revision History:
	-----------------
*/

/******************************************************/
/* Useful structure typedefs for use with BTRIEVE     */
/******************************************************/
#pragma pack (1)
typedef struct
   {
   int	rec_len;
   int	page_size;
   int	num_indices;
   long	res1;
   int	file_flags;
   int	res2;
   int	pre_allocation;
   } btr_file_specs;

typedef struct
	{
	int	key_pos;
	int	key_len;
	int	key_flags;
	long	res1;
	char	ex_key_type;
	char	null_value;
	long	res2;
	} btr_key_specs;

typedef struct
	{
	btr_file_specs	fs;
	btr_key_specs	ks [24];
	char	alt_buf [265];
	} btr_stat_struct;

typedef struct
	{
	int	version_number;
	int	revision_number;
	char	type_char;
	} ver_struct;

typedef struct
	{                 		/***************************/
	char		pb [128];		/* Position Block       	*/
	char		*db;     		/* Data Buffer Pointer  	*/
	char		*kb;     		/* Key Buffer Pointer   	*/
	int		rl;      		/* Current Record Length	*/
	int		arl;     		/* Actual Record Length 	*/
	int		kn;      		/* Current Key Number   	*/
	int		pr;				/* Last Return Code    		*/
	} btr_fcb;      			/***************************/

#pragma pack ()
/*********************/
/* End of definition */
/*********************/
