/*
	btr_ops.h

	Copyright (c) 1990, by Jeffrey K Regan
	ALL RIGHTS RESERVED.

	Revision History:
	-----------------
*/

/************************************************************/
/*       Definition of BTRIEVE operation codes        		*/
/************************************************************/
#define b_open				0     /* Open file						*/
#define b_close 			1     /* Close file						*/
#define b_insert			2     /* Insert record					*/
#define b_update			3     /* Update record					*/
#define b_delete			4     /* Delete record					*/
#define b_get_eq			5     /* Get equal						*/
#define b_get_nx			6     /* Get next							*/
#define b_get_pr			7     /* Get previous					*/
#define b_get_gt			8     /* Get greater						*/
#define b_get_ge			9     /* Get greater or equal			*/
#define b_get_lt			10    /* Get less							*/
#define b_get_le			11    /* Get less or equal    		*/
#define b_get_first		12    /* Get first record				*/
#define b_get_last		13    /* Get last record	 			*/
#define b_create			14    /* Create file	      			*/
#define b_stat				15		/* Get file status      		*/
#define b_extend			16    /* Extend file	      			*/
#define b_set_dir			17    /* Set directory	      		*/
#define b_get_dir			18    /* Get directory	      		*/
#define b_begin_tr		19    /* Begin transaction    		*/
#define b_end_tr			20    /* End transaction      		*/
#define b_abort_tr		21    /* Abort transaction    		*/
#define b_get_position	22    /* Get position	      		*/
#define b_get_direct		23    /* Get direct	     				*/
#define b_step_next		24    /* Get Next Physical Record	*/
#define b_stop				25    /* Stop		      				*/
#define b_version			26    /* Btrieve Version      		*/
#define b_unlock			27    /* Release Lock	      		*/
#define b_reset 			28    /* Reset Btrieve System 		*/
#define b_set_owner		29    /* Set Owner	      			*/
#define b_clear_owner	30    /* Clear Owner	      			*/
#define b_create_sindex 31    /* Create Supp Index    		*/
#define b_drop_sindex	32    /* Drop Supp Index      		*/
#define b_step_first		33		/* Get First Physical Record	*/
#define b_step_last		34		/* Get Last Physical Record	*/
#define b_step_prev		35		/* Get Prev Physical Record	*/
/************************************************************/

/***********/
/* Get Key */
/***********/
#define b_get_key			50

/*********/
/* Locks */
/*********/
#define b_lock_none		0
#define b_lock_wait		100
#define b_lock_nowait	200
#define b_mlock_wait		300
#define b_mlock_nowait	400

/********************/
/* Owner Parameters */
/********************/
#define b_owner_required		0
#define b_owner_not_required	1
#define b_not_encrypted			0
#define b_encrypted				2

/**************/
/* Open Modes */
/**************/
#define b_open_normal	0
#define b_open_accel		-1
#define b_open_rdonly	-2
#define b_open_verify	-3
#define b_open_excl		-4

/**************/
/* File Flags */
/**************/
#define b_VAR_LEN				1
#define b_BLANK_COMPRESS	2
#define b_PREALLOCATED		4
#define b_DATA_COMPRESS		8
#define b_KEY_ONLY			16
#define b_FREE_10_PCT		64
#define b_FREE_20_PCT		128
#define b_FREE_30_PCT		192

/*************/
/* Key Types */
/*************/
#define b_DUPLICATES	   	1
#define b_MODIFIABLE	   	2
#define b_BINARY		   	4
#define b_NULL_VALUE	   	8
#define b_SEGMENTED	   	16
#define b_ALT_SEQUENCE		32
#define b_DESCENDING	   	64
#define b_SUPPLEMENTAL		128
#define b_EXTENDED	   	256
#define b_MANUAL				512

/**********************/
/* Extended Key Types */
/**********************/
#define b_EXK_STRING			0
#define b_EXK_INTEGER		1
#define b_EXK_FLOAT			2
#define b_EXK_DATE			3
#define b_EXK_TIME			4
#define b_EXK_DECIMAL		5
#define b_EXK_MONEY			6
#define b_EXK_LOGICAL		7
#define b_EXK_NUMERIC		8
#define b_EXK_BFLOAT			9
#define b_EXK_LSTRING		10
#define b_EXK_ZSTRING		11
#define b_EXK_UBINARY		14
#define b_EXK_AUTOINC		15

/***************************************/
/* Toolbox Specific Error Return Codes */
/***************************************/
/* from read_open_file or read_open_name */
#define b_openfile_not_found		100
#define b_record_not_found			101
#define b_file_not_found			102  /* read_open_file only */

/* from btr_clone	*/
#define b_get_stat_failed			103
#define b_create_file_failed		104

/* from btr_get_direct */
#define b_get_position_failed		105
#define b_get_direct_failed		106
#define b_get_old_rec_failed		107

/*********************/
/* End of definition */
/*********************/
