/*
	btr_decl.h

	Copyright (c) 1990, by Jeffrey K Regan
	ALL RIGHTS RESERVED.

	Revision History:
	-----------------
*/

/***********************/
/* Function Prototypes */
/***********************/

int BTRV (int, char *, char *, int *, char *, int);

int read_open_file (btr_fcb *, char *, char *, char *, char *, int, int);
char *read_open_name (char *, char *);

int btr_begin_transaction (int);
int btr_end_transaction (void);
int btr_abort_transaction (void);

void init_btrieve (boolean);
void btr_reset (void);
void btr_stop (void);

char *btr_version (void);
int bt_versions (ver_struct *);

void btr_display_error (int, boolean);

int bt_set_owner (btr_fcb *, char *, int);
int bt_clear_owner (btr_fcb *);

int bt_close (btr_fcb *);
void bt_close_file (btr_fcb *);

int bt_open (btr_fcb *, char *, char *, int, int);

int bt_create_sindex (btr_fcb *, char *, int);
int bt_drop_sindex (btr_fcb *, int);

int bt_get_position (btr_fcb *, long *);
int bt_get_direct (btr_fcb *, long);

int bt_get_next (btr_fcb *, int);
int bt_get_prev (btr_fcb *, int);
int bt_get_first (btr_fcb *, int);
int bt_get_last (btr_fcb *, int);
int bt_get_gt (btr_fcb *, int);
int bt_get_ge (btr_fcb *, int);
int bt_get_lt (btr_fcb *, int);
int bt_get_le (btr_fcb *, int);
int bt_get_eq (btr_fcb *, int);

int bt_step_first (btr_fcb *, int);
int bt_step_last (btr_fcb *, int);
int bt_step_next (btr_fcb *, int);
int bt_step_prev (btr_fcb *, int);

int bt_insert (btr_fcb *);
int bt_update (btr_fcb *);
int bt_delete (btr_fcb *);

int bt_unlock (btr_fcb *);
int bt_unlock_multi (btr_fcb *, long);
int bt_unlock_all (btr_fcb *);

int bt_status (btr_fcb *, btr_stat_struct *);
int bt_clone (btr_fcb *, char *, boolean);
int bt_create (btr_fcb *, boolean);

/***************/
/*	Code Macros */
/***************/

#define btr_lock_ok(x) ((x == b_get_key) || (x == b_lock_none) || (x == b_lock_wait) || (x == b_lock_nowait) || (x == b_mlock_wait) || (x == b_mlock_nowait))

#define btr_call(x,y) BTRV(y, x.pb, x.db, &x.rl, x.kb, x.kn)
#define btr_pcall(x,y) BTRV(y, x->pb, x->db, &x->rl, x->kb, x->kn)

#define btr_versions(x) bt_versions(&x)

#define btr_get_position(x,y) bt_get_position(&x,&y)
#define btr_get_direct(x,y) bt_get_direct(&x,y)

#define btr_set_owner(x,c,i) bt_set_owner(&x,c,i)
#define btr_clear_owner(x) bt_clear_owner(&x)

#define btr_create_sindex(x,c,i) bt_create_sindex(&x,c,i)
#define btr_drop_sindex(x,i) bt_drop_sindex(&x,i)

#define btr_unlock(x) bt_unlock(&x)
#define btr_unlock_multi(x,y) bt_unlock_multi(&x,y)
#define btr_unlock_all(x) bt_unlock_all(&x)

#define btr_status(x,y) bt_status(&x,&y)
#define btr_clone(x,n,a) bt_clone(&x,n,a)
#define btr_create(x,i) bt_create(&x,i)

#define btr_open(x,c,o,m,l) bt_open(&x,c,o,m,l)

#define btr_close(x) bt_close(&x)
#define btr_close_file(x) bt_close_file(&x)

#define btr_insert(x) bt_insert(&x)
#define btr_update(x) bt_update(&x)
#define btr_delete(x) bt_delete(&x)

#define btr_get_next(x)	bt_get_next(&x,b_lock_none)
#define btr_get_prev(x)	bt_get_prev(&x,b_lock_none)
#define btr_get_first(x) bt_get_first(&x,b_lock_none)
#define btr_get_last(x)	bt_get_last(&x,b_lock_none)
#define btr_get_gt(x) bt_get_gt(&x,b_lock_none)
#define btr_get_ge(x) bt_get_ge(&x,b_lock_none)
#define btr_get_lt(x) bt_get_lt(&x,b_lock_none)
#define btr_get_le(x) bt_get_le(&x,b_lock_none)
#define btr_get_eq(x) bt_get_eq(&x,b_lock_none)

#define btr_get_next_lock(x,i) bt_get_next(&x,i)
#define btr_get_prev_lock(x,i) bt_get_prev(&x,i)
#define btr_get_first_lock(x,i) bt_get_first(&x,i)
#define btr_get_last_lock(x,i) bt_get_last(&x,i)
#define btr_get_gt_lock(x,i)	bt_get_gt(&x,i)
#define btr_get_ge_lock(x,i)	bt_get_ge(&x,i)
#define btr_get_lt_lock(x,i)	bt_get_lt(&x,i)
#define btr_get_le_lock(x,i)	bt_get_le(&x,i)
#define btr_get_eq_lock(x,i)	bt_get_eq(&x,i)

#define btr_step_first(x) bt_step_first(&x,b_lock_none)
#define btr_step_last(x) bt_step_last(&x,b_lock_none)
#define btr_step_next(x) bt_step_next(&x,b_lock_none)
#define btr_step_prev(x) bt_step_prev(&x,b_lock_none)

#define btr_step_first_lock(x,i) bt_step_first(&x,i)
#define btr_step_last_lock(x,i) bt_step_last(&x,i)
#define btr_step_next_lock(x,i) bt_step_next(&x,i)
#define btr_step_prev_lock(x,i) bt_step_prev(&x,i)

#define btr_get_data_buf(x) (x.db)
#define btr_set_data_buf(x,c,y) (x.db=c,x.arl=x.rl=y)

#define btr_get_key_buf(x) (x.kb)
#define btr_set_key_buf(x,c) (x.kb=c)

#define btr_get_record_len(x) (x.rl)
#define btr_set_record_len(x,i) (x.rl=x.arl=i)

#define btr_reset_record_len(x) (x.rl=x.arl)

#define btr_get_key_num(x) (x.kn)
#define btr_set_key_num(x,i) (x.kn=i)

#define btr_get_previous_return(x) (x.pr)
/*********************/
/* End of definition */
/*********************/

