/*******************************************************************************
**	Program Name..	Winbtrv.lib
**	Module Name...	Btrtable.h
**	Programmer....	Jeffrey K Regan
**	Creation Date.	04/06/94
********************************************************************************
**	Copyright (c) 1994, Jeffrey K Regan                                        **
*******************************************************************************/
#ifndef __BTRTABLE_H
#define __BTRTABLE_H

#include <stdlib.h>
#include <string.h>
#include <dir.h>
#include <new.h>
#include <except.h>

#include <btrenv.h>
#include <btrobj.h>
#include <btrfield.h>

struct btrFieldNode
	{
   btrField	*fld;
   btrFieldNode	*next;
   };
   
class btrTableRep
	{
friend class btrTable;
private:
	btrTableRep ();
	btrTableRep (const char *fname, const char *aname, const char *oname = "",  int mode = 0, int lock = 0);
	~btrTableRep ();
private:
	Boolean	fileopen;
	char	  *filename;
   char	  *exfile;
   char	  *owner;
   char	  *alias;
	char	  *posblk;
	int		count;
   int		numKeys;
	};

class btrTable : public btrObject
	{
public:
	btrTable () { rep = new btrTableRep (); }
	btrTable (char *company, char *filename, char *aname, int reclen, char *databuf = 0, char *keybuf = 0, int mode = bxOpenNormal, int lock = bxNone);
	btrTable (char *filename, char *aliasname, int reclen, char *databuf = 0, char *keybuf = 0, char *ownername = "", int mode = bxOpenNormal, int lock = bxNone);
	btrTable (const btrTable &s, int reclen, char *databuf = 0, char *keybuf = 0, int key = 0);
	~btrTable ();
   
   int operator == (const btrTable &s);
   
	retCode Open (char *company, char *filename, char *aname, int reclen, char *databuf = 0, char *keybuf = 0, int mode = bxOpenNormal, int lock = bxNone);
	retCode Open (char *filename, char *aliasname, int reclen, char *databuf = 0, char *keybuf = 0, char *ownername = "", int mode = bxOpenNormal, int lock = bxNone);
	void Close ();
      
	btrField *addField (char *sname, char *lname, char *loc, void *dst, btrFieldType tp, int len = 0, int dec = 0);
   void closeFields ();
   btrField *findField (char *sname);
   void readFields ();
   void writeFields ();
   void clearFields ();
   Boolean isChanged ();
   
   retCode getFirst (int Lock = bxNone) { return doOperation (bGetFirst, Lock); }
   retCode getLast (int Lock = bxNone) { return doOperation (bGetLast, Lock); }
   retCode getNext (int Lock = bxNone) { return doOperation (bGetNext, Lock); }
   retCode getPrevious (int Lock = bxNone) { return doOperation (bGetPrevious, Lock); }

   retCode getEqual (int Lock = bxNone) { return doOperation (bGetEqual, Lock); }
   retCode getLT (int Lock = bxNone) { return doOperation (bGetLT, Lock); }
   retCode getLE (int Lock = bxNone) { return doOperation (bGetLE, Lock); }
	retCode getGT (int Lock = bxNone) { return doOperation (bGetGT, Lock); }
   retCode getGE (int Lock = bxNone) { return doOperation (bGetGE, Lock); }

   retCode stepFirst (int Lock = bxNone) { return doOperation (bStepFirst, Lock); }
   retCode stepLast (int Lock = bxNone) { return doOperation (bStepLast, Lock); }
   retCode stepNext (int Lock = bxNone) { return doOperation (bStepNext, Lock); }
   retCode stepPrevious (int Lock = bxNone) { return doOperation (bStepPrevious, Lock); }
      
	retCode Delete () { return doOperation (bDelete); }
   retCode Insert () { return doOperation (bInsert); }
   retCode Update () { return doOperation (bUpdate); }

	retCode lockRecord (int Lock = bxNone);
   
   retCode Unlock (Boolean All = False);
   retCode Unlock (DWORD Pos);
   
   DWORD getPosition (DWORD &Pos);
   retCode getDirect (DWORD Pos);
   
	DWORD pushPosition ();
   DWORD popPosition ();

	retCode setOwner (char *ownerName, int Mode);
   retCode clearOwner ();
   
   retCode createSuppIndex (btrStatStruct &Def, int bufferLen);
   retCode dropSuppIndex (int Key);
      
	retCode getStatus (btrStatStruct &Def);
   
   retCode Clone (char *fileName, Boolean overWrite = True);
   retCode Create (char *fileName, btrStatStruct &Def, int bufferLen, Boolean overWrite = True);

	retCode Extend (char *fname, Boolean Immediate = False);

   Boolean isFileOpen () { return rep->fileopen; }
   Boolean isExtended () { return (rep->exfile) ? True : False; }
   retCode getReturn () { return prevReturn; }
   
	void pushDataBuffer () { ldb = db; ldl = arl; }
   void popDataBuffer () { db = ldb; rl = arl = ldl; }
   void resetDataBuffer () { db = ddb; rl = arl = ddl; }
   void setDataBuffer (char *Buf, WORD Len) { db = Buf; rl = arl = Len; }
   char *getDataBuffer () { return db; }

   void pushKeyBuffer () { lkb = kb; }
   void popKeyBuffer () { kb = lkb; }
   void resetKeyBuffer () { kb = dkb; }
	void setKeyBuffer (char *Buf) { kb = Buf; }
   char *getKeyBuffer () { return kb; }

	retCode setKeyNumber (int Key, Boolean Access = True);
      
   int getKeyNumber () { return kn; }

   char *getAlias () { return rep->alias; }
   char *getExtensionName () { return rep->exfile; }
   
	virtual char *nameOf () const { return "Btrieve Table"; }
	virtual void printOn (ostream& os);
private:
	btrTable & operator = (const btrTable &s);
	retCode doOperation (int Operation, int Lock = bxNone);
private:
	btrTableRep	*rep;
   char	*posblk;
	WORD	rl;				// Current Record Length
	WORD	arl;				// Default Record Length
   DWORD	currPosition;	// Current Position in File
   DWORD savePosition;	// Storage for PushPosition
	int	prevReturn;		// Return from Last Call
	char	*db;				// Data Buffer Pointer
	char	*kb;				// Key Buffer Pointer
	char	*ddb;				// Default Data Buffer
   WORD	ddl;				// Data Length of Default Data Buffer
	char	*ldb;				// Last Previous Data Buffer
   WORD	ldl;				// Data Length of Last Data Buffer	
	char	*dkb;				// Default Key Buffer
	char	*lkb;				// Last Previous Key Buffer
	int	kn;				// Current Key Number
   char *inData;			// Internal Data Buffer
   char *inKey;			// Internal Key Buffer
   	
 	btrFieldNode	*fieldList; // Field List
	};

#endif
