/*//////////////////////////////////////////////////////////////////////////
///            ___                                                       ///
///          /_____\                                                     ///
///         |       |                 Copyright (c) 1991                 ///
///         |   R   |                                                    ///
///     ----|_______|----                     by                         ///
///   /------/ | | \------\                                              ///
///  |       | | | |       |      --  Object Resource Group  --          ///
///  |   O   | | | |   G   |                                             ///
///  |       |/   \|       |          4323 Brown Suite 249               ///
///   -------       -------            Dallas,  TX  75219                ///
///   Object Resource Group                                              ///
///                                      (214) 528-2745                  ///
///                                                                      ///
///                                    All Rights Reserved.              ///
///                                                                      ///
//////////////////////////////////////////////////////////////////////////*/


#include <iostream.h>
#include <ctype.h>
#include <string.h>
#include <stdio.h>
#include <conio.h>

#include "btdset.hpp"
#include "btskey.hpp"
#include "btdef.hpp"
#include "bttran.hpp"
#include "tutor.hpp"

int CreateDataSets(void);
int CreatePerson();
int CreateOrder();
int CreateOrderItem();
int CreateItem();
int MainMenu();


//
// main()
//
//	returns  - status
// 	synopsis - creates all databases that currently do not exist
//		   runs main menu
//
int main()
   {
   int status = 0;


   // create the datasets if they do not exist
   status = CreateDataSets();

   if (!status)
      {
      // run main menu
      status = MainMenu();
      }


   return status;
   }



//
// CreateDataSets(void)
//
//	returns  - status
// 	synopsis - tries to creates each dataset
//
int CreateDataSets(void)
   {
   // create all the databases
   int status = 0;

   if ( (status = CreatePerson()) == 0 &&
	(status = CreateOrder()) == 0 &&
	(status = CreateOrderItem()) == 0 )
      status = CreateItem();

   return status;
   }


//
// CreatePerson(void)
//
//	returns  - status
// 	synopsis - defines the size of the dataset
//		   defines the keys
//		   sets the alternate collating sequence
//		   creates the dataset
//
int CreatePerson(void)
   {
   int status = 0;

   BT_Def fileDef(sizeof(Person), 0);

   ///// Define the Keys /////

   // key 0 is an AUTOINCREMENT key
   // key 1 is a MODIFIABLE, ZSTRING key that uses UPPER.ALT as
   //	    an alternate collating sequence
   //
   // Note that both keys have only one (1) segment
   //
   if ( (status = fileDef.AddFinalKeySegment(1, 4, BKEY_EXTENDED,
					     BTYPE_AUTOINCREMENT)) == 0 &&
	(status = fileDef.AddFinalKeySegment(5, 26, BKEY_EXTENDED+
						    BKEY_MODIFIABLE+
						    BKEY_ALT_SEQUENCE,
					     BTYPE_ZSTRING)) == 0 )
      {
      // set alternate collating sequence
      // to the standard UPPER.ALT
      fileDef.SetUpperAlt();

      // This actually creates the dataset.
      // The '-1' causes the method to return an error if
      // the file currently exists.  A '0' or no value
      // would allow the file to be overwritten.
      status = fileDef.CreateBtrieve("person.tbt", -1);
      }


   // ignore file exists error
   if (status == BSTAT_EXISTS) status = 0;

   return(status);
   }



//
// CreateOrder(void)
//
//	returns  - status
// 	synopsis - defines the size of the dataset
//		   defines the keys
//		   creates the dataset
//
int CreateOrder(void)
   {
   int status = 0;

   BT_Def fileDef(sizeof(Order), 0);

   ///// Define the Keys /////

   // key 0 is an NON-MODIFIABLE, NON_DUPLICATABLE ZSTRING
   // key 1 is a MANUAL key with two (2) segments
   //	Segment 1 is a ZSTRING that ALLOWS DUPLICATES
   //	Segment 2 is a UNSIGNED that allows DUPLICATES
   //
   if ( (status = fileDef.AddFinalKeySegment(1, 10, BKEY_EXTENDED,
						    BTYPE_ZSTRING)) == 0 &&
	(status = fileDef.AddKeySegment(15, 8, BKEY_EXTENDED+
					       BKEY_DUPLICATE+
					       BKEY_MANUAL,
					       BTYPE_ZSTRING)) == 0 &&
	(status = fileDef.AddFinalKeySegment(23, 2, BKEY_EXTENDED+
						    BKEY_DUPLICATE+
						    BKEY_MANUAL,
						    BTYPE_UNSIGNED)) == 0 )
      {
      ///// This actually creates the dataset /////
      status = fileDef.CreateBtrieve("order.tbt", -1);
      }


   // ignore file exists error
   if (status == BSTAT_EXISTS) status = 0;

   return(status);
   }


//
// CreateOrderItem(void)
//
//	returns  - status
// 	synopsis - defines the size of the dataset
//		   defines the keys
//		   creates the dataset
//
int CreateOrderItem(void)
   {
   int status = 0;

   BT_Def fileDef(sizeof(OrderItem), 0);


   ///// Define the Keys /////

   if ( (status = fileDef.AddFinalKeySegment(1, 10, BKEY_EXTENDED+
						    BKEY_DUPLICATE,
						    BTYPE_ZSTRING)) == 0 )
      {
      ///// This actually creates the dataset /////
      status = fileDef.CreateBtrieve("o_item.tbt", -1);
      }


   // ignore file exists error
   if (status == BSTAT_EXISTS) status = 0;

   return(status);
   }


//
// CreateItem(void)
//
//	returns  - status
// 	synopsis - defines the size of the dataset
//		   defines the keys
//		   creates the dataset
//
int CreateItem(void)
   {
   int status = 0;

   BT_Def fileDef(sizeof(Item), 0);


   ///// Define the Keys /////

   if ( (status = fileDef.AddFinalKeySegment(1, 2, BKEY_EXTENDED,
					     BTYPE_UNSIGNED)) == 0 )
      {
      ///// This actually creates the dataset /////
      status = fileDef.CreateBtrieve("item.tbt", -1);
      }


   // ignore file exists error
   if (status == BSTAT_EXISTS) status = 0;

   return(status);
   }


//
// MainMenu(void)
//
//	returns  - status
// 	synopsis - loop
//		      display choices
//		      allow user to process a selection
//		   until user is done
//
int MainMenu()
   {

   int status=0;
   char choice = ' ';

   while (!status && choice != '9')
      {
      printf("\n");
      printf("\n");
      printf("          Main Menu\n");
      printf("-------------------------------\n");
      printf("\n");
      printf("  1) - Maintain People\n");
      printf("  2) - Maintain Orders\n");
      printf("  3) - Maintain Items\n");
      printf("\n");
      printf("  9) - Quit\n");
      printf("\n");
      printf("Choice --> ");

      choice  = getch();
      printf("%c\n", choice);

      switch (choice)
	 {
	 case '1':
	    {
	    // creating an instance of a dataset causes the
	    // file (or files) associated with it to be
	    // opened
	    PersonDataSet personDataSet;
	    status = personDataSet.Menu();
	    break;
	    }	// out of scope - file is closed automatically

	 case '2':
	    {
	    OrderDataSet orderDataSet;
	    status = orderDataSet.Menu();
	    break;
	    }	// out of scope - file is closed automatically

	 case '3':
	    {
	    ItemDataSet itemDataSet;
	    status = itemDataSet.Menu();
	    break;
	    }	// out of scope - file is closed automatically


	 default: break;
	 }
      }

   return status;
   }



//
// PersonDataSet::Menu(void)
//
//	returns  - status
// 	synopsis - loop
//		      display choices
//		      allow user to process a selection
//		   until user is done
//
int PersonDataSet::Menu()
   {
   int status = Status();
   char choice = ' ';

   while (!status && choice != '9')
      {
      printf("\n");
      printf("\n");
      printf("          Person Menu\n");
      printf("-------------------------------\n");
      printf("\n");
      printf("  1) - Add A Person\n");
      printf("  2) - Modify a Person\n");
      printf("  3) - List People\n");
      printf("\n");
      printf("  9) - Quit\n");
      printf("\n");
      printf("Choice --> ");

      choice  = getch();
      printf("%c\n", choice);

      switch (choice)
	 {
	 case '1':
	     status = Add();
	     break;
	 case '2':
	     status = Modify();
	     break;
	 case '3':
	     status = List();
	     break;
	 default: break;
	 }
      }

   return status;
   }


//
// PersonDataSet::Add(void)
//
//	returns  - status
// 	synopsis - allow user to fill in person info
//		   get a key for the dataset
//		   insert the record via the key
//
int PersonDataSet::Add()
   {
   Person record;
   int status=0;
   char c;

   // fill in the record

   printf("\nPerson Name (Last Name, FirstName) -> ");
   cin.getline(record.name, sizeof(record.name));

   printf("\nStreet -> ");
   cin.getline(record.shipAddress.street, sizeof(record.shipAddress.street));

   printf("\nCity -> ");
   cin.getline(record.shipAddress.city, sizeof(record.shipAddress.city));

   printf("\nState -> ");
   cin.getline(record.shipAddress.state, sizeof(record.shipAddress.state));
   strupr(record.shipAddress.state);
   cin.get();	// extract that last char

   printf("\nZip Code -> ");
   cin.getline(record.shipAddress.zip, sizeof(record.shipAddress.zip));

   // get a key and add the record based on the key
   // A key is required as btrieve requires a key
   // path for an insert.  Any key will do.
   key = GetKey(0);
   if (key)
      status = key->Insert(&record);
   else
      status = Status();

   return status;
   }



//
// PersonDataSet::Modify(void)
//
//	returns  - status
// 	synopsis - get user specified person record
//		   allow user to update person info
//		   update the record via the key
//
int PersonDataSet::Modify()
   {
   Person record, oldRecord;
   int status=0;
   char c;

   // fill in the record

   printf("\nPerson Name (LastName, FirstName) -> ");
   cin.getline(oldRecord.name, sizeof(oldRecord.name));

   // get the oldRecord by the NAME KEY
   key = GetKey(1);

   if (key)
      {
      status = key->GetEqual(oldRecord.name, &oldRecord);

      if (!status)
	 {
	 // important - make a copy so info not entered below will be in
	 // the new record

	 record = oldRecord;

	 printf("\nOld Person Name (LastName, FirstName) -> %s", oldRecord.name);
	 printf("\nNew Person Name (LastName, FirstName) -> ");
	 cin.getline(record.name, sizeof(record.name));

	 printf("\nOld Street -> %s", oldRecord.shipAddress.street);
	 printf("\nNew Street -> ");
	 cin.getline(record.shipAddress.street, sizeof(record.shipAddress.street));

	 printf("\nOld City -> %s", oldRecord.shipAddress.city);
	 printf("\nNew City -> ");
	 cin.getline(record.shipAddress.city, sizeof(record.shipAddress.city));

	 printf("\nOld State -> %s", oldRecord.shipAddress.state);
	 printf("\nNew State -> ");
	 cin.getline(record.shipAddress.state, sizeof(record.shipAddress.state));
	 strupr(record.shipAddress.state);
	 if (strlen(record.shipAddress.state) == 2)
	    cin.get();	// extract that last char

	 printf("\nOld Zip Code -> %s", oldRecord.shipAddress.zip);
	 printf("\nNew Zip Code -> ");
	 cin.getline(record.shipAddress.zip, sizeof(record.shipAddress.zip));

	 // make sure valid values exist
	 if ( !strlen(record.name) )
	    strcpy(record.name, oldRecord.name);

	 if ( !strlen(record.shipAddress.street) )
	    strcpy(record.shipAddress.street, oldRecord.shipAddress.street);

	 if ( !strlen(record.shipAddress.city) )
	    strcpy(record.shipAddress.city, oldRecord.shipAddress.city);

	 if ( !strlen(record.shipAddress.state) )
	    strcpy(record.shipAddress.state, oldRecord.shipAddress.state);

	 if ( !strlen(record.shipAddress.zip) )
	    strcpy(record.shipAddress.zip, oldRecord.shipAddress.zip);


	 // update the record - shockingly easy
	 status = key->Update(&record);
	 if (status)
	    printf("Error %d occurred while updating %s", status, record.name);
	 }
      else
	 {
	 if (status == BSTAT_NOTFOUND)
	    {
	    printf("Person: %s was not found", oldRecord.name);
	    status = 0;
	    }
	 else
	    printf("Error %d occurred while searching for %s", status,
				oldRecord.name);
	 }
      }
   else
      status = Status();


   return status;
   }



//
// PersonDataSet::List(void)
//
//	returns  - status
// 	synopsis - get first person record by NAME key
//		   loop
//		      print person info
//		      get next person record
//		   until no more records
//
int PersonDataSet::List()
   {
   // list in name order
   int status = Status();
   Person record;

   // get the oldRecord by the NAME KEY
   key = GetKey(1);

   if (key)
      {
      status = key->GetFirst(&record);

      int count = 0;
      while (!status)
	 {
	 // done to make the screen look pretty, not
	 // particularly necessary
	 if (!count || count > 20)
	    {
	    if (count)
	       {
	       cout << "Pause --- Hit any key for next screen\n";
	       getch();
	       }

	    cout << "\n\nPerson File Listing\n";
	    cout << "-------------------\n\n";
	    count = 0;
	    }

	 cout << record.name << '\n';
	 cout << record.shipAddress.street << '\n';
	 cout << record.shipAddress.city << ", " << record.shipAddress.state
			<< "  " << record.shipAddress.zip << "\n\n";
	 count += 5;

	 // get the next person record
	 status = key->GetNext(&record);
	 }
      if (status == BSTAT_EOF) status = 0;
      }
   else
      status = Status();


   return status;
   }



//
// ItemDataSet::Menu(void)
//
//	returns  - status
// 	synopsis - loop
//		      display choices
//		      allow user to process a selection
//		   until user is done
//
int ItemDataSet::Menu()
   {
   int status = Status();
   char choice = ' ';

   while (!status && choice != '9')
      {
      printf("\n");
      printf("\n");
      printf("          Item Menu\n");
      printf("-------------------------------\n");
      printf("\n");
      printf("  1) - Add An Item\n");
      printf("  2) - Modify an Item\n");
      printf("  3) - List Items\n");
      printf("\n");
      printf("  9) - Quit\n");
      printf("\n");
      printf("Choice --> ");

      choice  = getch();
      printf("%c\n", choice);

      switch (choice)
	 {
	 case '1':
	     status = Add();
	     break;
	 case '2':
	     status = Modify();
	     break;
	 case '3':
	     status = List();
	     break;
	 default: break;
	 }
      }

   return status;
   }



//
// ItemDataSet::Add(void)
//
//	returns  - status
// 	synopsis - allow user to fill in item info
//		   get a key for the dataset
//		   insert the record via the key
//
int ItemDataSet::Add()
   {
   Item record;
   int status=0;
   char c;

   // fill in the record

   printf("\nItem Number -> ");
   cin >> record.itemNumber;
   cin.get();		// removes extra \n in stream

   printf("\nDescription -> ");
   cin.getline(record.description, sizeof(record.description));

   printf("\nUnit Cost -> ");
   cin >> record.unitCost;
   cin.get();		// removes extra \n in stream

   // get a key and add the record based on the key
   key = GetKey(0);

   if (key)
      status = key->Insert(&record);
   else
      status = Status();

   return status;
   }



//
// ItemDataSet::Modify(void)
//
//	returns  - status
// 	synopsis - get user specified item record
//		   allow user to update item info
//		   update the record via the key
//
int ItemDataSet::Modify()
   {
   Item record, oldRecord;
   int status=0;
   char c;

   // fill in the record

   printf("\nItem Number -> ");
   cin >> oldRecord.itemNumber;
   cin.get();		// removes extra \n in stream

   // get the oldRecord by the ITEM KEY
   key = GetKey(0);

   if (key)
      {
      status = key->GetEqual(&oldRecord.itemNumber, &oldRecord);

      if (!status)
	 {
	 // important - make a copy so info not entered below will be in
	 // the new record

	 record = oldRecord;

	 printf("\nOld Description -> %s", oldRecord.description);
	 printf("\nNew Description -> ");
	 cin.getline(record.description, sizeof(record.description));

	 printf("\nOld Unit Cost -> %.2f", oldRecord.unitCost);
	 printf("\nNew Unit Cost -> ");
	 cin >> record.unitCost;
	 cin.get();		// removes extra \n in stream

	 // make sure valid values exist
	 if ( !strlen(record.description) )
	    strcpy(record.description, oldRecord.description);

	 if ( record.unitCost == 0.0 )
	    record.unitCost = oldRecord.unitCost;

	 // update the record - shockingly easy
	 status = key->Update(&record);
	 if (status)
	    printf("Error %d occurred while updating %u", status, record.itemNumber);
	 }
      else
	 {
	 if (status == BSTAT_NOTFOUND)
	    {
	    printf("Item: %u was not found", oldRecord.itemNumber);
	    status = 0;
	    }
	 else
	    printf("Error %d occurred while searching for %u", status,
				oldRecord.itemNumber);
	 }
      }
   else
      status = Status();


   return status;
   }



//
// ItemDataSet::List(void)
//
//	returns  - status
// 	synopsis - get first item record by key
//		   loop
//		      print item info
//		      get next item record
//		   until no more records
//
int ItemDataSet::List()
   {
   // list in name order
   int status = 0;
   Item record;

   // get the oldRecord by the NUMBER KEY
   key = GetKey(0);

   if (key)
      {
      status = key->GetFirst(&record);

      int count = 0;
      while (!status)
	 {
	 if (!count || count > 20)
	    {
	    if (count)
	       {
	       cout << "Pause --- Hit any key for next screen\n";
	       getch();
	       }

	    cout << "\n\nItem File Listing\n";
	    cout << "-------------------\n\n";
	    count = 0;
	    }

	 printf("%u - %s @ %.2f each\n", record.itemNumber,
			record.description, record.unitCost);
	 count++;
	 status = key->GetNext(&record);
	 }
      if (status == BSTAT_EOF) status = 0;
      }
   else
      status = Status();


   return status;
   }




//
// OrderDataSet::Menu(void)
//
//	returns  - status
// 	synopsis - loop
//		      display choices
//		      allow user to process a selection
//		   until user is done
//
int OrderDataSet::Menu()
   {
   int status = Status();
   char choice = ' ';

   while (!status && choice != '9')
      {
      printf("\n");
      printf("\n");
      printf("          Order Menu\n");
      printf("-------------------------------\n");
      printf("\n");
      printf("  1) - Add An Order\n");
      printf("  2) - Modify an Order\n");
      printf("  3) - List All Orders\n");
      printf("  4) - Print an Invoice\n");
      printf("\n");
      printf("  9) - Quit\n");
      printf("\n");
      printf("Choice --> ");

      choice  = getch();
      printf("%c\n", choice);

      switch (choice)
	 {
	 case '1':
	     status = Add();
	     break;
	 case '2':
	     status = Modify();
	     break;
	 case '3':
	     status = List();
	     break;
	 case '4':
	     status = PrintOne();
	     break;
	 default: break;
	 }
      }

   return status;
   }



//
// OrderDataSet::Add(void)
//
//	returns  - status
// 	synopsis - start a transaction
//		   allow user to fill in order info
//		   validate the person
//		   loop
//		      add an order item
//		   until user is finished
//		   get a key for the dataset
//		   insert the record via the key
//		   end the transaction
//
int OrderDataSet::Add()
   {
   Order record;
   int status=0;
   char c;


   // Because we will update multiple datasets, this is a good
   // opportunity to use a transaction.  NOTE - Never use a transaction
   // in this manner (as files are locked while waiting on the user
   // input) in a network environment unless one desire to stop up the
   // system (or unless one is writing a simple tutorial).  Instead, buffer
   // information and use the transaction only when accessing the files

   BT_Transaction transaction;


   if (transaction.Status())
      return status;		// problem - get out immediately


   // fill in the record

   printf("\nOrder Number -> ");
   cin.getline(record.number, sizeof(record.number));


   Person person;
   do
      {
      printf("\nPerson's Name (Last Name, First) -> ");
      cin.getline(person.name, sizeof(person.name));

      if (strlen(person.name))
	 {
	 // check to see if name is legit
	 personDS.key = personDS.GetKey(1);
	 status = personDS.key->GetEqual(person.name, &person);
	 if (status)
	    {
	    if (status == BSTAT_NOTFOUND)
	       printf("Person: %s was not found - please reenter",
			person.name);
	    else
	       break;
	    }
	 }
      else
	 person.id = 0;
      } while (status);

   if (!status && person.id)
      {
      record.personID = person.id;

      // lousy method but, hey, this is a simple tutorial example
      // a real OOProgrammer would have some nifty date class
      printf("\nPlease enter date (YYMMDD) -> ");
      cin.getline(record.dateOrdered, 7);
      cin.get();		// removes extra \n in stream


      // check if prepaid
      printf("\nHas person paid yet (Y/N) -> ");
      char answer;
      cin.get(answer);
      cin.get();
      if (toupper(answer) == 'Y')
	 record.paidFlag = Boolean((answer == 'Y') ? True : False);


      // get all order items for the order
      do
	 {
	 status = orderItemDS.Add(record.number);
	 } while (!status);	// BSTAT_EOF is returned when nothing entered

      // check if user was just requesting to quick
      if (status == BSTAT_EOF) status = 0;

      if (!status)
	 {
	 // get a key and add the record based on the key
	 key = GetKey(0);

	 if (key)
	    status = key->Insert(&record);
	 else
	    status = Status();
	 }

      }

   // if everything is good - commit to disk
   if (!status)
      status = transaction.Commit();

   return status;
   }



//
// OrderDataSet::Modify(void)
//
//	returns  - status
// 	synopsis - get user specified order record
//		   allow user to update paid status
//		   update the record via the key
//
int OrderDataSet::Modify()
   {
   Order record, oldRecord;
   int status=0;
   char c;

   // fill in the record

   printf("\nOrder Number -> ");
   cin.getline(oldRecord.number, sizeof(oldRecord.number));

   // get the oldRecord by the order number key
   key = GetKey(0);

   if (key)
      {
      status = key->GetEqual(oldRecord.number, &oldRecord);

      if (!status)
	 {
	 // important - make a copy so info not entered below will be in
	 // the new record

	 record = oldRecord;

	 // check if prepaid
	 printf("\nHas person paid yet (Y/N) -> ");
	 char answer;
	 cin.get(answer);
	 cin.get();
	 if (toupper(answer) == 'Y')
	    record.paidFlag = Boolean((answer == 'Y') ? True : False);

	 // update the record - shockingly easy
	 status = key->Update(&record);
	 if (status)
	    printf("Error %d occurred while updating %s", status, record.number);
	 }
      else
	 {
	 if (status == BSTAT_NOTFOUND)
	    {
	    printf("Order: %s was not found", oldRecord.number);
	    status = 0;
	    }
	 else
	    printf("Error %d occurred while searching for %s", status,
				oldRecord.number);
	 }
      }
   else
      status = Status();


   return status;
   }



//
// OrderDataSet::PrintOne(void)
//
//	returns  - status
// 	synopsis - get user specified order record
//		   print order info
//		   loop
//		      print each item's information
//		   until no more items
//		   print summary information
//
int OrderDataSet::PrintOne()
   {
   Order record;
   int status=0;
   char c;

   // fill in the record

   printf("\n\nOrder Number -> ");
   cin.getline(record.number, sizeof(record.number));

   // get the order record
   key = GetKey(0);

   if (key)
      {
      status = key->GetEqual(record.number, &record);

      if (!status)
	 {
	 // print order
	 printf("Purchase Order Number: %s\n", record.number);
	 printf("Date of Order: %s\n\n", record.dateOrdered);

	 // get person and address
	 printf("Ship to: ");
	 personDS.key = personDS.GetKey(0);
	 Person person;
	 if (personDS.key->GetEqual(&record.personID, &person))
	    {
	    // not found
	    printf("UKNOWN PERSON\n\n\n\n");
	    }
	 else
	    {
	    printf("%s\n", person.name);
	    printf("         %s\n", person.shipAddress.street);
	    printf("         %s, %s  %s\n\n", person.shipAddress.city,
					  person.shipAddress.state,
					  person.shipAddress.zip);
	    }

	 // header line for items in order
	 printf(" Item #            Description               Quantity  Unit Cost  Total Cost\n");
	 printf(" ------ ----------------------------------- ---------- ---------- ----------\n");
	 printf("\n");

	 // loop for each item
	 OrderItem orderItem;
	 Item item;

	 orderItemDS.key = orderItemDS.GetKey(0);
	 status = orderItemDS.key->GetGreaterEqual(record.number, &orderItem);
	 if ( !status && !(strcmp(orderItem.orderNumber, record.number)) )
	    {
	    double grandTotal = 0.0;

	    do
	       {
	       printf(" %5u  ", orderItem.itemNumber);

	       // get description
	       orderItemDS.itemDS.key = orderItemDS.itemDS.GetKey(0);
	       if (orderItemDS.itemDS.key->GetEqual(&orderItem.itemNumber, &item))
		  strcpy(item.description, "UNKNOWN");

	       double totCost = orderItem.purchaseCost * orderItem.quantity;
	       grandTotal += totCost;
	       printf("%-35s %10.2f %10.2f %10.2f\n", item.description,
						      orderItem.quantity,
						      orderItem.purchaseCost,
						      totCost);
	       status = orderItemDS.key->GetNext(&orderItem);
	       } while (!status && !(strcmp(orderItem.orderNumber, record.number)));

	    printf("\n       				                   "
		   "Grand Total ->%11.2f\n\n", grandTotal);
	    }
	 else
	    {
	    printf("                            NO ITEMS FOUND\n");
	    }

	 if (status == BSTAT_EOF) status = 0;
	 }
      else
	 {
	 if (status == BSTAT_NOTFOUND)
	    {
	    printf("Order: %s was not found", record.number);
	    status = 0;
	    }
	 else
	    printf("Error %d occurred while searching for %s", status,
				record.number);
	 }
      }
   else
      status = Status();


   return status;
   }



//
// OrderDataSet::List(void)
//
//	returns  - status
// 	synopsis - get first order record by key
//		   loop
//		      print order info
//		      get next order record
//		   until no more records
//
int OrderDataSet::List()
   {
   // list in name order
   int status = Status();
   Order record;

   // get the oldRecord by the NUMBER
   key = GetKey(0);

   if (key)
      {
      status = key->GetFirst(&record);

      int count = 0;
      while (!status)
	 {
	 if (!count || count > 20)
	    {
	    if (count)
	       {
	       cout << "Pause --- Hit any key for next screen\n";
	       getch();
	       }

	    cout << "\n\nPurchase Order File Listing\n";
	    cout << "-------------------\n\n";
	    count = 0;
	    }


	 printf("%s ordered on %s by ", record.number, record.dateOrdered);
	 // look for person
	 personDS.key = personDS.GetKey(0);
	 Person person;
	 if (personDS.key->GetEqual(&record.personID, &person))
	    {
	    // not found
	    printf("UKNOWN PERSON\n");
	    }
	 else
	    printf("%s\n", person.name);

	 count += 1;
	 status = key->GetNext(&record);
	 }
      if (status == BSTAT_EOF) status = 0;
      }
   else
      status = Status();


   return status;
   }



//
// OrderItemDataSet::Add(order number)
//
//	returns  - status
// 	synopsis - allow user to fill in order item info
//		   get a key for the dataset
//		   insert the record via the key
//
int OrderItemDataSet::Add(const char *orderNumber)
   {
   OrderItem record;
   int status=0;

   strcpy(record.orderNumber, orderNumber);

   Item item;

   cout << '\n';

   do
      {
      printf("Enter item number (0 - Quit) -> ");
      cin >> record.itemNumber;
      cin.get();

      if (record.itemNumber)
	 {
	 // validate itemNumber
	 itemDS.key = itemDS.GetKey(0);
	 status = itemDS.key->GetEqual(&record.itemNumber, &item);
	 if (status)
	    {
	    if (status == BSTAT_NOTFOUND)
	       {
	       printf("Item number: %u not found - Please reenter\n",
			record.itemNumber);
	       }
	    else
	       {
	       printf("Error %d finding item number: %u",
			status, record.itemNumber);
	       }
	    }
	 else
	    record.purchaseCost = item.unitCost;
	 }
      else
	 status = BSTAT_EOF;		// user wants to quit

      } while (status == BSTAT_NOTFOUND);

   if (!status)
      {
      printf("Enter quantity to order -> ");
      cin >> record.quantity;
      cin.get();


      // get a key and add the record based on the key
      key = GetKey(0);

      if (key)
	 status = key->Insert(&record);
      else
	 status = Status();
      }
   return status;
   }

