/*//////////////////////////////////////////////////////////////////////////
///            ___                                                       ///
///          /_____\                                                     ///
///         |       |                 Copyright (c) 1991                 ///
///         |   R   |                                                    ///
///     ----|_______|----                     by                         ///
///   /------/ | | \------\                                              ///
///  |       | | | |       |      --  Object Resource Group  --          ///
///  |   O   | | | |   G   |                                             ///
///  |       |/   \|       |          4323 Brown Suite 249               ///
///   -------       -------            Dallas,  TX  75219                ///
///   Object Resource Group                                              ///
///                                      (214) 528-2745                  ///
///                                                                      ///
///                                    All Rights Reserved.              ///
///                                                                      ///
//////////////////////////////////////////////////////////////////////////*/

#include <string.h>
#include "btkey.hpp"

#if !defined(BTSKEY_HPP)
#define BTSKEY_HPP	1

////////////////////////// CLASS BT_SuppKey ///////////////////////

class BT_SuppKey : public BT_Key
	{
	friend BT_DataSet;
	private:
		BT_SuppKey(BT_DataSet *_dataSet, int _keyNum, int _keyLen,
			   unsigned long _flag) :
		     BT_Key(_dataSet, _keyNum, _keyLen, _flag) {};
		~BT_SuppKey()  {   }
	public:
		// Removes the supplemental key value from file.  This will
		// cause all keys with a higher key number to be renumbered
		// (Btrieve's action, not ours) so that key numbers remain
		// consecutive and sequential.  Therefore it wise to reuse
		// the BT_DataSet's GetKey() for each key that has a higher
		// number that has been dropped.  Note that if in concurrent
		// mode another process drops a key your process will NOT be
		// aware of it and will subsequently process the wrong key.
		// Maybe our users (and Novell?) will have a solution to
		// problem.
		int DropKey();
	};

#endif
