/*//////////////////////////////////////////////////////////////////////////
///            ___                                                       ///
///          /_____\                                                     ///
///         |       |                 Copyright (c) 1991                 ///
///         |   R   |                                                    ///
///     ----|_______|----                     by                         ///
///   /------/ | | \------\                                              ///
///  |       | | | |       |      --  Object Resource Group  --          ///
///  |   O   | | | |   G   |                                             ///
///  |       |/   \|       |          4323 Brown Suite 249               ///
///   -------       -------            Dallas,  TX  75219                ///
///   Object Resource Group                                              ///
///                                      (214) 528-2745                  ///
///                                                                      ///
///                                    All Rights Reserved.              ///
///                                                                      ///
//////////////////////////////////////////////////////////////////////////*/

//	BTKEY.HPP

#if !defined(BTKEY_HPP)
#define BTKEY_HPP	1

#include <string.h>
#include "btdset.hpp"

////////////////////////// CLASS BTKEY ///////////////////////

class BT_Key
	{
	friend BT_DataSet;
	protected:
		int	  keyNum;	// key number
		int       keyLen;	// key length
		BT_Buff	 *buffer;	// the key buffer
		BT_DataSet *dataSet;	// the owning dataset
		unsigned long flag;	// lower integer is reserved for
					// btrieve key flags

		int Get(int opCode, const void *keyBuff, void *userBuff,
			int userLen);
		int GetKey(int opCode, void *keyBuff, int keyLen);

		BT_Key(BT_DataSet *_dataSet, int _keyNum, int _keyLen,
		       unsigned long _flag);
		~BT_Key();

	public:
		// Get last return code for related operation
		int Status() { return dataSet->Status(); }

		// Get extended status for related operation.  Note that it
		// is undefined if no error occurred (ie Status() returns 0)
		int ExtendedStatus() { return dataSet->ExtendedStatus(); }

		// Clear out all status codes
		void ClearStatus() { dataSet->ClearStatus(); }

		// Set the value of the key to be used for 'Keyed Operations'
		// Note that all 'Keyed Operations' (see below) allow for key
		// value to be passed in.  However, it may be convenient to
		// set the value once if it is to be used many times.
		void SetKeyVal(const void *Val);

		// Get the value of the key.  Many 'Get' functions update the
		// key field but do not explicitly return it.
		void GetKeyVal(void *UserBuff, int userLen=0);

		// Inserts a record into file.  A 'userBuff' and length can
		// be passed in.  If it is not passed in the current record
		// in the BT_DataSet is used (see BT_DataSet's SetDataBuffer())
		int Insert(void *userBuff=0, int userLen=0);

		// Updates current record.  Same rules as Insert() apply.
		int Update(void *userBuff=0, int userLen=0);

		// Non Keyed Get operations.  A key retrieved from the record
		// and can be obtained using GetKeyVal().  A buffer and length
		// can be used to hold the retrieved record.  The buffer must
		// be of large enough to length used. If 'userLen' is not
		// passed in the length defaults to the file's record length.
		int GetFirst(void *userBuff=0, int userLen=0);
		int GetLast(void *userBuff=0, int userLen=0);
		int GetNext(void *userBuff=0, int userLen=0);
		int GetPrev(void *userBuff=0, int userLen=0);

		// Keyed Get operations.  A key value can be optionally passed
		// in.  If not passed inthe key value from SetKeyVal() is
		// used.  Same rules as Non Key Gets apply for the record
		// buffer.
		int GetEqual(const void *keyBuff=0, void *userBuff=0,
			     int userLen=0);
		int GetGreaterEqual(const void *keyBuff=0, void *userBuff=0,
				    int userLen=0);
		int GetLessEqual(const void *keyBuff=0, void *userBuff=0,
				 int userLen=0);
		int GetGreater(const void *keyBuff=0, void *userBuff=0,
			       int userLen=0);
		int GetLess(const void *keyBuff=0, void *userBuff=0,
			    int userLen=0);

		//  Gets with lock mode.  See above for detailed explanation.
		int GetFirst(int mode, void *userBuff=0, int userLen=0);
		int GetLast(int mode, void *userBuff=0, int userLen=0);
		int GetNext(int mode, void *userBuff=0, int userLen=0);
		int GetPrev(int mode, void *userBuff=0, int userLen=0);
		int GetEqual(int mode, const void *keyBuff=0, void *userBuff=0,
			     int userLen=0);
		int GetGreaterEqual(int mode, const void *keyBuff=0,
				    void *userBuff=0, int userLen=0);
		int GetLessEqual(int mode, const void *keyBuff=0,
				 void *userBuff=0, int userLen=0);
		int GetGreater(int mode, const void *keyBuff=0,
			       void *userBuff=0, int userLen=0);
		int GetLess(int mode, const void *keyBuff=0, void *userBuff=0,
			    int userLen=0);

		//  Gets with key only.  Does not return a record but will
		// update the key value.
		int GetKeyFirst(void *keyBuff=0, int keyLen=0);
		int GetKeyLast(void *keyBuff=0, int keyLen=0);
		int GetKeyNext(void *keyBuff=0, int keyLen=0);
		int GetKeyPrev(void *keyBuff=0, int keyLen=0);
		int GetKeyEqual(void *keyBuff=0, int keyLen=0);
		int GetKeyGreaterEqual(void *keyBuff=0, int keyLen=0);
		int GetKeyLessEqual(void *keyBuff=0, int keyLen=0);
		int GetKeyGreater(void *keyBuff=0, int keyLen=0);
		int GetKeyLess(void *keyBuff=0, int keyLen=0);

		// Deletes current record
		int Delete();

		// Obtain the four-byte Btrieve physical position information
		// This value is internally saved for RestorePositon()
		unsigned long GetPosition() { return dataSet->GetPosition(); }

		// Retrieves record from a physical position.  The position
		// obtained from GetPosition() is used.
		int RestorePosition(void *userBuff=0, int userLen=0);
		int RestorePosition(ULONG position, void *userBuff=0,
				    int userLen=0);
	};

#endif
