/*//////////////////////////////////////////////////////////////////////////
///            ___                                                       ///
///          /_____\                                                     ///
///         |       |                 Copyright (c) 1991                 ///
///         |   R   |                                                    ///
///     ----|_______|----                     by                         ///
///   /------/ | | \------\                                              ///
///  |       | | | |       |      --  Object Resource Group  --          ///
///  |   O   | | | |   G   |                                             ///
///  |       |/   \|       |          4323 Brown Suite 249               ///
///   -------       -------            Dallas,  TX  75219                ///
///   Object Resource Group                                              ///
///                                      (214) 528-2745                  ///
///                                                                      ///
///                                    All Rights Reserved.              ///
///                                                                      ///
//////////////////////////////////////////////////////////////////////////*/

#ifndef BTKDEF_HPP
#define BTKDEF_HPP

extern "C"
  {
  #include "bt.h"
  }

//////////////////  Class BT_KeyDef  /////////////////////

class BT_KeyDef
    {
    friend BT_Def;	// allow access to counters
    friend BT_DataSet;	// allow access to counters for supple key add
    protected:

	KEYSPEC  kspecs[MAX_KEY_SPECS];
	int	 num_keys;
	int      num_keyspecs;
	int      num_dupkeys;
	char     altcolseq[265];

    public:

	// CONSTRUCTOR
	BT_KeyDef() { num_keys = num_keyspecs = num_dupkeys = 0;
		      altcolseq[0] = '\0'; }


	// add a key segment definition ... more segments to follow
	virtual int AddKeySegment(int Start, int Length, int Flags,
			   char KeyType, char NullVal=(char)0);

	// add a key segment definition ... NO segments to follow
	// may be redefined for children
	virtual int AddFinalKeySegment(int Start, int Length, int Flags,
			       char KeyType, char NullVal=(char)0);

	// use your own Alternate Collating Sequence
	void SetAltCollSeq(void *Ptr);

	// use standard Alternate Collating Sequence 'UPPER.ALT'
	void SetUpperAlt(void);

    };

#endif