/*//////////////////////////////////////////////////////////////////////////
///            ___                                                       ///
///          /_____\                                                     ///
///         |       |                 Copyright (c) 1991                 ///
///         |   R   |                                                    ///
///     ----|_______|----                     by                         ///
///   /------/ | | \------\                                              ///
///  |       | | | |       |      --  Object Resource Group  --          ///
///  |   O   | | | |   G   |                                             ///
///  |       |/   \|       |          4323 Brown Suite 249               ///
///   -------       -------            Dallas,  TX  75219                ///
///   Object Resource Group                                              ///
///                                      (214) 528-2745                  ///
///                                                                      ///
///                                    All Rights Reserved.              ///
///                                                                      ///
//////////////////////////////////////////////////////////////////////////*/

// 	HISTORY		Dave Loomis 10/17/91

#include "btbuff.hpp"
#include "btskdef.hpp"

#if !defined(BTDATASET_HPP)
#define BTDATASET_HPP

extern "C"
    {
    #include "bt.h"
    }

// Forward referencing to prevent unknown errors
class BT_Key;
class BT_SuppKey;

class BT_DataSet
	{
	friend class BT_Key;	//// FRIEND CLASS
	friend class BT_SuppKey;//// FRIEND CLASS
	private:
	    BT_Key      **activeKey;	// keys for file
	    char        pblock[128];	// File's Position Block
	    ULONG	physical;	// physical position in file
	    char        *filename;	// path/name
	    int         lastStatus;	// last return code
	    ExtStatus 	extendedStatus; // internal status
	    BT_FileStat statistics;	// returned from 'stat'
	    BT_Buff     *dataBuff;	// Data Buffer
	    ULONG       flag;		// internal defined flag
	    int 	openMode;	// Mode file was open in
	    int OpenFile(char *nm, char *owner=0, int openMode=0);
			 // open a btrieve file
	    void MakeDataSet(char *nm,
		 char *owner, int openMode); // opens file & gets stat
	    void CleanupDataSet();
	    int CreateKeys(const BT_FileStat &oldStats, char *statsBuff);
	protected:

	    // obtain pointer to position block
	    char *PBlock() { return pblock; }

	public:

	    // CONSTRUCTORS
	    //   The Btrieve OPEN operation takes place in the
	    //   constructor.  Status() will return zero if the
	    //   operation was successful.
	    BT_DataSet(char *newfile, char *ownername, int openMode=0 );
	    BT_DataSet(char *newfile, int openMode, char *ownername=0);

	    //   No owner name is passed; the file is opened in mode 0
	    BT_DataSet(char *newfile);

	    // DESTRUCTOR
	   ~BT_DataSet();

	    //   Retrieve the status code of the most recent Btrieve operation
	    int Status() { return lastStatus; }

	    // Get extended status for related operation.  Note that it
	    // is undefined if no error occurred (ie Status() returns 0)
	    int ExtendedStatus() { return extendedStatus; }

	    //   Clear the Btrieve status code
	    void ClearStatus() { lastStatus = 0; extendedStatus = BT_OK; }

	    //   To access a dataset in key order, obtain a pointer to
	    //   at BT_Key object.  'index' is the key number.
	    //   NOTE: DO NOT free (delete) this object (you will get a
	    //   compiler error for a delete).  The memory is owned by
	    //   the BT_DataSet object and will be freed as part of destructor
	    //   ~BT_DataSet()
	    BT_Key *GetKey(int index);

	    // 	 Likewise to gain access to a supplemental key use the
	    //	 'index' as the key number.  DO not delete the key.  It can,
	    //	 however, be dropped by calling the key's function DropKey().
	    BT_SuppKey *GetSuppKey(int index);

	    //	 To make life easier access to an uncreated supplemental key
	    //	 can be gained by passing a pointer to a BT_SuppKeyDef.  See
	    //	 AddKey() comments below for further explanation
	    BT_SuppKey *GetSuppKey(const BT_SuppKeyDef &keyDef);


	    //   BT_DataSet keeps an internal data buffer long enough for
	    //   the FIXED length portion of the record.  However, you may
	    //   wish to substitute your own BT_Buff object (or an object of
	    //   a class derived from BT_Buff) for the internal buffer.  Here's
	    //   the member function to do that.  If you tell BT_DataSet to use
	    //   YOUR data buffer, you are still responsible for freeing your
	    //   memory!
	    void SetDataBuffer( BT_Buff *user );

	    //	Get Reference to File's Data Buffer...cf. class BT_Buff
	    BT_Buff *DataBuff() { return dataBuff; }

	    //   These methods are the Btrieve STEP operations
	    //   You may optionally pass in your own buffer and buffer length
	    int StepFirst(void *buffer=0, int len=0);
	    int StepLast(void *buffer=0, int len=0);
	    int StepNext(void *buffer=0, int len=0);
	    int StepPrev(void *buffer=0, int len=0);

	    //   Obtain the four-byte Btrieve physical position information
	    unsigned long GetPosition();

	    //   Btrieve file owner operations
	    int SetOwner(char *owner, int mode=0);
	    int ClearOwner();

	    //	 Get file and key statistics
	    //	 User must supply a buffer BTF_FILE_STAT_SIZE bytes long
	    //	 to guarantee entire file an key statistics.  Optionally a
	    //   shorter buffer length may be provided if only partial
	    //	 infomation is desired or a longer length if information on
	    //	 Alternating Collating Sequence is needed.
	    //	 Note that an error 22 (BSTAT_BUFF_TOO_SHORT) may be
	    //	 returned if buffer is too small for FileStat + KeyStat +
	    //	 AltCollatingSeq information.
	    int Stat(void *buffer, int len=BTF_FILE_STAT_SIZE);

	    //	 Add a supplemental key
	    //	 This function takes a pointer to BT_SuppKeyDef.  Previous
	    //	 to calling this function you should have added the
	    //	 segments of the key desired by using AddKeySegment and
	    //	 AddFinalKeySegment.  An alternating collating sequence
	    //	 can also be added for this key.  Note that only one sequence
	    //	 per file is allowed.
	    //
	    //   ----WARNING----
	    //
	    //   There is a small key numbering problem with CreateSupplementalKey that
	    //   CreateSupplementalKey that gets dramatically increased when
	    //   concurrency issues are added to it.  When a supplemental is
	    //   added the key number is derived by taking the current number
	    //   of keys and adding one.  This is no good in a concurrent
	    //   environment where supplemental keys can be added at the same
	    //   time. Also, when a key is dropped all keys above that key
	    //   are renumbered. This does not work in a concurrent
	    //   environment either, especially if a programmer uses constants
	    //   for key numbers.  At this point the programmer is responsible
	    //   for the actions.  Hopefully some good solutions will come
	    //   from our user base (and perhaps Novell?). In the mean time
	    //   an error (BSTAT_TOO_MANY_KEYS) will be returned if two keys
	    //   a created at the same time.  The lower of these two key
	    //   numbers be returned.  I suggest the key be dropped
	    //   immediately and the process to create a supplemental key
	    //   repeated.
	    int AddKey(const BT_SuppKeyDef &keyDef, int &index);
	};

#endif
