/*//////////////////////////////////////////////////////////////////////////
///            ___                                                       ///
///          /_____\                                                     ///
///         |       |                 Copyright (c) 1991                 ///
///         |   R   |                                                    ///
///     ----|_______|----                     by                         ///
///   /------/ | | \------\                                              ///
///  |       | | | |       |      --  Object Resource Group  --          ///
///  |   O   | | | |   G   |                                             ///
///  |       |/   \|       |          4323 Brown Suite 249               ///
///   -------       -------            Dallas,  TX  75219                ///
///   Object Resource Group                                              ///
///                                      (214) 528-2745                  ///
///                                                                      ///
///                                    All Rights Reserved.              ///
///                                                                      ///
//////////////////////////////////////////////////////////////////////////*/

#ifndef BTDEF_HPP
#define BTDEF_HPP

#include "btkdef.hpp"

extern "C"
  {
  #include "bt.h"
  }

//////////////////  Class BT_Def  /////////////////////

class BT_Def
    {
    protected:

	FILESPEC fspec;
	BT_KeyDef keyDef;

	// calculate pagesize for optimizing storage space usage
	void CalcPageSize(void);

    public:

	// CONSTRUCTOR
	BT_Def(int RecLength, int Flags, int PageSize=0, int PreAlloc=0);

	// add a key segment definition ... more segments to follow
        // no supplemental key is allowed because of its design flaw in network
        // usage
	int AddKeySegment(int Start, int Length, int Flags, char KeyType,
			  char NullVal=(char)0)
	   {
	   return keyDef.AddKeySegment(Start, Length, Flags, KeyType, NullVal);
	   }

	// add a key segment definition ... NO segments to follow
        // no supplemental key is allowed because of its design flaw in network
	// usage
	int AddFinalKeySegment(int Start, int Length, int Flags,
			       char KeyType, char NullVal=(char)0)
	   {
	   return keyDef.AddFinalKeySegment(Start, Length, Flags, KeyType,
					    NullVal);
	   }


	// use your own Alternate Collating Sequence
	void SetAltCollSeq(void *Ptr) { keyDef.SetAltCollSeq(Ptr); }

	// use standard Alternate Collating Sequence 'UPPER.ALT'
	void SetUpperAlt(void) { keyDef.SetUpperAlt(); }

	// create the database file
	int CreateBtrieve(char *FName, int mode=0);
    };

#endif