/*//////////////////////////////////////////////////////////////////////////
///            ___                                                       ///
///          /_____\                                                     ///
///         |       |                 Copyright (c) 1991                 ///
///         |   R   |                                                    ///
///     ----|_______|----                     by                         ///
///   /------/ | | \------\                                              ///
///  |       | | | |       |      --  Object Resource Group  --          ///
///  |   O   | | | |   G   |                                             ///
///  |       |/   \|       |          4323 Brown Suite 249               ///
///   -------       -------            Dallas,  TX  75219                ///
///   Object Resource Group                                              ///
///                                      (214) 528-2745                  ///
///                                                                      ///
///                                    All Rights Reserved.              ///
///                                                                      ///
//////////////////////////////////////////////////////////////////////////*/

#if !defined(TUTOR_HPP)
#define TUTOR_HPP


enum Boolean {False, True};

struct Address
   {
   char street[26];
   char city[21];
   char state[3];
   char zip[12];	// only 11 needed but keep even boundary
   };


struct Person
   {
   // key 0
   unsigned long id;	//unique for each person - maps to other objects

   // key 1
   char name[26];	// lastname, first

   Address shipAddress;
   };



class PersonDataSet : public BT_DataSet
   {
public:
   BT_Key *key;	// yuch - never make variables public unless doing simple
		// tutorials

   PersonDataSet() : BT_DataSet("person.tbt") {}
   ~PersonDataSet() {}

   int Menu();
   int Add();
   int Modify();
   int List();
   };


struct Item
   {
   // key 0
   unsigned itemNumber;		// unique for each item
   char description[36];
   double unitCost;
   };


class ItemDataSet : public BT_DataSet
   {
public:
   BT_Key *key;	// yuch - never make variables public unless doing simple
		// tutorials

   ItemDataSet() : BT_DataSet("item.tbt") {}
   ~ItemDataSet() {}

   int Menu();
   int Add();
   int Modify();
   int List();
   };


struct OrderItem
   {
   // key 0
   char orderNumber[10];		// maps to purchase order

   unsigned itemNumber;		// maps to item
   double quantity;		// amount ordered
   double purchaseCost;		// cost at time of order
   };


class OrderItemDataSet : public BT_DataSet
   {
public:
   BT_Key *key;	// yuch - never make variables public unless doing simple
		// tutorials
   ItemDataSet itemDS;

   OrderItemDataSet() : BT_DataSet("o_item.tbt") {}
   ~OrderItemDataSet() {}

   int Add(const char *orderNumber);
   };



struct Order
   {
   // key 0
   char number[10];		// unique for each Order

   unsigned long personID;	//person who called in order

   // key 1 - manual key with paidFlag
   char dateOrdered[8];		// YYMMDD - there are better but this is
				// easier (sorry)
   Boolean paidFlag;		// True if paid
   };


class OrderDataSet : public BT_DataSet
   {
   PersonDataSet personDS;
   OrderItemDataSet orderItemDS;
public:
   BT_Key *key;	// yuch - never make variables public unless doing simple
		// tutorials

   OrderDataSet() : BT_DataSet("order.tbt") {}
   ~OrderDataSet() {}

   int Menu();
   int Add();
   int Modify();
   int List();
   int PrintOne();
   };




#endif
