/*//////////////////////////////////////////////////////////////////////////
///            ___                                                       ///
///          /_____\                                                     ///
///         |       |                 Copyright (c) 1991                 ///
///         |   R   |                                                    ///
///     ----|_______|----                     by                         ///
///   /------/ | | \------\                                              ///
///  |       | | | |       |      --  Object Resource Group  --          ///
///  |   O   | | | |   G   |                                             ///
///  |       |/   \|       |          4323 Brown Suite 249               ///
///   -------       -------            Dallas,  TX  75219                ///
///   Object Resource Group                                              ///
///                                      (214) 528-2745                  ///
///                                                                      ///
///                                    All Rights Reserved.              ///
///                                                                      ///
//////////////////////////////////////////////////////////////////////////*/

// definitions for classes used as examples
#if !defined(EXAMPLES_HPP)
#define EXAMPLES_HPP

#include <string.h>
#include "btdset.hpp"

// PersonDB is a "kind-of" BT_DataSet (or btrieve file)
// It adds the methods to dump its data
// It adds no new attributes
class PersonDB : public BT_DataSet
   {
   public:

   PersonDB(char *name) : BT_DataSet(name) {};
   int Dump();		// dump in key 0 order
   int ColorDump();	// create a supplemental key (based on color) and
			// dump in that order
   };

// ColorDB is a "kind-of" BT_DataSet (or btrieve file)
// It adds the methods to dump its data
// It adds no new attributes
class ColorDB : public BT_DataSet
   {
   public:

   ColorDB(char *name) : BT_DataSet(name) {};
   int Dump();                	//Dumps in color order
   int DumpFromHighestCount();	//Dumps in color order from highest count
   };

struct PersonData
   {
   char name[36];    		// person's name
   char colorPreference[26];	// user defined color shade
   };

class Person
   {
   PersonData data;
   PersonDB *personDB;		// connect to person's file

   public:

   // default constructor  - connects object to file
   Person(PersonDB *_personDB) : personDB(_personDB)
		{
		memset(data.name, '\0', 36);
		memset(data.colorPreference, '\0', 26);
		}

   // specialized constructor to set the name and do a lookup for the record
   Person(char *_name, PersonDB *personDB);

   // destructor - does nothing
   ~Person() {};

   // set the object's attributes
   void SetName(char *_name) { strncpy(data.name, _name, 35); }
   void SetColorPreference(char *_color) { strncpy(data.colorPreference,
						   _color, 25); }

  // get the object's attributes
   char *ColorPreference() { return data.colorPreference; }
   char *Name() { return data.name; }

   // file operations
   int Add();
   int GetRec();
   int Status() { return personDB->Status(); }
   };

struct ColorData
   {
   char shade[26];	// user defined color
   int prefCount;	// number of people with that preference
   };

class Color
   {
   ColorData data;
   ColorDB *colorDB;		// connect to color's file

   public:

   // default constructor to link object to file
   Color(ColorDB *_colorDB) : colorDB(_colorDB)
		{
		data.prefCount = 0;
		memset(data.shade, '\0', 26);
		}

   // specialized constructor to set the shade and do a lookup for the record
   Color(char *_name, ColorDB *colorDB);

   // destructor - does nothing
   ~Color() {};

   // set the object's attributes
   void SetShade(char *_color) { strncpy(data.shade, _color, 25); }
   void SetPrefCount(int _count) { data.prefCount = _count; }
   void IncPrefCount() { data.prefCount++; }

   // get the object's attributes
   char *Shade() { return data.shade; }
   int PreferenceCount() { return data.prefCount; }

   // file operations
   int Add();
   int Update();
   int GetRec();
   int Status() { return colorDB->Status(); }
   };

#endif