/*//////////////////////////////////////////////////////////////////////////
///                                                                      ///
///                         Copyright (c) 1991                           ///
///                                                                      ///
///                                 by                                   ///
///                                                                      ///
///                   --   Object Resource Group   --                    ///
///                                                                      ///
///                        4323 Brown Suite 249                          ///
///                         Dallas,  TX  75219                           ///
///                                                                      ///
///                           (214) 528-2745                             ///
///                                                                      ///
///                         All Rights Reserved.                         ///
///                                                                      ///
//////////////////////////////////////////////////////////////////////////*/


//
//  A small example program using the ORG Btrieve classes
//
//	program by Liming Yang
//

#include <iostream.h>
#include <stdlib.h>
#include <string.h>

/// ORG Btrieve class declarations ///

#include "btdset.hpp"
#include "btkey.hpp"
#include "btdef.hpp"



struct MY_REC            		///// Datafile record format
  {
  int recnum;               // key 0
  char text[32];            // key 1
  };


int InsertRecords(BT_DataSet &exampleDB);   // protos for this file
int PrintRecords(BT_DataSet &exampleDB);


////////////////////////////////////////////////////////////////////////
/////////////////////////////// MAIN ///////////////////////////////////
////////////////////////////////////////////////////////////////////////


    /////////// Btrieve shell is already running, right ? //////////

main()
    {
    int status;

    ///// First, create the database /////

    BT_Def sample(sizeof(MY_REC), 0);

    ///// Define the Keys /////

    status = sample.AddFinalKeySegment(1, 2, BKEY_MODIFIABLE, BTYPE_INTEGER);
    if (!status)
      {
      status = sample.AddFinalKeySegment(3, 32,
					 BKEY_MODIFIABLE+BKEY_DUPLICATE+
					 BKEY_ALT_SEQUENCE,
					 BTYPE_ZSTRING);
      if (!status)
	{
	///// set alternate collating sequence to the standard UPPER.ALT /////

	sample.SetUpperAlt();

	///// This actually creates the dataset /////

	status = sample.CreateBtrieve("example.db");
	if (!status)
	  {
	  ///// Declaring an instance opens the file /////
	  BT_DataSet exampleDB("example.db");
	  if (!(status=exampleDB.Status()))	// be sure it's open !!
	    {
	    status = InsertRecords(exampleDB);  // insert some records...
	    if (!status)
	      status = PrintRecords(exampleDB); // ...then print them out
	    }
	  }
	}
      }

    if (status)
      cout << "Error status: " << status << "\n";

    ///// The file is closed when the destructor is called /////
    }



////////////////////////////////////////////////////////////////////////
////////////////////////////// Insert //////////////////////////////////
////////////////////////////////////////////////////////////////////////


int InsertRecords(BT_DataSet &exampleDB)
    {
    int status;
    MY_REC rec;

    ///// Use key zero's access path /////
    BT_Key *num = exampleDB.GetKey(0);

    ///// Insert three records /////
    rec.recnum = 1;
    strcpy(rec.text, "The First Record");
    status = num->Insert(&rec);
    if (!status)
      {
      rec.recnum = 2;
      strcpy(rec.text, "The Second Record");
      status = num->Insert(&rec);
      if (!status)
	{
	rec.recnum = 3;
	strcpy(rec.text, "A Third and Longer Record");
	status = num->Insert(&rec);
	}
      }
    return (status);
    }



////////////////////////////////////////////////////////////////////////
////////////////////////////// Print ///////////////////////////////////
////////////////////////////////////////////////////////////////////////


int PrintRecords(BT_DataSet &exampleDB)
    {
    int status;
    MY_REC rec;

    ///// Key one access path /////
    BT_Key *num = exampleDB.GetKey(1);

    // Read through the file and print each record to screen /////
    status = num->GetFirst(&rec);
    while (!status)
      {
      cout << "Record number: " << rec.recnum << "\n";
      cout << "Text : " << rec.text << "\n\n";

      status = num->GetNext(&rec);
      }

    if (status==BSTAT_EOF)
      status = 0;            // end of file

    return (status);
    }
