/*//////////////////////////////////////////////////////////////////////////
///            ___                                                       ///
///          /_____\                                                     ///
///         |       |                 Copyright (c) 1991                 ///
///         |   R   |                                                    ///
///     ----|_______|----                     by                         ///
///   /------/ | | \------\                                              ///
///  |       | | | |       |      --  Object Resource Group  --          ///
///  |   O   | | | |   G   |                                             ///
///  |       |/   \|       |          4323 Brown Suite 249               ///
///   -------       -------            Dallas,  TX  75219                ///
///   Object Resource Group                                              ///
///                                      (214) 528-2745                  ///
///                                                                      ///
///                                    All Rights Reserved.              ///
///                                                                      ///
//////////////////////////////////////////////////////////////////////////*/

#if !defined(BTTRAN_HPP)
#define BTTRAN_HPP	1

#include <stddef.h>

extern "C"
{
#include "bt.h"
}

////////////////////  BTTRAN.HPP  /////////////////////

class BT_Transaction
	{
        //   Declaring an instance of this class will execute a
        //   Btrieve START TRANSACTION (check 'complete' for error code)
        //   When this object's destructor is called, the transaction
        //   will be aborted UNLESS Commit() is called first.  Commit()
        //   will execute an END TRANSACTION

	protected:

		int	complete;	// abort if 0, complete if -1,
					// else error code beginning trans
	public:

		// CONSTRUCTOR
		BT_Transaction();

		// DESTRUCTOR
		~BT_Transaction();

		// check return code from 'begin transaction' call
		int Status();

		// commit this transaction
		int Commit();

		// abort transaction...rollback data
		int RollBack();
	};


#endif
