/*//////////////////////////////////////////////////////////////////////////
///            ___                                                       ///
///          /_____\                                                     ///
///         |       |                 Copyright (c) 1991                 ///
///         |   R   |                                                    ///
///     ----|_______|----                     by                         ///
///   /------/ | | \------\                                              ///
///  |       | | | |       |      --  Object Resource Group  --          ///
///  |   O   | | | |   G   |                                             ///
///  |       |/   \|       |          4323 Brown Suite 249               ///
///   -------       -------            Dallas,  TX  75219                ///
///   Object Resource Group                                              ///
///                                      (214) 528-2745                  ///
///                                                                      ///
///                                    All Rights Reserved.              ///
///                                                                      ///
//////////////////////////////////////////////////////////////////////////*/

#ifndef BTSKDEF_HPP
#define BTSKDEF_HPP

#include "btkdef.hpp"

extern "C"
  {
  #include "bt.h"
  }

//////////////////  Class BT_KeyDef  /////////////////////

class BT_SuppKeyDef : BT_KeyDef
    {
	int finalCalled;	// prevents more than one key for action
    public:

	// CONSTRUCTOR
	BT_SuppKeyDef() : BT_KeyDef() { finalCalled = 0; }

	// add a key segment definition ... more segments to follow
	// redefined to prevent multiple keys
	int AddKeySegment(int Start, int Length, int Flags,
			   char KeyType, char NullVal=(char)0);

	// add a key segment definition ... NO segments to follow
	// redefined to prevent multiple keys
	int AddFinalKeySegment(int Start, int Length, int Flags,
			       char KeyType, char NullVal=(char)0);

	// Use to allow reuse of object
	void ClearSuppKey() { num_keyspecs = num_dupkeys = 0;
			      altcolseq[0] = '\0';
			      finalCalled = 0; }

    };

#endif