/*//////////////////////////////////////////////////////////////////////////
///            ___                                                       ///
///          /_____\                                                     ///
///         |       |                 Copyright (c) 1991                 ///
///         |   R   |                                                    ///
///     ----|_______|----                     by                         ///
///   /------/ | | \------\                                              ///
///  |       | | | |       |      --  Object Resource Group  --          ///
///  |   O   | | | |   G   |                                             ///
///  |       |/   \|       |          4323 Brown Suite 249               ///
///   -------       -------            Dallas,  TX  75219                ///
///   Object Resource Group                                              ///
///                                      (214) 528-2745                  ///
///                                                                      ///
///                                    All Rights Reserved.              ///
///                                                                      ///
//////////////////////////////////////////////////////////////////////////*/

#if !defined(BTBUFF_HPP)
#define BTBUFF_HPP	1

//////////////////////////// CLASS BTBUFF /////////////////////////

class BT_Buff
	{
	friend class BT_DataSet;
	friend class BT_Key;
        //   This class is handy to use as a base class for specific
        //   record structures...or, if using variable length records,
        //   you may want to have a BT_Buff long enough for the maximum
        //   length record (cf. BT_DataSet class)

	protected:
		void *buffer;		// pointer to actual buffer
		int   bufflen;		// length of buffer in bytes
		int   datalen;		// length of DATA in buffer

		void *BuffAddr()   { return buffer; }
		int  *LenAddr()    { return &datalen; }
		void  SetDataMax() { datalen = bufflen; }

	public:
                // CONSTRUCTORS
                //   Start with no buffer allocated
		BT_Buff()	{ buffer=0; datalen=bufflen=0; }
                //   Allocate buffer of given length
		BT_Buff(int Length);
                //   Use buffer provided by the user.  NOTE: The BT_Buff
                //   object now owns the memory...it will be freed when
                //   the BT_Buff object destructor is called.
		BT_Buff( void *buff, int Length )
			{
			buffer = buff;
			datalen = bufflen = Length; // assumption!
			}

		// DESTRUCTOR
		~BT_Buff()	{ delete buffer; }

		//   Copy data into existing buffer.  No data will be
                //   copied past the buffer's end even if 'DLth' is
                //   longer than the buffer.
		int SetBufferData(const void *Data, int DLth);

		//   Fills buffer with data from user buffer.  'bufflen'
                //   bytes are copied from 'Data' to object's buffer
		void FillBuffer(const void *Data);

		//   Copy data from buffer to user's buffer...using the
                //   object's datalen for the number of bytes to copy,
                //   but no more that 'Lth'
		int GetBufferData(void *UserBuff,int Lth);

		//   Set object's buffer to a new length.  No data is
                //   retained in the new buffer.
		virtual int SetBuffer(int Length);

		//   Sets object buffer to 'Data' and bufflen and datalen to
                //   'DLth'.  Destructor will free the buffer!!
		virtual int SetBuffer(void *Data, int DLth);

		//   Get Length of Data in Buffer
		int DataLen() { return datalen; }

                //   Get Length of Object's Buffer
                int BuffLen() { return bufflen; }
	};


#endif
