/*//////////////////////////////////////////////////////////////////////////
///                                                                      ///
///                         Copyright (c) 1991                           ///
///                                                                      ///
///                                 by                                   ///
///                                                                      ///
///                   --   Object Resource Group   --                    ///
///                                                                      ///
///                        4323 Brown Suite 249                          ///
///                         Dallas,  TX  75219                           ///
///                                                                      ///
///                           (214) 528-2745                             ///
///                                                                      ///
///                         All Rights Reserved.                         ///
///                                                                      ///
//////////////////////////////////////////////////////////////////////////*/
/*
BT.H	Header with Btrieve defines & stuff

History:
     APRIL, 90	Chuck McWilliam
     JUNE, 90   Liming Yang      Additional Op Codes for 5.0 added
     AUGUST, 90 Chuck McWilliam  Revised Prototypes
                                 Added 5.1 Op Codes
                                 Added more error code defines
*/
#if !defined(BT_H)
#define BT_H

#if !defined(ULONG)
#define ULONG unsigned long
#endif

/* Btrieve Operation Codes */

#define BT_OPEN		0
#define BT_CLOSE	1
#define BT_INSERT	2
#define BT_UPDATE	3
#define BT_DELETE	4
#define BT_GET_EQUAL	5
#define BT_GET_NEXT	6
#define BT_GET_PREV	7
#define BT_GET_GREAT	8
#define BT_GET_GREAT_EQ	9
#define BT_GET_LESS	10
#define BT_GET_LESS_EQ	11
#define BT_GET_FIRST	12
#define BT_GET_LAST	13
#define BT_CREATE	14
#define BT_STAT		15
#define BT_EXTEND	16
#define BT_SET_DIR	17
#define BT_GET_DIR	18
#define BT_BEGIN_TRAN	19
#define BT_END_TRAN	20
#define BT_ABORT_TRAN	21
#define BT_GET_POSITION 22
#define BT_GET_DIRECT	23
#define BT_STEP_DIRECT	24
#define BT_STOP		25
#define BT_VERSION	26
#define BT_UNLOCK	27
#define BT_RESET	28
#define BT_SET_OWNER	29
#define BT_CLEAR_OWNER	30
#define BT_CREATE_IDX   31
#define BT_DROP_IDX	32
#define BT_STEP_FIRST	33
#define BT_STEP_LAST	34
#define BT_STEP_PREV	35
#define BT_GET_NEXT_X   36
#define BT_GET_PREV_X   37
#define BT_STEP_NEXT_X  38
#define BT_STEP_PREV_X  39
#define BT_INSERT_X     40
#define BT_GET_KEY      50      /* Used with other GET operations */
#define BT_SINGLE_WAIT 100      /* Single record Wait Lock */
#define BT_SINGLE_NOWAIT 200    /* Single record NoWait Lock */
#define BT_MULTIPLE_WIAT 300    /* Multiple record Wait Lock */
#define BT_MULTIPLE_NOWAIT 400  /* Multiple record NoWait Lock */
#define BT_TRAN_NOWAIT  219

/* Btrieve Status Codes (not complete) */

#define BSTAT_INVAL	1
#define BSTAT_IO	2
#define BSTAT_NOT_OPEN	3
#define BSTAT_NOTFOUND  4
#define BSTAT_DUP_KEY   5
#define BSTAT_INVAL_KEY 6
#define BSTAT_DIFF_KEY  7
#define BSTAT_INVAL_POS 8
#define BSTAT_EOF	9
#define BSTAT_KEYVAL	10
#define BSTAT_INV_FNAME 11
#define BSTAT_NOFILE	12
#define BSTAT_EXT_ERR	13
#define BSTAT_PRE_OPEN	14
#define BSTAT_PRE_IO	15
#define BSTAT_EXPANSION 16
#define BSTAT_CLOSE	17
#define BSTAT_DISKFULL	18
#define BSTAT_FATAL	19
#define BSTAT_NO_SHELL	20
#define BSTAT_BUFF_TOO_SHORT 22
#define BSTAT_TOO_MANY_KEYS 26
#define BSTAT_NULL_KEY_PATH 44
#define BSTAT_DENIED	46
#define BSTAT_INVAL_KEYTYPE 49
#define BSTAT_BAD_OWNER    51
#define BSTAT_INCOMPLETE_IDX 56
#define BSTAT_EXISTS    59
#define BSTAT_REJECT_COUNT 60
#define BSTAT_SMALL_SPACE 61
#define BSTAT_DESCRIPTOR 62
#define BSTAT_INSERT_BUFFER 63
#define BSTAT_MAXFILTER 64
#define BSTAT_BAD_OFFSET 65
#define BSTAT_DEADLOCK  78
#define BSTAT_AUTOABORT 74
#define BSTAT_CONFLICT  80
#define BSTAT_LOCK_ERR  81
#define BSTAT_LOST_POSITION 82
#define BSTAT_READ_OUTSIDE 83
#define BSTAT_REC_INUSE 84
#define BSTAT_F_INUSE   85
#define BSTAT_MAXFILES  86
#define BSTAT_MAXHANDLE 87
#define BSTAT_OPENMODE  88
#define BSTAT_MAXDEVICE 90
#define BSTAT_NOSERVER  91
#define BSTAT_MAXTRANS  92
#define BSTAT_LOCK_TYPE 93
#define BSTAT_PERMISSION 94
#define BSTAT_NOSESSION 95
#define BSTAT_COMM_ENV  96
#define BSTAT_TOO_SMALL 97
#define BSTAT_TTS_INTERNAL 98

/* Prototype for Btrieve interface */

int BTRV( int,	        /* the Btrieve command */
	  void *,       /* pointer to 128 byte position block */
	  void *,       /* pointer to data buffer */
	  int *,	/* POINTER to int containing size of data buff */
	  void *,	/* pointer to KEY buffer */
	  int     );	/* number of index to use */

/* Structures/define's used for CREATE */

#define MAX_KEY_SPECS 24

struct BT_FileStat	/* File specifications returned from 'stat' -- op 15 */
    {
    int		  recLength;
    int		  pageSize;
    int		  indices;
    unsigned long records;
    unsigned	  flags;
    int		  reserved;
    int		  pages;
    };

struct BT_KeyStat	/* Key segment specs returned from 'stat' */
    {
    int		Position;
    int		Length;
    unsigned	Flags;
    unsigned long Number;
    char	ExtendedType;
    char	NullValue;
    int         Reserved1;
    int		Reserved2;
    };


#define BTF_FILE_OPEN   0x0001
#define BTF_USER_BUFFER 0x0010
const BTF_FILE_STAT_SIZE = sizeof(BT_FileStat)+((sizeof(BT_KeyStat))*24);

/*   extended status     */
enum ExtStatus {BT_OK, BT_ERROR, BT_NO_MEMORY, BT_MULT_SUPP_KEYS};

typedef struct BtrieveKeySpec	/* used to define a key */
  {
  int  position,	/* starting position in record */
       length,		/* length of key/segment */
       flags;		/* cf. define's */
  char unused[4],	/* set to zero */
       keytype,		/* extended key type cf. define's */
       nullval,         /* null value for null or manual key */
       reserved[4];	/* init to zero */
  } KEYSPEC;

/* Values for key spec flags */

#define BKEY_DUPLICATE		1
#define BKEY_MODIFIABLE		2
#define BKEY_BINARY		4
#define BKEY_NULL		8
#define BKEY_SEGMENTED		16
#define BKEY_ALT_SEQUENCE	32
#define BKEY_DESCENDING		64
#define BKEY_SUPPLEMENTAL	128
#define BKEY_EXTENDED		256
#define BKEY_MANUAL		512

/* mask for key values that, if defined, must be defined for all segments */
#define BKEY_MASK BKEY_DUPLICATE+BKEY_MODIFIABLE+BKEY_NULL+BKEY_SUPPLEMENTAL+BKEY_MANUAL
/* extended key type values */

#define BTYPE_STRING		0
#define BTYPE_INTEGER		1
#define BTYPE_FLOAT		2
#define BTYPE_DATE		3
#define BTYPE_TIME		4
#define BTYPE_DECIMAL		5
#define BTYPE_MONEY		6
#define BTYPE_LOGICAL		7
#define BTYPE_NUMERIC		8
#define BTYPE_BFLOAT		9
#define BTYPE_LSTRING		10
#define BTYPE_ZSTRING		11
#define BTYPE_UNSIGNED		14
#define BTYPE_AUTOINCREMENT	15

typedef struct BtrieveFileSpec	/* file specs..place in data buffer */
  {
  int     reclength,	/* recored length */
	  pagesize,	/* page size */
	  idxcount;	/* set to 0 for a data-only file */
  char    unused[4];	/* fill with zeroes */
  int     flags;	/* cf. define's */
  char    reserved[2];	/* init to zeroes */
  int     prealloc;	/* set if preallocation flag is set */
  KEYSPEC key;		/* first key */
  } FILESPEC;

/* Values for file spec flags */

#define BFILE_VAR_LTH		1
#define BFILE_BLANK_TRUNC	2
#define BFILE_PREALLOC		4
#define BFILE_COMPRESS		8
#define BFILE_KEY_ONLY		16
#define BFILE_10_FREE		64
#define BFILE_20_FREE		128
#define BFILE_30_FREE		192

/*-------------------------Used by Status------------------------------*/


/*--------------------------Prototypes---------------------------------*/

int BT_ReadAlt(char*,char*);
int BT_CreateDatabase( void **, int);
void BT_InitFileSpec(FILESPEC*,int,int,int,int,int);
void BT_InitKeyNull(KEYSPEC*,int,int,int,char,char);

#define BT_InitKey(kspec, pos, len, flag, xtype) BT_InitKeyNull(kspec, pos, len, flag, xtype, 0)

#endif
