#ifndef BPTIncluded
#define BPTIncluded

// copyright (c) 1992, 1994 by Paul Wheaton, Banana Programming
// 1916 Brooks #205, Missoula, MT  59801
//
//       phone:  (406)543-1928
//  CompuServe:  72707,207
//    Internet:  banana@montana.com
//         BBS:  (406)543-8234 (The Montana Banana BBS)

#include <string.h>
#include <stdlib.h>
#include <bios.h>
#include <dos.h>
#include <stddef.h>
#include <stdio.h>
#include <io.h>
#include <dir.h>

#ifndef __BCPLUSPLUS__
  #error compilers other than BC++ 3.1 - delete this line and yer on yer own
  // we will attempt ports to other compilers at another time
#endif

#if (__BCPLUSPLUS__ > 0x310)
  #error versions later than BC++ 3.1 - delete this line and yer on yer own
  // we will attempt ports to later versions at another time
#endif

typedef          char  Bool;
typedef unsigned char  Byte;
typedef signed   char  SByte;
typedef unsigned short Word;
typedef signed   short SWord;
typedef unsigned long  Long;
typedef unsigned long  ULong;
typedef signed   long  SLong;
typedef unsigned int   UInt;

typedef char* CharStar;  // has to be fed to some macros

const char  MaxChar  = 127;
const Byte  MaxByte  = 255;
const SByte MaxSByte = 127;
const SByte MinSByte = (-128);
const Word  MaxWord  = 0xFFFF;
const SWord MaxSWord = 32767;
const SWord MinSWord = (SWord) 0x8000; // (-32768);
const IntLen=sizeof(int);
#if IntLen==2
  #ifndef MaxInt
    const int   MaxInt   = 32767;
  #endif
  const int   MinInt   = (SWord) 0x8000;  // (-32768);
  const UInt  MaxUInt  = 0xFFFF;
#else
  const int   MaxInt   = 0x7FFFFFFFL; // 2147483647;
  const int   MinInt   = (-2147483648L);  // 0x80000000L;
  const UInt  MaxUInt  = 0xFFFFFFFFL;
#endif
const SLong MaxSLong = 0x7FFFFFFFL; // 2147483647;
const Long  MaxLong  = 0xFFFFFFFFL;
const SLong MinSLong = (SLong)(0x80000000L); // (-2147483648L);

const long AMillion=1000000L;
const long ABillion=1000000000L;

const Bool True  = 1;
const Bool False = 0;
const Bool Yes   = 1;
const Bool No    = 0;
const Bool On    = 1;
const Bool Off   = 0;

/* the following have values < 0 so that they may be used as alternatives to
   text placement rountines that need positive values */

const int Left=(MinInt+1);
const int Center=(MinInt+2);
const int Right=(MinInt+3);

const int NotFound=-1;  // returned by several search functions

inline SByte  Abs(SByte  x)  { return x >= 0 ? x : -x; }
inline SWord  Abs(SWord  x)  { return x >= 0 ? x : -x; }
inline int    Abs(int    x)  { return x >= 0 ? x : -x; }
inline SLong  Abs(SLong  x)  { return x >= 0 ? x : -x; }
inline float  Abs(float  x)  { return x >= 0 ? x : -x; }
inline double Abs(double x)  { return x >= 0 ? x : -x; }

inline Byte   Max(Byte   a, Byte   b) { return a >= b ? a : b; }
inline SByte  Max(SByte  a, SByte  b) { return a >= b ? a : b; }
inline Word   Max(Word   a, Word   b) { return a >= b ? a : b; }
inline SWord  Max(SWord  a, SWord  b) { return a >= b ? a : b; }
inline int    Max(int    a, int    b) { return a >= b ? a : b; }
inline int    Max(int    a, char   b) { return a >= b ? a : b; }
inline int    Max(char   a, int    b) { return a >= b ? a : b; }
inline UInt   Max(UInt   a, UInt   b) { return a >= b ? a : b; }
inline Long   Max(Long   a, Long   b) { return a >= b ? a : b; }
inline SLong  Max(SLong  a, SLong  b) { return a >= b ? a : b; }
inline double Max(double a, double b) { return a >= b ? a : b; }

inline Byte   Min(Byte   a, Byte   b) { return a <= b ? a : b; }
inline SByte  Min(SByte  a, SByte  b) { return a <= b ? a : b; }
inline Word   Min(Word   a, Word   b) { return a <= b ? a : b; }
inline SWord  Min(SWord  a, SWord  b) { return a <= b ? a : b; }
inline int    Min(int    a, int    b) { return a <= b ? a : b; }
inline int    Min(char   a, int    b) { return a <= b ? a : b; }
inline int    Min(int    a, char   b) { return a <= b ? a : b; }
inline UInt   Min(UInt   a, UInt   b) { return a <= b ? a : b; }
inline Long   Min(Long   a, Long   b) { return a <= b ? a : b; }
inline SLong  Min(SLong  a, SLong  b) { return a <= b ? a : b; }
inline double Min(double a, double b) { return a <= b ? a : b; }

inline Bool InRange(Byte   Val, Byte   Low, Byte   High)
  {return((Val>=Low) && (Val<=High));}
inline Bool InRange(SByte  Val, SByte  Low, SByte  High)
  {return((Val>=Low) && (Val<=High));}
inline Bool InRange(Word   Val, Word   Low, Word   High)
  {return((Val>=Low) && (Val<=High));}
inline Bool InRange(SWord  Val, SWord  Low, SWord  High)
  {return((Val>=Low) && (Val<=High));}
inline Bool InRange(int    Val, int    Low, int    High)
  {return((Val>=Low) && (Val<=High));}
inline Bool InRange(int    Val, char   Low, char   High)
  {return((Val>=Low) && (Val<=High));}
inline Bool InRange(int    Val, char   Low, int    High)
  {return((Val>=Low) && (Val<=High));}
inline Bool InRange(int    Val, int    Low, char   High)
  {return((Val>=Low) && (Val<=High));}
inline Bool InRange(char   Val, int    Low, int    High)
  {return((Val>=Low) && (Val<=High));}
inline Bool InRange(char   Val, char   Low, int    High)
  {return((Val>=Low) && (Val<=High));}
inline Bool InRange(char   Val, int    Low, char   High)
  {return((Val>=Low) && (Val<=High));}
inline Bool InRange(UInt   Val, UInt   Low, UInt   High)
  {return((Val>=Low) && (Val<=High));}
inline Bool InRange(Long   Val, Long   Low, Long   High)
  {return((Val>=Low) && (Val<=High));}
inline Bool InRange(SLong  Val, SLong  Low, SLong  High)
  {return((Val>=Low) && (Val<=High));}
inline Bool InRange(double Val, double Low, double High)
  {return((Val>=Low) && (Val<=High));}
inline Bool InRange(long double Val, long double Low, long double High)
  {return((Val>=Low) && (Val<=High));}

inline long Round(double Val)     // .2 => 0  .7 => 1  -.2 => 0   -.7 => -1
  {return long((Val<0.0)?(Val-0.5):(Val+0.5));}
inline long RoundUp(double Val)   // .2 => 1  .7 => 1  -.2 => 0   -.7 => 0
  {return long((Val<0.0)?(Val):(Val+1.0));}
inline long RoundDown(double Val) // .2 => 0  .7 => 0  -.2 => -1  -.7 => -1
  {return long((Val<0.0)?(Val-1.0):(Val));}
inline long RoundOut(double Val)  // .2 => 1  .7 => 1  -.2 => -1  -.7 => -1
  {return long((Val<0.0)?(Val-1.0):(Val+1.0));}
inline long RoundIn(double Val)   // .2 => 0  .7 => 0  -.2 => 0   -.7 => 0
  {return long(Val);}

void pascal PigeonHole(long TotQuan, int ArrayLen, int A[]);
  // spreads TotQuan as evenly as possible over A

inline long SystemTick() {return biostime(0,0);}
  // returns the current BIOS system tick

// the following functions take care of passing midnight

extern long MaxTick;//=1573040L;
extern double TicksPerSec;//=1573040.0/86400.0; // (MaxTicks/secs in a day)

// you are allowed 8 tickers numbered 0 to 7
void pascal StartTickCount(int Ticker=0);
long pascal Ticks(int Ticker=0);    // number of Ticks since StartTickCount();
double pascal Seconds(int Ticker=0);  // number of Seconds since StartTickCount();

#ifndef MAJORBBS

  void pascal Delay(int MilliSecs);
  void pascal InitDelay();
    // Delay will automatically init itself if not already done, but this will
    // cost about 200 ms.

  void pascal Sound(double Pitch,int MilliSecs);
    // a little bit of control over the pc speaker

  void pascal Beep(int Num=1);
    // Num is the number of beeps ya want

#endif

union BitwiseCopy
  {
    long  L;
    ULong UL;
    int   I;
    int   IA[2];
    UInt  UI;
    UInt  UIA[2];
    char  C;
    char  CA[4];
    Byte  B;
    Byte  BA[4];
  };

const char CR=13;
const char LF=10;
const char FF=12;
extern const char* CRLF; // ={CR,LF,0};

#define CopyArray(Dest,Source) memcpy(Dest,Source,sizeof(Dest))
  // Dest must be something that sizeof will work on

#define ClearStruct(A) memset((void*)(&A),0,sizeof(A))
  // fill a struct with zeros

#define ClearArray(A) memset(A,0,sizeof(A))
  /* fill an array with zeros.  Array must be defined so that sizeof will
     work on it */

// Given these objects, standard CRC16 will be calculated
Word pascal CRC(void* P,Long Size);
Word pascal CRC(const char* S);

#define Loop while(1)
  // structure for an infinite loop

#define For(TheVar,TheEnd)  for(TheVar=0;TheVar<TheEnd;++TheVar)
  // Makes for a simpler, more readable, less error prone loop.
  // Use  "For(I,10)" instead of "for(I=0;I<10;I++)"

typedef void (* VoidFuncPtr)(void);
typedef Bool (* BoolFuncPtr)(void);
typedef void (* VoidFuncCharPtr)(char);

void pascal BigMemCopy(void* Dest, const void* Source, long Size);

char* pascal MallocAndCopy(const char* S);
  // malloc just enough space for S and a null terminator.  must use "free()"!

void pascal FatalError(const char*);

////  String stuff ////////////////////////////////////////////////////////

#define DefaultStringExtra    15
  /*  used internally by "String". Since most strings are very small yet
  will have a little bit more added to them, this extra allocation should
  save quite a bit of time.  The only time it would be a hendrance is when
  an array of strings is created */

class String;
class StackString;
class String40;
class String120;

class BaseString
  {
    protected:
      char* P;   // character string
      int Len;   // Length of string, excluding null character
      int Alloc; // amount of actual storage allocated (including null char)
      friend String;
      friend StackString;
      friend String40;
      friend String120;
    public:
      operator const char*() const {return P;}
      char& pascal operator[](int Index);
      Bool operator<(const BaseString& S) const { return strcmp(P, S.P) < 0; }
      Bool operator>(const BaseString& S) const { return strcmp(P, S.P) > 0; }
      Bool operator<=(const BaseString& S) const { return strcmp(P, S.P) <= 0; }
      Bool operator>=(const BaseString& S) const { return strcmp(P, S.P) >= 0; }
      Bool pascal operator==(const BaseString& S) const;
      Bool operator!=(const BaseString& S) const { return !(*this==S); }

      Bool operator<(const char* CS)  const { return strcmp(P,CS) < 0; }
      Bool operator>(const char* CS)  const { return strcmp(P,CS) > 0; }
      Bool operator<=(const char* CS) const { return strcmp(P,CS) <= 0; }
      Bool operator>=(const char* CS) const { return strcmp(P,CS) >= 0; }
      Bool operator==(const char* CS) const { return strcmp(P,CS) == 0; }
      Bool operator!=(const char* CS) const { return strcmp(P,CS) != 0; }

      friend Bool operator<(const char* cs, const BaseString& S)
        { return strcmp(cs, (S.P)) < 0; }
      friend Bool operator>(const char* cs, const BaseString& S)
        { return strcmp(cs, (S.P)) > 0; }
      friend Bool operator<=(const char* cs, const BaseString& S)
        { return strcmp(cs, (S.P)) <= 0; }
      friend Bool operator>=(const char* cs, const BaseString& S)
        { return strcmp(cs, (S.P)) >= 0; }
      friend Bool operator==(const char* cs, const BaseString& S)
        { return strcmp(cs, (S.P)) == 0; }
      friend Bool operator!=(const char* cs, const BaseString& S)
        { return strcmp(cs, (S.P)) != 0; }

      int Length() const { return Len; }
      void pascal ToLower();  // force all of the string to lower case
      void pascal ToUpper();  // force all of the string to upper case
      int Capacity() const { return Alloc - 1; }
      int pascal Index(char SearchChar, int StartIndex=0) const;
      int pascal Index(const char* SearchStr, int StartIndex=0) const;
      Bool Find(char SearchChar, int StartIndex=0) const
          {return (Index(SearchChar,StartIndex)!=NotFound);}
      Bool Find(const char* SearchStr, int StartIndex=0) const
          {return (Index(SearchStr,StartIndex)!=NotFound);}
      int pascal Count(char C) const;  // how many of this character occur

      void pascal Delete(int StartIndex=0,int DelQuan=1);
      void DeleteFirst(int DelQuan=1){Delete(0,DelQuan);}
      void pascal DeleteLast();    // a little bit faster than Delete()
      void pascal DeleteLast(int DelQuan);
      void pascal Trim();  //   chop off leading and trailing spaces
      void pascal TrimLead();
      void pascal TrimTrail();
      void pascal TrimTrailTo(char C);
        // remove last chars until C is found, then remove C too!

      char pascal At(int CharIndex) const;
      char operator()(int CharIndex) const {return At(CharIndex);}
      char pascal Last() const; // the last char in the string
      void pascal Clip(int NewLen);  // chop off the right end of the string if there

      String40 pascal Word(int Num=0) const;
        // using spaces as delimiters, pull out word number 0, 1, 2, etc.
      String40 pascal XWord(int Num=0);
        // same as Word except that the Word is extracted from the original string
      String40 pascal LastWord() const;
      String40 pascal XLastWord();

      #ifdef MAJORBBS
        void* operator new(size_t size){return malloc(size);}
        void  operator delete(void* p) {free(p);}
      #endif
  };

class String: public BaseString
  {
    protected:
      void pascal ReNew(int NewCapacity);
      void pascal New(); // Uses Alloc
    public:
      pascal String(const char& C, int Length=1);
        // String S(' ',20) constructs a string consisting of 20 spaces
      pascal String(int AllocSize);
        // constructor based on size desired
      pascal String(const char*);
        // a char* type string is used to construct a String type string
      pascal String(const BaseString&);
        // creating one String from another
      pascal String(const String&);
      pascal String();
      ~String() {free(P);}

      // assignment operators
      void pascal operator=(const BaseString&);
      void pascal operator=(const char*);
      void pascal operator=(const char);

      // String concatination (S1=S2+S3)
      // String operator+(const StackString& S) const;
      String pascal operator+(const String40& S) const;
      String pascal operator+(const String120& S) const;
      String pascal operator+(const String&) const;
      String pascal operator+(const char*) const;
      String pascal operator+(char C) const;
      friend String pascal operator+(const String40&, const String&);
      friend String pascal operator+(const String120&, const String&);
      friend String pascal operator+(const char* CS, const String& S);
      friend String pascal operator+(char C, const String& S);

      // Appending stuff to a String
      void pascal operator+=(const BaseString&);
      void pascal operator+=(const char*);
      void pascal operator+=(char);

      void pascal Left(int NewSize);  //  resize string and left justify text
      void pascal Right(int NewSize);
      void pascal Center(int NewSize);
      void pascal Just(int Type, int NewSize);
        //  parses out to Left, Right or Center
      void pascal Tail(int NewSize); // works like "Right" cept left chars may be chopped

      int pascal ReAlloc(int NewCapacity);
      String pascal At(int Pos, int Quan) const;
      String operator()(int Pos, int Quan) const {return At(Pos,Quan);}
      char   At(int Pos) const {return BaseString::At(Pos);}
      char   operator()(int Pos) const {return BaseString::At(Pos);}
      String Before(int Pos) const {return At(0,Pos);}
      String Through(int Pos) const {return At(0,Pos+1);}
      String From(int Pos) const {return At(Pos,Len-Pos);}
      String After(int Pos) const {return At(Pos+1,Len-Pos-1);}

      void pascal Insert(char C,int Index=0);
      void pascal Insert(const char* St,int Index=0);
      void pascal Replace(const char* SearchStr, const char* ReplaceStr);
      void pascal Replace(const char SearchChar, const char* ReplaceStr);
      void pascal Replace(const char* SearchStr, const char ReplaceChar);
      void pascal Replace(const char SearchChar, const char ReplaceChar);
  };

class StackString: public BaseString
  {
    protected:
      friend String;
    public:
      void pascal operator=(const BaseString&);
      void pascal operator=(const char*);
      void pascal operator=(const char);

      void pascal operator+=(const BaseString&);
      void pascal operator+=(const char*);
      void pascal operator+=(char);

      void pascal Left(int NewSize);  //  resize string and left justify text
      void pascal Right(int NewSize);
      void pascal Center(int NewSize);
      void pascal Just(int Type, int NewSize);
      void pascal Tail(int NewSize); // works like "Right" cept left chars may be chopped

      void pascal Sub(StackString& D, int Index, int Length);

      void pascal Insert(char C,int Index=0);
      void pascal Insert(const char* St,int Index=0);
  };

class String40: public StackString
  {
    protected:
      char Buf[41];
      friend String;
    public:
      pascal String40();
      pascal String40(const char& C, int Length=1);
      pascal String40(const char*);
      pascal String40(const BaseString&);
      pascal String40(const String40&);

      String40 pascal operator+(const String40& S) const;
      String40 pascal operator+(const char* S) const;
      String40 pascal operator+(char C) const;
      friend String40 pascal operator+(const char* S1, const String40& S2);
      friend String40 pascal operator+(char C, const String40& S);

      String40 pascal At(int Pos, int Quan) const;
      String40 operator()(int Pos, int Quan) const {return At(Pos,Quan);}
      char   At(int Pos) const {return BaseString::At(Pos);}
      char   operator()(int Pos) const {return BaseString::At(Pos);}
      String40 Before(int Pos) const {return At(0,Pos);}
      String40 Through(int Pos) const {return At(0,Pos+1);}
      String40 From(int Pos) const {return At(Pos,Len-Pos);}
      String40 After(int Pos) const {return At(Pos+1,Len-Pos-1);}
      void pascal Replace(const char* SearchStr, const char* ReplaceStr);
      void pascal Replace(const char SearchChar, const char* ReplaceStr);
      void pascal Replace(const char* SearchStr, const char ReplaceChar);
      void pascal Replace(const char SearchChar, const char ReplaceChar);
  };

class String120: public StackString
  {
    protected:
      char Buf[121];
      friend String;
    public:
      pascal String120();
      pascal String120(const char& C, int Length=1);
      pascal String120(const char*);
      pascal String120(const BaseString&);
      pascal String120(const String120&);

      String120 pascal operator+(const String40& S) const;
      String120 pascal operator+(const String120& S) const;
      String120 pascal operator+(const char* S) const;
      String120 pascal operator+(char C) const;
      friend String120 pascal operator+(const String40& S1, const String120& S2);
      friend String120 pascal operator+(const char* S1, const String120& S2);
      friend String120 pascal operator+(char C, const String120& S);

      String120 pascal At(int Pos, int Quan) const;
      String120 operator()(int Pos, int Quan) const {return At(Pos,Quan);}
      char   At(int Pos) const {return BaseString::At(Pos);}
      char   operator()(int Pos) const {return BaseString::At(Pos);}
      String120 Before(int Pos) const {return At(0,Pos);}
      String120 Through(int Pos) const {return At(0,Pos+1);}
      String120 From(int Pos) const {return At(Pos,Len-Pos);}
      String120 After(int Pos) const {return At(Pos+1,Len-Pos-1);}
      void pascal Replace(const char* SearchStr, const char* ReplaceStr);
      void pascal Replace(const char SearchChar, const char* ReplaceStr);
      void pascal Replace(const char* SearchStr, const char ReplaceChar);
      void pascal Replace(const char SearchChar, const char ReplaceChar);
  };

String   pascal Str(long);  //  convert integers to plain, unformatted strings
String40 pascal Str40(long);  //  convert integers to plain, unformatted strings
String   pascal CommaStr(long);
String40 pascal CommaStr40(long);
String   pascal MoneyStr(long Pennies); // 1234567 comes back as "12,345.67"
String40 pascal MoneyStr40(long Pennies);
String40 pascal DStr(double Num); // very slow yet works outside of long range
//String40 pascal HexStr(Long Num);
//String40 pascal OctalStr(Long Num);
String   pascal Form(const char* Format,double Val);
String   pascal Form(int FLen,SLong Val);
  // will someday be much faster than using double
String   pascal Form(int FLen,const double& Val);
String   pascal Form(int FLen,const Long& Val);
String   pascal Form(int FLen,const float& Val);
inline String Form(int FLen,const int& Val){return Form(FLen,double(Val));}

String pascal StringOf(int HowMany, char What);
String pascal Spaces(int HowMany);

String pascal LeftText(const char* CS, int NewSize);
String pascal RightText(const char* CS, int NewSize);
String pascal CenterText(const char* CS, int NewSize);
String pascal JustText(const char* CS, int Type, int NewSize);
String pascal TailText(const char* CS, int NewSize);
String pascal Trim(const char* S);
String pascal TrimLead(const char* S);
String pascal TrimTrail(const char* S);
inline String ToLower(const char* S){String St=S; St.ToLower(); return St;}
inline String ToUpper(const char* S){String St=S; St.ToUpper(); return St;}

String120 pascal SetFileExtension(const char* OrigName, const char* NewExtension);
String40  pascal FileExtension(const char*);  // returns empty string if no extension
char      pascal DriveLetter(const char*); // current drive returned if no drive specified
String120 pascal SetFileDrive(const char*);
String120 pascal FilePath(const char*);
String120 pascal FileDriveAndPath(const char*);
String120 pascal VerboseFileName(const char*);
String40  pascal RootFileName(const char*); // no extension, drive or path
String40  pascal FileNameAndExtension(const char*);
String120 pascal CleanPath(const char*); // makes sure there is a '\\' as last char

typedef String (* StringFuncPtr)(void);
typedef String40 (* String40FuncPtr)(void);
typedef String120 (* String120FuncPtr)(void);

//// Date and Time stuff ///////////////////////////////////////////////////

#ifndef NoDateStuff

extern const char* MonthName[13]; // 0 is nothing, 1 is January
extern const char* WeekdayName[7];  // 0 is Monday

class JulianDate;


class Date
  {
      int Y,M,D;  // Year, Month, Day
      friend JulianDate;
    public:
      Date(int TheYear, int TheMonth, int TheDay){Y=TheYear;M=TheMonth;D=TheDay;}
        //  Some of you programming greenhorns may be offended at the order
        //  of these parameters - more than once it paid off for me to order
        //  my stuff this way - most significant value first.
      Date(){Y=0;M=0;D=0;}
      pascal Date(const JulianDate&);
      Date(const Date& X){Y=X.Y; M=X.M; D=X.D;}
      pascal Date(const char* Text);
      int Year() const {return Y;}
      String40 pascal YearStr() const;// {return Form("@@@@",Y);}
      int Month() const {return M;}
      String40 pascal MonthStr() const;  // e.g. "January"
      String40 pascal MonthStr2() const; // e.g. "01" "02" ... "12"
      String40 pascal DayStr() const;    // e.g. "01" "02" ... "31"
      String40 pascal FullDesc() const;  // e.g. "Wednesday, September 24, 1965"
      String40 pascal ShortDesc() const; // e.g. "09-24-1965"
      String40 pascal RelativePastStr() const;
      int Day() const {return D;}
      int pascal DOW() const;
      String40 pascal DayName() const;   // e.g. "Monday"
      void SetYear(int NewYear){Y=NewYear;}
      void SetMonth(int NewMonth){M=NewMonth;}
      void SetDay(int NewDay){D=NewDay;}
      Bool pascal Valid() const; //  test to see if the date is a valid Gregorian day

      void pascal operator=(const JulianDate&);
      void operator=(const Date& X){Y=X.Y; M=X.M; D=X.D;}

      Bool pascal operator==(const JulianDate&) const;
      Bool pascal operator<=(const JulianDate&) const;
      Bool pascal operator>=(const JulianDate&) const;
      Bool pascal operator!=(const JulianDate&) const;
      Bool pascal operator<(const JulianDate&) const;
      Bool pascal operator>(const JulianDate&) const;

      JulianDate pascal operator+(long Days) const;
      JulianDate pascal operator-(long Days) const;
      long pascal operator-(const JulianDate&) const;
      JulianDate pascal operator++(); // prefix operators
      JulianDate pascal operator--();
      JulianDate pascal operator++(int);  // postfix operators
      JulianDate pascal operator--(int);
      void pascal operator+=(long Days);
      void pascal operator-=(long Days);
      #ifdef MAJORBBS
        void* operator new(size_t size){return malloc(size);}
        void  operator delete(void* p) {free(p);}
      #endif
  };

class Moment;

const long MinutesInADay=1440;

class JulianDate
  {
      long J;  //  number of days since Jan 1, 0000
      friend Date;
      friend class Moment;
    public:
      JulianDate(long JJ){J=JJ;}
      pascal JulianDate(int Year, int Month, int Day);
      JulianDate(){J=0;}
      JulianDate(const JulianDate& JJ){J=JJ.J;}
      pascal JulianDate(const Date&);
      JulianDate(const Moment& M);// {J=long(M)/MinutesInADay;}
      long Val(){return J;}
      int pascal Year() const;
      int pascal Month() const;
      int pascal Day() const;
      void pascal SetYear(int Year);
      void pascal SetMonth(int Month);
      void pascal SetDay(int Day);
      int DOW() const {return int((J-2)%7);}
      String40 pascal DayName() const;
      String40 pascal FullDesc() const;
      String40 ShortDesc(){return Date(*this).ShortDesc();}
      String40 pascal RelativePastStr(Bool AlphaDate=True) const;

      void operator=(const JulianDate& JJ){J=JJ.J;}
      void pascal operator=(const Date&);

      Bool operator==(const JulianDate& JJ) const {return Bool(J==JJ.J);}
      Bool operator<=(const JulianDate& JJ) const {return Bool(J<=JJ.J);}
      Bool operator>=(const JulianDate& JJ) const {return Bool(J>=JJ.J);}
      Bool operator!=(const JulianDate& JJ) const {return Bool(J!=JJ.J);}
      Bool operator<(const JulianDate& JJ) const {return Bool(J<JJ.J);}
      Bool operator>(const JulianDate& JJ) const {return Bool(J>JJ.J);}
      Bool operator==(long JJ) const {return Bool(J==JJ);}
      Bool operator<=(long JJ) const {return Bool(J<=JJ);}
      Bool operator>=(long JJ) const {return Bool(J>=JJ);}
      Bool operator!=(long JJ) const {return Bool(J!=JJ);}
      Bool operator<(long JJ) const {return Bool(J<JJ);}
      Bool operator>(long JJ) const {return Bool(J>JJ);}
      friend Bool operator==(long J,const JulianDate& JJ) {return Bool(J==JJ.J);}
      friend Bool operator<=(long J,const JulianDate& JJ) {return Bool(J<=JJ.J);}
      friend Bool operator>=(long J,const JulianDate& JJ) {return Bool(J>=JJ.J);}
      friend Bool operator!=(long J,const JulianDate& JJ) {return Bool(J!=JJ.J);}
      friend Bool operator<(long J,const JulianDate& JJ) {return Bool(J<JJ.J);}
      friend Bool operator>(long J,const JulianDate& JJ) {return Bool(J>JJ.J);}

      JulianDate pascal operator+(long Days) const;
      JulianDate pascal operator-(long Days) const;
      long operator-(const JulianDate& JJ) const {return J-JJ.J;}
      JulianDate operator++(){J++; return *this;}
      JulianDate operator--(){J--; return *this;}
      JulianDate pascal operator++(int);
      JulianDate pascal operator--(int);
      void operator+=(long Days){J+=Days;}
      void operator-=(long Days){J-=Days;}
      #ifdef MAJORBBS
        void* operator new(size_t size){return malloc(size);}
        void  operator delete(void* p) {free(p);}
      #endif
  };

Date pascal Today();

class Time  // still working on this one
  {
      int H; // 0..23
      int M; // 0..59
      int S; // 0..59
    public:
      Time(int TheHour=0, int TheMinute=0, int TheSecond=0)
        {H=TheHour; M=TheMinute; S=TheSecond;}
      pascal Time(const Moment&);
      String40 pascal Desc();
      String40 pascal ShortDesc();  // does not include secs
      #ifdef MAJORBBS
        void* operator new(size_t size){return malloc(size);}
        void  operator delete(void* p) {free(p);}
      #endif
  };

Time pascal CurTime();

class Moment
  {
      long M;
    public:
      Moment(long X=0){M=X;}
      Moment(const Moment& MM){M=MM.M;}
      Moment(const JulianDate& J){M=J.J*MinutesInADay;}
      pascal Moment(const JulianDate& J, const Time&);
      pascal Moment(const JulianDate& J, int Hour, int Minute);
      operator long() const {return M;}
      //operator JulianDate();//{return JulianDate(M/MinutesInADay);}
      int MinCount(){return int(M%MinutesInADay);}
      void SetMinCount(int X){M=M-MinCount()+X;}
      void operator=(long X){M=X;}
      void operator=(Moment MM){M=MM.M;}
      // comparison operators
      Bool operator==(long X) const {return (M==X);}
      Bool operator!=(long X) const {return (M!=X);}
      Bool operator<=(long X) const {return (M<=X);}
      Bool operator>=(long X) const {return (M>=X);}
      Bool operator<(long X)  const {return (M<X);}
      Bool operator>(long X)  const {return (M>X);}
      Bool operator==(Moment X) const {return (M==X.M);}
      Bool operator!=(Moment X) const {return (M!=X.M);}
      Bool operator<=(Moment X) const {return (M<=X.M);}
      Bool operator>=(Moment X) const {return (M>=X.M);}
      Bool operator<(Moment X)  const {return (M<X.M);}
      Bool operator>(Moment X)  const {return (M>X.M);}
      friend Bool operator==(long X, Moment M) {return (X==M.M);}
      friend Bool operator!=(long X, Moment M) {return (X!=M.M);}
      friend Bool operator<=(long X, Moment M) {return (X<=M.M);}
      friend Bool operator>=(long X, Moment M) {return (X>=M.M);}
      friend Bool operator<(long X, Moment M)  {return (X<M.M);}
      friend Bool operator>(long X, Moment M)  {return (X>M.M);}
      // modifiers
      void operator+=(long X){M+=X;}
      void operator+=(Moment MM);
          //{FatalError("increment a moment by a moment");} // not allowed
      void operator-=(long X){M-=X;}
      void operator-=(Moment MM);
          //{FatalError("increment a moment by a moment");} // not allowed
      Moment pascal operator-(long X);
      long operator-(Moment MM){return (M-MM.M);}
      Moment pascal operator+(long X);
      void pascal operator+(Moment);  // not allowed
      friend Moment pascal operator+(long X, Moment M);
      String40 pascal RelativeDesc();
      String40 pascal FullDesc();
      String40 pascal ShortDesc();
      String40 pascal RelativeDateStr();
      String40 pascal FullDateStr();
      String40 pascal ShortDateStr();
      String40 pascal TimeStr();
      #ifdef MAJORBBS
        void* operator new(size_t size){return malloc(size);}
        void  operator delete(void* p) {free(p);}
      #endif
  };

inline JulianDate::JulianDate(const Moment& M)
  {J=long(M)/MinutesInADay;}

Bool pascal LeapYear(int Year);

Moment pascal CurMoment();  // number of minutes passed since 1-1-0000
int pascal CurMinCount();  // number of minutes passed since midnight

#endif

//// Linked List stuff /////////////////////////////////////////////////////

struct LinkedListElement
  {
    friend class LinkedList;
    LinkedListElement *PrevRec, *NextRec;
    void* Rec;
  };

class LinkedList
  {
      LinkedListElement *RootRec, *CurRec;
      long NumRecs;
      long CurRecNum; // 0...NumRecs-1
    public:
      pascal LinkedList();
        // an empty form
      pascal ~LinkedList();
      void* pascal Root();
        // returns rec 0.  CurRec is set to RootRec.
      void* Cur() {return CurRec->Rec;}
      long Size() {return NumRecs;}
        // the number of things in list
      long Top() {return(NumRecs-1);}
      long Num() {return CurRecNum;}
        // 0..Top():  Cur's index
      void* pascal Next();
        // Cur is moved up and returned
      void* pascal Prev();
        // Cur is moved back and returned
      void* pascal Last();
        // like Root only it's the last element
      Bool pascal Insert(void* NewRec);
        // will be inserted between Prev and Cur
      Bool pascal Add(void* NewRec);
        // will be inserted between Cur and Next
      Bool pascal Append(void* NewRec);
        // will be the last record in the list
      Bool Push(void* NewRec){return Append(NewRec);}
      void pascal DelCur();
        // link is destroyed.  Cur will be old Next.  Object is not deleted
      #ifndef MAJORBBS
      void DelCurObj()  // same as DelCur cept object is destroyed too
        // Note!  Only the object memory is freed.  No object destructors are called
        {delete Cur(); DelCur();}
      #endif
      void* pascal Pop();
        // Returns pointer to last rec. Link is destroyed. Cur will be old Prev.
      void* pascal operator[](long Index);
      #ifdef MAJORBBS
        void* operator new(size_t size){return malloc(size);}
        void  operator delete(void* p) {free(p);}
      #endif
  };

#ifdef MAJORBBS

  #define CreateLinkedListClass(ClassName,ObjType)                        \
  class ClassName: public LinkedList                                      \
    {                                                                     \
      public:                                                             \
        ObjType& Root(){return *(ObjType*)LinkedList::Root();}            \
        ObjType& Last(){return *(ObjType*)LinkedList::Last();}            \
        ObjType& Cur() {return *(ObjType*)LinkedList::Cur();}             \
        ObjType& Next(){return *(ObjType*)LinkedList::Next();}            \
        ObjType& Prev(){return *(ObjType*)LinkedList::Prev();}            \
        ObjType& Pop() {return *(ObjType*)LinkedList::Pop();}             \
        Bool Insert(ObjType& NewRec){return LinkedList::Insert(&NewRec);} \
        Bool Add(ObjType& NewRec)   {return LinkedList::Add(&NewRec);}    \
        Bool Append(ObjType& NewRec){return LinkedList::Append(&NewRec);} \
        Bool Push(ObjType& NewRec)  {return LinkedList::Push(&NewRec);}   \
        ObjType& operator[](long Index)                                   \
          {return *(ObjType*)(LinkedList::operator[](Index));}            \
        void DelAllObj(); /* {while (Size()) DelCurObj();} */             \
    };

#else

  #define CreateLinkedListClass(ClassName,ObjType)                        \
                                                                          \
  class ClassName: public LinkedList                                      \
    {                                                                     \
      public:                                                             \
        ObjType& Root(){return *(ObjType*)LinkedList::Root();}            \
        ObjType& Last(){return *(ObjType*)LinkedList::Last();}            \
        ObjType& Cur() {return *(ObjType*)LinkedList::Cur();}             \
        ObjType& Next(){return *(ObjType*)LinkedList::Next();}            \
        ObjType& Prev(){return *(ObjType*)LinkedList::Prev();}            \
        ObjType& Pop() {return *(ObjType*)LinkedList::Pop();}             \
        Bool Insert(ObjType& NewRec){return LinkedList::Insert(&NewRec);} \
        Bool Add(ObjType& NewRec)   {return LinkedList::Add(&NewRec);}    \
        Bool Append(ObjType& NewRec){return LinkedList::Append(&NewRec);} \
        Bool Push(ObjType& NewRec)  {return LinkedList::Push(&NewRec);}   \
        Bool Insert(ObjType* NewRec){return LinkedList::Insert(NewRec);}  \
        Bool Add(ObjType* NewRec)   {return LinkedList::Add(NewRec);}     \
        Bool Append(ObjType* NewRec){return LinkedList::Append(NewRec);}  \
        Bool Push(ObjType* NewRec)  {return LinkedList::Push(NewRec);}    \
        ObjType& operator[](long Index)                                   \
          {return *(ObjType*)(LinkedList::operator[](Index));}            \
        void DelCurObj()                                                  \
          {delete ((ObjType*)LinkedList::Cur()); LinkedList::DelCur();}   \
        void DelAllObj(); /* {while (Size()) DelCurObj();} */             \
    }

#endif

class Queue:public LinkedList
  {
    public:
      Queue(){}
      void* pascal Pop();
  };

class Stack:public LinkedList
  {
    public:
      Stack(){}
  };

//// Vector stuff //////////////////////////////////////////////////////////

class File;

typedef const void* ConstVoidPointerType;  // xxx used to clear up cfront prob

class ByteVector
  {
      Byte huge* P; // pointer to first Byte in storage
      long Len;   // Length of vector
      long Alloc; // amount of actual storage allocated
      long Extra; // amount of extra memory to allocate when getting more memory
      void pascal ReNew(long NewCapacity);
      Byte huge& pascal Ref(long Index);
      friend class BitVector;
      void pascal Assign(const ByteVector& BV);
      void pascal FreeMemory();  // equivalent to new or delete
      Byte pascal Selectors(); // 16M only:  number of selectors used.  0 if using malloc
      friend void DebugDisp(const ByteVector& BV);
      friend class File;
      friend class ObjVec;
    public:
      pascal ByteVector();
      pascal ByteVector(int);          // although these say "int", they'll be
      pascal ByteVector(int,int);      // converted to Bytes.  "int" makes for shorter
      pascal ByteVector(int,int,int);  // mangled identifiers than "Byte"
      pascal ByteVector(int,int,int,int);
      pascal ByteVector(int,int,int,int,int);
      pascal ByteVector(int,int,int,int,int,int);
      pascal ByteVector(int,int,int,int,int,int,int);
      pascal ByteVector(int,int,int,int,int,int,int,int);
      pascal ByteVector(int,int,int,int,int,int,int,int,int);
      //  see the notes on the constructors at the end of this file
      pascal ByteVector(void* B, long Len);  // copy from some pointer
      pascal ByteVector(const ByteVector&);
      pascal ByteVector(File& F);  // read a ByteVector object from a file
      ~ByteVector(){FreeMemory();}
      void ExtraAlloc(long Quan){Extra=Quan;}
        // each time more memory is needed, this is how much extra is allocated
      Byte huge& operator[](long ByteIndex){return Ref(ByteIndex);}
        //  To access and modify specific bytes of the vector.
        //  Accessing beyond the current length will increase the vector size.
        //  Completely range protected.
      void operator=(const ByteVector& BV) {Assign(BV);}
      Bool pascal operator==(const ByteVector& S);
      Bool operator!=(const ByteVector& S) { return !(*this==S); }
      // vector concatenation
      ByteVector pascal operator+(const ByteVector& B);
      ByteVector pascal operator+(Byte B);
      friend ByteVector pascal operator+(Byte B, const ByteVector& BV);
      void pascal operator+=(const ByteVector&);
      void operator+=(Byte B) {Ref(Len)=B;}
      operator ConstVoidPointerType(){return P;}
      void pascal CopyTo(void* Dest, long Bytes=MaxSLong); // copy from vector to memory
      void pascal CopyFrom(void* Source, long Bytes); // copy from memory to vector
      //friend void operator=(void* Dest,const ByteVector& BV) {BV.CopyTo(Dest);}
      void pascal WriteTo(File& F);  // write a ByteVector object to file
      long Capacity() {return Alloc;}
      long pascal ReAlloc(long NewCapacity);
      void pascal MinimizeMemory();
        // reduce memory consumption to just what is needed now
      long Size() {return Len;}
      long pascal Index(Byte SearchByte, long StartIndex=0);
        // returns the const NotFound if the Byte is not found in the vector
        // otherwise returns the index

      Byte   pascal operator()(long ByteIndex); // return an indexed byte.
      ByteVector pascal operator()(long ByteIndex, long NumBytes); // return a subvector
      Byte   pascal At(long ByteIndex);
      ByteVector pascal At(long ByteIndex, long NumBytes);
      ByteVector Before(long ByteIndex) {return At(0,ByteIndex);}
      ByteVector Through(long ByteIndex) {return At(0,ByteIndex+1);}
      ByteVector pascal From(long ByteIndex);
      ByteVector pascal After(long ByteIndex);
      void pascal Insert(Byte B,long ByteIndex=0);
      void pascal Insert(const ByteVector& BV,long ByteIndex=0);
      void pascal Delete(long ByteIndex=0,long NumBytes=1);
      void Pop(long Quan=1){Delete(Size()-Quan,Quan);}
      void pascal Clear(Byte B=0); // set all elements to B
      void ClearFirst(long Quan) {Ref(Quan); Clear();}
        // great for initializing a vector
      long pascal Sum();
      void Empty(){Len=0;}
      void pascal Clip(long NewSize);
      #ifdef MAJORBBS
        void* operator new(size_t size){return malloc(size);}
        void  operator delete(void* p) {free(p);}
      #endif
  };

extern Bool BigVectorJump;
/* If true, then vectors in size >64k will always be allocated in chunks of
64k.  This saves on fragmentation and recopying time. Default is True. */

const DefaultVectorExtra=16;

/*

ByteVector constructors:

  I wanted to use a variable argument constructor (see your favorite texts
  on "elipsis", "...", "variable arguments" or "va_arg, va_end and
  va_start") but there were limitations that I felt could lead to very hard
  to find bugs, namely that the applications programmer must first pass a
  value that reveals how many parameters there are.  Being off by one could
  lead to a variety of problems.

  There are four ways to construct a ByteVector:

    1) ByteVector BV;

       This creates a vector that will have a length of 0 although some
       memory will be allocated so that elements may be added later (which
       is the most likely thing to happen).

    2) ByteVector BV(1,2,55,8);

       This creates a vector of length 4.  You may pass 1 to 9 parameters
       using this type of constructors.  You're limited to 9 because the
       Glock C++ name mangling mixed with MSC 5.1 limits it this way.  An
       update of either of these may solve this problem.

    3) static Byte BA[]={1,2,55,8};
       ByteVector BV(BA,4);

       This creates a vector of length 4, copying the elements from BA.
       You don't have to copy from an array of bytes, you can use any kind
       of array or even a pointer to anywhere in memory.

    4) ByteVector BV2(BV);

       Create a ByteVector from another ByteVector.

*/

/*

  Note that I use the word "Atomic" in the context that it's used in the
  LISP language, meaning language primitives such as int, long and float.

  The classes that are derived from ObjVec using the macros
  "CreateAtomicVectorClass" or "CreateRefVectorClass"are for those types of
  objects that do not need any special class constructors or destructors.
  The former macro passes values through the stack as much as possible.
  The latter passes pointers (as references).  They should both appear to
  work the same way although there may be some differences in time and
  space usage depending on your object size and how you use your vectors.

  Again, do not use objects in these vectors that cannot be bit copied,
  such as class objects that contain pointers that require stack
  maintenance.

*/

typedef int (* CompFuncPtr)(const void*,const void*);

class ObjVec: private ByteVector
  {
      int  ObjSize;  // size of struct or atomic object:  2 if int, 4 if long, etc.
      int  BlockSize; // see "BlockSize" at bottom of file
      CompFuncPtr CFP;
      void pascal CtorHelper(int);
      CompFuncPtr pascal CurCompFunc() const;
    public:
      pascal ObjVec(int ObjectSize);
      pascal ObjVec(int ObjectSize,void*);
      pascal ObjVec(int ObjectSize,void*,void*);
      pascal ObjVec(int ObjectSize,void*,void*,void*);
      pascal ObjVec(int ObjectSize,void* P, long Len);  // copy from some pointer
      pascal ObjVec(const ObjVec&);

      void pascal ExtraAlloc(long Quan);
        // when more memory is needed, how much more memory should be allocated?
      void* pascal Ref(long Index); // returns pointer to that element
      pascal operator ConstVoidPointerType() const; //{return P;}
      void pascal CopyTo(void* Dest, long Quan=MaxSLong) const; // copy from vector to memory
      void pascal CopyFrom(void* Source, long Quan); // copy to vector from memory
      void pascal WriteTo(File&) const;  // write a ObjVec object to file
      long pascal Capacity() const; // {return (Alloc/ObjSize);}
      long pascal ByteCapacity() const;
      long pascal ReAlloc(long NewCapacity);
      long pascal Size() const; // {return Len/ObjSize);}
      //friend void operator=(void* Dest,const ObjVec& V);
      void pascal operator=(const ObjVec& V);// {Assign(V);}
      //Bool operator==(ObjVec&);
      //Bool operator!=(ObjVec& V);// { return !(*this==V); }
      long pascal Index(void* SearchObj, long StartIndex) const;
      void pascal operator+=(const ObjVec&);
      ObjVec pascal Concat(const ObjVec&) const;
      ObjVec pascal Concat(void*) const;
      void pascal AppendOneObj(void*);
      ObjVec pascal PrependOneObj(void*) const; // does not modify current obj
      void pascal Insert(const ObjVec& V,long Index=0);
      void pascal Insert(void*,long Index);
      void pascal Delete(long Index=0,long Length=1);
      void Pop(long Quan=1){Delete(Size()-Quan,Quan);}
      //void Clear(int X=0); // set all elements to X
      void ClearFirst(long Quan) {Ref(Quan); Clear();}
        // great for initializing a vector
      long pascal Sum() const;
      void pascal Empty(); //{Len=0;}
      ObjVec pascal At(long,long) const;
      void* pascal At(long) const;
      ObjVec pascal From(long index) const;
      ObjVec pascal After(long index) const;
      void Clip(long NewSize){ByteVector::Clip(NewSize*BlockSize);}

      void UseIntCompFunc();
      void UseLongCompFunc();
      void UseCSCompFunc();
      void SetCompFunction(void* F){CFP=(CompFuncPtr)F;}
        // in BInsert(), FindE(), FindGE() and QSort() this function will be
        // used in the binary search.  Otherwise, int or long comps will be done
      long pascal BInsert(void* X);
        // does a binary search and then inserts X.  returns index num.  if a
        // dupe is found, nothing is inserted and the match index is returned.
      long pascal FindE(void* SearchObj) const;
        // binary search. returns index.  returns NotFound if no exact match
        // if many exact matches, uses first exact match
      long pascal FindGE(void* SearchObj) const;
        // returns NotFound if SearchObj is greater than last element
      void pascal QSort();
        // note that the sort will be limited by the limitations that come with
        // the ANSI QSort

      #ifdef MAJORBBS
        void* operator new(size_t size){return malloc(size);}
        void  operator delete(void* p) {free(p);}
      #endif
  };

#define CreateAtomicVectorClass(ClassName,ObjType)                            \
typedef int (* ObjType ## CompFuncPtr)(const ObjType*,const ObjType*);        \
class ClassName:public ObjVec                                                 \
  {                                                                           \
    public:                                                                   \
      ClassName():ObjVec(sizeof(ObjType)){}                                   \
      ClassName(ObjType X):ObjVec(sizeof(ObjType),&X){}                       \
      ClassName(ObjType X1, ObjType X2):ObjVec(sizeof(ObjType),&X1,&X2){}     \
      ClassName(ObjType X1, ObjType X2, ObjType X3)                           \
        :ObjVec(sizeof(ObjType),&X1,&X2,&X3){}                                \
      ClassName(void* X, long L):ObjVec(sizeof(ObjType),X,L){}                \
      ClassName(const ClassName& V):ObjVec(V){}                               \
      ClassName(const ObjVec& V):ObjVec(V){}                                  \
      ObjType& Ref(long Pos) {return *(ObjType*)ObjVec::Ref(Pos);}            \
      ObjType& operator[](long Pos){return *(ObjType*)ObjVec::Ref(Pos);}      \
      ObjType& Last(){return Ref(Size()-1);}                                  \
      void operator+=(ObjType X){AppendOneObj(&X);}                           \
      void operator+=(ClassName X){ObjVec::operator+=(X);}                    \
      ClassName operator+(const ClassName& V){return ObjVec::Concat(V);}      \
      ClassName operator+(ObjType X){return ObjVec::Concat(&X);}              \
      friend ClassName operator+(ObjType X, const ClassName& V1)              \
        {return V1.PrependOneObj(&X);}                                        \
      long Index(ObjType SearchObj, long StartIndex=0) const                  \
        {return ObjVec::Index(&SearchObj,StartIndex);}                        \
      ObjType operator()(long Pos) const                                      \
        {return *(ObjType*)ObjVec::At(Pos);}                                  \
      ClassName operator()(long Pos, long Length) const                       \
        {return ObjVec::At(Pos,Length);}                                      \
      ObjType At(long Pos){return *(ObjType*)ObjVec::At(Pos);}                \
      ClassName At(long Pos, long Length)                                     \
        {return ObjVec::At(Pos,Length);}                                      \
      ClassName Before(long Pos){return ObjVec::At(0,Pos);}                   \
      ClassName Through(long Pos){return ObjVec::At(0,Pos+1);}                \
      ClassName From(long Pos){return ObjVec::From(Pos);}                     \
      ClassName After(long Pos){return ObjVec::After(Pos);}                   \
      void Insert(ObjType C,long Pos=0){ObjVec::Insert(&C,Pos);}              \
      void SetCompFunction(ObjType ## CompFuncPtr FP)                         \
        {ObjVec::SetCompFunction((void*)FP);}                                 \
      long BInsert(ObjType X){return ObjVec::BInsert(&X);}                    \
      long FindE(ObjType X){return ObjVec::FindE(&X);}                        \
      long FindGE(ObjType X){return ObjVec::FindGE(&X);}                      \
  }

#define CreateRefVectorClass(ClassName,ObjType)                               \
typedef int (* ObjType ## CompFuncPtr)(const ObjType*,const ObjType*);        \
class ClassName:public ObjVec                                                 \
  {                                                                           \
    public:                                                                   \
      ClassName():ObjVec(sizeof(ObjType)){}                                   \
      ClassName(ObjType& X):ObjVec(sizeof(ObjType),&X){}                      \
      ClassName(ObjType& X1, ObjType& X2):                                    \
        ObjVec(sizeof(ObjType),&X1,&X2){}                                     \
      ClassName(ObjType& X1, ObjType& X2, ObjType& X3)                        \
        :ObjVec(sizeof(ObjType),&X1,&X2,&X3){}                                \
      ClassName(void* X, long L):ObjVec(sizeof(ObjType),X,L){}                \
      ClassName(const ClassName& V):ObjVec(V){}                               \
      ClassName(const ObjVec& V):ObjVec(V){}                                  \
      ObjType& Ref(long Pos) {return *(ObjType*)ObjVec::Ref(Pos);}            \
      ObjType& operator[](long Pos){return Ref(Pos);}                         \
      ObjType& Last(){return Ref(Size()-1);}                                  \
      void operator+=(ObjType& X){AppendOneObj(&X);}                          \
      void operator+=(ClassName X){ObjVec::operator+=(X);}                    \
      ClassName operator+(const ClassName& V){return Concat(V);}              \
      ClassName operator+(ObjType& X){return Concat(&X);}                     \
      friend ClassName operator+(ObjType& X, const ClassName& V1)             \
        {return V1.PrependOneObj(&X);}                                        \
      long Index(ObjType& SearchObj, long StartIndex=0)                       \
        {return ObjVec::Index(&SearchObj,StartIndex);}                        \
      ObjType operator()(long Pos) {return *(ObjType*)ObjVec::At(Pos);}       \
      ClassName operator()(long Pos, long Length)                             \
        {return ObjVec::At(Pos,Length);}                                      \
      ObjType At(long Pos){return *(ObjType*)ObjVec::At(Pos);}                \
      ClassName At(long Pos, long Length)                                     \
        {return ObjVec::At(Pos,Length);}                                      \
      ClassName Before(long Pos){return ObjVec::At(0,Pos);}                   \
      ClassName Through(long Pos){return ObjVec::At(0,Pos+1);}                \
      ClassName From(long Pos){return ObjVec::From(Pos);}                     \
      ClassName After(long Pos){return ObjVec::After(Pos);}                   \
      void Insert(ObjType& C,long Pos=0){ObjVec::Insert(&C,Pos);}             \
      void SetCompFunction(ObjType ## CompFuncPtr FP)                         \
        {ObjVec::SetCompFunction((void*)FP);}                                 \
      long BInsert(ObjType& X){return ObjVec::BInsert(&X);}                   \
      long FindE(ObjType& X){return ObjVec::FindE(&X);}                       \
      long FindGE(ObjType& X){return ObjVec::FindGE(&X);}                     \
  }

/*

BlockSize

  In protected mode (16M uses this - so does PharLap) when using large
  chunks of memory (beyond 64K), that represent an array of objects, the
  objects must occupy a space that has a size that is a power of two (1, 2,
  4, 8, 16, etc.). This is so that a long will not lie on a 64k boundry and
  assignments will be done to it (memory is not contiguous but, rather, in
  64k chunks managed by a table of contiguous pointers).

*/

//// File stuff ////////////////////////////////////////////////////////////


// commenting/uncommenting the following line turns FlashFile off/on (respectively)
// FlashFile is a supplementary product to BPT
// #define FlashFile

const DefBufSize=0;  // 0 means to use default

#ifdef FlashFile

  #include <BFlash.h>

#else

  const ReadAndWrite=0;
  const ReadOnly=1;
  const WriteOnly=0; // no optimization

  class LowLevelFile
    {
        FILE* FilePointer;
        Bool Open;
        char* GivenFileName;
        char* Buf; // for future use to change the size of the buffer
        void pascal InternalInit(int);
        friend class File;
        friend class TextFile;
        friend class TokenFile;
      public:
        pascal LowLevelFile(const char* FileName,const char* Mode, int BufSize);
        ~LowLevelFile() {Close();}
        void pascal Close();  // you can close the file early if you want
        void Flush() {fflush(FilePointer);}
          // flush your write buffers out to disk
        long CurPos() {return ftell(FilePointer);}
          // current file position:  where you are about to write to or read from
        void Seek(long Offset) {fseek(FilePointer,Offset,0);}
        void Shift(long Offset) {fseek(FilePointer,Offset,1);}
          // move the file pointer forward or backward
        void SeekBOF(){fseek(FilePointer,0,0);}
        void SeekEOF(){fseek(FilePointer,0,2);}
        long pascal Size();  //  the file size in bytes
        Bool EndOfFile() {return feof(FilePointer);}
        Bool Opened(){return Open;}
        #ifdef MAJORBBS
          void* operator new(size_t size){return malloc(size);}
          void  operator delete(void* p) {free(p);}
        #endif
    };

  class File:public LowLevelFile
    {
      public:
        pascal File(const char* FileName,Bool Mode=ReadAndWrite,int BufSize=0);
        Bool pascal Read(void* Buffer, long Size=1);
        void pascal Write(const void* Buffer,long Size=1);
    };

  extern char* FTMRO;  // "rt"
  extern char* FTMRW;  // "r+t"

  class TextFile:public LowLevelFile
    {
        int  MaxStrLen; // so that input buffers don't get swamped
        Bool Started;  // used to figure out whether we're starting off appending or reading
      public:
        TextFile(const char* FileName,Bool Mode=ReadAndWrite,int BufSize=0):
            LowLevelFile(FileName,((Mode==ReadOnly)?(FTMRO):(FTMRW)),BufSize)
            {Started=False; MaxStrLen=MaxInt;}
        void Seek(long Offset) {Started=True; LowLevelFile::Seek(Offset);}
        Bool pascal Read(char* S);
        void pascal Write(int Ch);
        void pascal Write(const char* S);
        void pascal WriteLine(const char* S=NULL);
        int  MaxLineLength(){return MaxStrLen;} // default is MaxInt
        void SetMaxLineLength(int L){MaxStrLen=L;}
    };

#endif

#ifdef MAJORBBS

  Bool FileExists(const char*);

#else

  #define FileExists(FileName) (!access(FileName,0))
    // returns True if the file exists

#endif

char pascal CurDiskDrive();
inline void pascal SetDiskDrive(char D) // must be uppercase!
  {setdisk(D-'A');}

long pascal DiskSpace(const char Drive='.');  // '.' means default drive
  // the value returned is in "K" or "kilobytes" or number of 1024 byte blocks
  // this is in case this library is on a computer that can handle capacity
  // of more than 2 gigs that a "long" could represent.

long pascal FileSize(const char* FileName);
  // the value returned is in bytes

#define WriteThing(A) Write(&A,sizeof(A))
#define ReadThing(A) Read(&A,sizeof(A))
  // use only on things where the size can be properly determined with
  // "sizeof".  Use only with "File" not "TextFile"

void pascal DeleteFile(const char* FileName);
  // if the file is deletable, it's deleted

void pascal SetCopyGrind(VoidFuncPtr);
  // if you set this just before doing a copy, this func will be called
  // periodically during the copy

void pascal FileCopying(File& DestFile, File& SourceFile, long Size);
  // will not modify file positions before writing

void pascal CopyFile(const char* DestFile, const char* SourceFile);
  // source file must be created.  if dest file already exists,
  // it will be deleted

Word pascal CRC(File& F,long FSize);  // CRC of file starting at current pos
Word pascal CRC(File& F);  // CRC of entire file

//////////////////////// TokenFile stuff

struct FreeBlock
  {
    long Size;
    long Pos;
  };

CreateRefVectorClass(FreeListVec,FreeBlock);

class TokenFile: public File
  {
      long MaxTokens;
      long NextFreeToken;
      FreeListVec Free;
      long pascal FindSpace(long FSize);
        // returns a block number that can hold "FSize" and updates the
        // free list if needed
      void pascal Delete(long Pos, long Size);
        // adds this info to the free list
      void SeekIndexSlot(long Token) {File::Seek(Token*8);}
      void pascal ReadCurIndexSlot(long& Pos, long& Size);
      void pascal ExtendedReportData(long& TokensInUse,long& ADABytesInUse);
      friend void TokenReport(const char* N,Bool L=No);
    public:
      pascal TokenFile(const char* FileName, int BufSize=DefBufSize);
      ~TokenFile(){Close();}
      void pascal Close();
      long pascal Seek(long Token);
        /*  returns the size of your object (0 if it doesn't exist).  If
        object is found, file pointer is moved to your objects storage
        location.  You may then read your data with any binary file type
        read.  There will be nothing to stop you from reading too much */
      void pascal WritePrep(long Token,long DataSize);
        /* sets up Token with a data area of just the right size.  Any
        previous data under that Token is deleted.  File pointer is left
        where writing may begin */
      void pascal Delete(long Token);
        // makes the space that was taken by Token's object available
      long MaxToken(){return MaxTokens;}
      long pascal TokenExists(long Token);  // returns size allocated for token
      void pascal Extract(long Token,const char* FileName);
      long pascal NewToken();
        // will provide an unused token number
      long pascal NewToken(long DataSize);
        // will provide an unused token number and then WritePrep()
  };

void pascal CreateTokenFile(const char* FileName, long NumTokens);
  // creates the file and then closes it

Bool pascal TokenExists(const char* FileName, long Token);

//// Directory / DOS / BIOS stuff ///////////////////////////////////////////

typedef char FileNameType[13];

#ifndef NoDateStuff

struct DirElementType
  {
    FileNameType Name;
    Moment M;
  };

CreateLinkedListClass(Directory,DirElementType);

void pascal LoadDirectory(const char* DirMask,Moment StartMoment,Directory& D);
void pascal LoadDirectory(const char* DirMask,Directory& D);
long pascal DirCount(const char* DirMask);  // how many files match dirmask

#endif

typedef union
  {
    REGS R;
    Word W[7];
    Byte B[8];
  } URegsType;

class Registers
  {
      URegsType UR;
      friend void CallBIOS(Byte IntNum, Registers& R);
    public:
      Registers(Word ax=0,Word bx=0,Word cx=0,Word dx=0)
          {AX()=ax;BX()=bx;CX()=cx;DX()=dx;}
      Word& AX(){return UR.W[0];}
      Word& BX(){return UR.W[1];}
      Word& CX(){return UR.W[2];}
      Word& DX(){return UR.W[3];}
      Word& SI(){return UR.W[4];}
      Word& DI(){return UR.W[5];}
      UInt& Flags(){return UR.R.x.flags;}
      Bool CF(){return ((UR.R.x.flags&1)>0);}
      Bool PF(){return ((UR.R.x.flags&4)>0);}
      Bool AF(){return ((UR.R.x.flags&16)>0);}
      Bool ZF(){return ((UR.R.x.flags&64)>0);}
      Bool SF(){return ((UR.R.x.flags&128)>0);}
      Bool TF(){return ((UR.R.x.flags&256)>0);}
      Bool IF(){return ((UR.R.x.flags&512)>0);}
      Bool DF(){return ((UR.R.x.flags&1024)>0);}
      Bool OF(){return ((UR.R.x.flags&2048)>0);}
      Byte& AL(){return UR.B[0];}
      Byte& AH(){return UR.B[1];}
      Byte& BL(){return UR.B[2];}
      Byte& BH(){return UR.B[3];}
      Byte& CL(){return UR.B[4];}
      Byte& CH(){return UR.B[5];}
      Byte& DL(){return UR.B[6];}
      Byte& DH(){return UR.B[7];}
      #ifdef MAJORBBS
        void* operator new(size_t size){return malloc(size);}
        void  operator delete(void* p) {free(p);}
      #endif
  };

inline void CallBIOS(Byte IntNum, Registers& R){int86(IntNum,&R.UR.R,&R.UR.R);}

CreateAtomicVectorClass(IntVector,int);
CreateAtomicVectorClass(LongVector,long);
CreateAtomicVectorClass(CSVector,CharStar);

// for access by BitVector only
class BitRef
  {
      Byte huge* P;  // pointer to byte containing bit
      Byte M;   // mask for bit
      friend BitVector;
    public:
      pascal BitRef(Byte huge* BP, long BitOffset); // non-inlined due to 16M stuff
      #ifdef BorlandFixedByteMath
        operator Bool()         { return ((*P & M) != 0); }
        Bool operator=(Bool b)
          {
            if (b) *P |= M;
            else *P &= ~M;
            return b;
          }
        void operator&=(Bool b) { if (!b) *P &= ~M; }
        void operator|=(Bool b) { if (b) *P |= M; }
        void operator^=(Bool b) { if (b) *P ^= M; }
      #else
        operator Bool()         { return ((int(*P) & int(M)) != 0); }
        Bool pascal operator=(Bool b);
        void pascal operator&=(Bool b);
        void pascal operator|=(Bool b);
        void pascal operator^=(Bool b);
      #endif
      #ifdef MAJORBBS
        void* operator new(size_t size){return malloc(size);}
        void  operator delete(void* p) {free(p);}
      #endif
  };

class BitVector : public ByteVector
  {
      long BitLen; // the number of bits used
      void pascal CtorsHelper(const long* LP,long Length);
    public:
      //  see the notes on the constructors at the end of this file
      pascal BitVector();
      pascal BitVector(long);
      pascal BitVector(long,long);
      pascal BitVector(long,long,long);
      pascal BitVector(long,long,long,long);
      pascal BitVector(long,long,long,long,long);
      pascal BitVector(long,long,long,long,long,long);
      pascal BitVector(long,long,long,long,long,long,long);
      pascal BitVector(long,long,long,long,long,long,long,long);
      pascal BitVector(long,long,long,long,long,long,long,long,long);
      pascal BitVector(const BitVector&);
      BitRef pascal Ref(long BitIndex);
      BitRef pascal operator[](long BitIndex);
        /* used for setting or retrieving bit elements.  Accessing beyond the
           last bit will make this vector longer. */
      Bool operator()(long BitIndex) const {return At(BitIndex);}
        /* used for reading bits only.  Accessing beyond the last bit will
           return a 0 (False).  This is much faster than [] */
      Bool pascal At(long BitIndex) const;
      BitVector operator()(long BitIndex,long Bits) const {return At(BitIndex,Bits);}
        // for a subset
      BitVector pascal At(long BitIndex, long Bits) const;
      BitVector pascal Before(long BitIndex) const {return At(0,BitIndex);}
      BitVector pascal Through(long BitIndex) const {return At(0,BitIndex+1);}
      BitVector pascal From(long BitIndex) const;
      BitVector pascal After(long BitIndex) const;
      void Toggle(long BitIndex){Ref(BitIndex)=!At(BitIndex);}
      void pascal operator=(const BitVector&);
      BitVector pascal operator!() const;
      BitVector pascal operator&(const BitVector&) const;
      BitVector pascal operator^(const BitVector&) const;
      BitVector pascal operator|(const BitVector&) const;
      void pascal operator&=(const BitVector&);
      void pascal operator^=(const BitVector&);
      void pascal operator|=(const BitVector&);
      void pascal ReAlloc(long NewCapacity);
      long Size() const {return BitLen;}
      long ByteSize() const {return Len;}
      void pascal ClearRange(long Index1,long Index2);
      void pascal SetRange(long Index1,long Index2,Bool X=On);
      pascal operator String() const;
  };

inline long BytesNeeded(long NumBits) {return(((NumBits-1)/8)+1);}

/*

BitVector constructors:

  I wanted to use a variable argument constructor (see your favorite texts
  on "elipsis", "...", "variable arguments" or "va_arg, va_end and
  va_start") but there were limitations that I felt could lead to very hard
  to find bugs, namely that the applications programmer must first pass a
  value that reveals how many parameters there are.  Being off by one could
  lead to a variety of problems.

  There are four ways to construct a BitVector:

    1) BitVector BV;

       This creates a vector that will have a length of 0 although some
       memory will be allocated so that elements may be added later (which
       is the most likely thing to happen).

    2) BitVector BV(1,2,55,8);

       This creates a bit vector of length 56 (7 bytes long minimum).  All
       of the bits are 0 (False) except for bits 1, 2, 55 and 8 which are 1
       (True).  You may pass 1 to 9 parameters using this type of
       constructor.

    3) static Byte BA[]={1,2,55,8};
       BitVector BV(BA,4);

       This creates a vector of length 4, copying the elements from BA.
       You don't have to copy from an array of bytes, you can use any kind
       of array or even a pointer to anywhere in memory.

    4) BitVector BV2(BV);

       Create a BitVector from another BitVector.

*/

// for access by BitSets only
class BitSetRef
  {
      Byte* P;  // pointer to byte containing bit
      Byte M;   // mask for bit
    public:
      pascal BitSetRef(Byte* BP, int BitOffset);
      #ifdef BorlandFixedByteMath
        operator Bool() const { return ((*P & M) != 0); }
        void operator&=(Bool b) { if (!b) *P &= ~M; }
        void operator|=(Bool b) { if (b) *P |= M; }
        void operator^=(Bool b) { if (b) *P ^= M; }
      #else
        operator Bool() const { return ((int(*P) & int(M)) != 0); }
        void pascal operator&=(Bool b);
        void pascal operator|=(Bool b);
        void pascal operator^=(Bool b);
      #endif
      Bool pascal operator=(Bool b);
      #ifdef MAJORBBS
        void* operator new(size_t size){return malloc(size);}
        void  operator delete(void* p) {free(p);}
      #endif
  };

void pascal ClearBitRange(void* P, long Index1,long Index2);
void pascal SetBitRange(void* P, long Index1,long Index2,Bool X=On);
void pascal QSB(Byte*P, int Index, Bool X=On); // Quick Set Bit for BitSet classes

#define CreateBitSetClass(ClassName,BitQuan)                                  \
class ClassName                                                               \
  {                                                                           \
      Byte B[(BitQuan+7)/8];                                                  \
    public:                                                                   \
      ClassName(){memset(&B[0],0,(BitQuan+7)/8);}                             \
      ClassName(const ClassName& BS){memcpy(&B[0],&(BS.B[0]),(BitQuan+7)/8);} \
      ClassName(int I1){memset(&B[0],0,(BitQuan+7)/8); Ref(I1)=On;}           \
      ClassName(int I1, int I2){memset(&B[0],0,(BitQuan+7)/8);                \
        Ref(I1)=On; Ref(I2)=On;}                                              \
      ClassName(int I1, int I2, int I3){memset(&B[0],0,(BitQuan+7)/8);        \
        QSB(B,I1); QSB(B,I2); QSB(B,I3);}                                     \
      ClassName(int I1, int I2, int I3, int I4){memset(&B[0],0,(BitQuan+7)/8);\
        QSB(B,I1); QSB(B,I2); QSB(B,I3); QSB(B,I4);}                          \
      ClassName(int I1,int I2,int I3,int I4,int I5)                           \
        {memset(&B[0],0,(BitQuan+7)/8); QSB(B,I1); QSB(B,I2); QSB(B,I3);      \
         QSB(B,I4); QSB(B,I5);}                                               \
      ClassName(int I1,int I2,int I3,int I4,int I5,int I6)                    \
        {memset(&B[0],0,(BitQuan+7)/8); QSB(B,I1); QSB(B,I2); QSB(B,I3);      \
         QSB(B,I4); QSB(B,I5); QSB(B,I6);}                                    \
      ClassName(int I1,int I2,int I3,int I4,int I5,int I6,int I7)             \
        {memset(&B[0],0,(BitQuan+7)/8); QSB(B,I1); QSB(B,I2); QSB(B,I3);      \
         QSB(B,I4); QSB(B,I5); QSB(B,I6); QSB(B,I7);}                         \
      BitSetRef Ref(int BitIndex) {return BitSetRef(&B[0],BitIndex);}         \
      BitSetRef operator[](int BitIndex){return BitSetRef(&B[0],BitIndex);}   \
      Bool At(int BitIndex)const                                              \
        {return ((B[BitIndex/8] & (1<<(BitIndex%8)) )!=0);}                   \
      Bool operator()(int BitIndex) const                                     \
        {return ((B[BitIndex/8] & (1<<(BitIndex%8)) )!=0);}                   \
      void Toggle(int BitIndex){Ref(BitIndex)=!At(BitIndex);}                 \
      void SetRange(int Index1, int Index2, Bool OnOrOff=On)                  \
        {SetBitRange(&B[0],Index1,Index2,OnOrOff);}                           \
      void ClearRange(int Index1, int Index2)                                 \
        {ClearBitRange(&B[0],Index1,Index2);}                                 \
      void SetAll(Bool OnOrOff=On) {SetBitRange(&B[0],0,BitQuan-1,OnOrOff);}  \
      void ClearAll() {ClearBitRange(&B[0],0,BitQuan-1);}                     \
      long& L(){return *((long*)&B[0]);}                                      \
      int&  I(){return *((int*)&B[0]);}                                       \
      char& C(){return *((char*)&B[0]);}                                      \
  }

#ifdef MAJORBBS
  #error need to add these lines to above...
      void* operator new(size_t size){return malloc(size);}
      void  operator delete(void* p) {free(p);}
#endif

CreateBitSetClass(BitSet8,8);
CreateBitSetClass(BitSet16,16);
CreateBitSetClass(BitSet32,32);

#define Bit0 1
#define Bit1 2
#define Bit2 4
#define Bit3 8
#define Bit4 16
#define Bit5 32
#define Bit6 64
#define Bit7 128
#define Bit8 256
#define Bit9 512
#define Bit10 1024
#define Bit11 2048
#define Bit12 4096
#define Bit13 8192
#define Bit14 16384
#define Bit15 32768
#define Bit16 65536
#define Bit17 131072
#define Bit18 262144
#define Bit19 524288
#define Bit20 1048576
#define Bit21 2097152
#define Bit22 4194304
#define Bit23 8388608
#define Bit24 16777216
#define Bit25 33554432
#define Bit26 67108864
#define Bit27 134217728
#define Bit28 268435456
#define Bit29 536870912
#define Bit30 1073741824
#define Bit31 2147483648

#endif
