/************************************************************************
 *									*
 *  Copyright (c) 1987							*
 *  by CompuServe Incorporated, Columbus, Ohio				*
 *									*
 *  The information in ths software is subject to change without	*
 *  notice and should not be construed as a commitment by CompuServe	*
 *  Incorporated							*
 *									*
 ************************************************************************/

/**
 * File:  BPSLAVE.H
 *
 * Facility:  B protocol FILTRN
 *
 * Abstract:
 *	'C' header for B protocol file transfer handler
 *
 * Environment:  None specified
 *
 * Author:  John Pampuch, November 5, 1987
 *
 * Modified by:
 *
 * 1	John Pampuch, December 8, 1987
 *	- Original
 *
 * 2	John Pampuch, January 5, 1988
 * 	- changes to remove unneeded structure nesting
 *
 **/

#ifndef BPSLAVE_H
#define BPSLAVE_H

#include "bppacket.h"

/*
 * return codes to be used by Create 
 */
#define Overwrite	0
#define Resume		1
#define Abort		2
#define Rename		3

/*
 * parameter values for Create (offer resume)
 */
#define Resume_Allowed		0
#define Resume_Not_Allowed	1
#define Resume_Failed		2

/*
 * Transfer mode values
 */
#define ASCII_Data	0
#define Binary_Data	1

#define Receiving_File	0
#define Sending_File	1
#define Resume_Receive	2
#define Resume_Send	3

#define Resume_Receive_Attempt	4
#define Resume_Send_Attempt	5

typedef struct APDBstruct
    {
    /*
     * This part of this structure is the packet level descriptor
     * block.  Generally, the pointer to this entire structure is
     * passed on to BP_Packet, and it uses the stuff it needs that
     * is contained here.
     */
    Protocol_Desc_Block *Packet;

    /*
     * This second part is the additional facilities needed by the
     * application level routines
     */

    BOOL (*Wants_to_Abort) (void);	/* must return True if user has */
					/* requested an abort */

    /* routines to display application level user status */
    void (*Data_Sent) (UWORD);
    void (*Data_Read) (UWORD);
    void (*Display_Msg) (BYTE *);
    void (*Display_File) (BYTE *);
    void (*Display_Size) (ULONG);
    void (*Show_Transfer_Mode)		    /* specifies transfer type */
	(WORD, WORD, WORD);		    /* direction, and actual */
					    /* check method */

    /* file IO routines */
    /* each return Success or Failure as result code */
    WORD (*Create) (BYTE *, WORD, BOOL, WORD *);
    		 /* name, mode, offer resume, resume result code */
    WORD (*Open) (BYTE *, WORD);
    WORD (*Close) (WORD);
    WORD (*Read) (WORD, BYTE *, WORD);
    WORD (*Write) (WORD, BYTE *, WORD);
    LONG (*Size) (WORD);		/* return size of file in bytes */
    void (*MoveToEnd) (WORD);		/* move to end for writing */

    /*
     * Transfer dependent storage
     *
     */
    }
Application_PDB;

/* public routine to handle B protocol file transfer */
/* assumes that DLE B has been seen by terminal application */
public WORD BP_Handle_Slave_BP(Application_PDB *);

#endif
